/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.tx;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.Lock;
import org.jboss.as.ejb3.util.ThreadLocalStack;

public class OwnableReentrantLock
extends AbstractQueuedSynchronizer
implements Lock {
    private static final long serialVersionUID = 493297473462848792L;
    private final ThreadLocalStack currentRequestor = new ThreadLocalStack();
    private transient Object owner;

    protected Object currentRequestor() {
        return this.currentRequestor.get();
    }

    public void pushOwner(Object owner) {
        this.currentRequestor.push(owner);
    }

    public void popOwner() {
        this.currentRequestor.pop();
    }

    @Override
    public void lock() {
        if (this.compareAndSetState(0, 1)) {
            this.owner = this.currentRequestor();
        } else {
            this.acquire(1);
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.acquireInterruptibly(1);
    }

    @Override
    public boolean tryLock() {
        return this.tryAcquire(1);
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        return this.tryAcquireNanos(1, unit.toNanos(time));
    }

    @Override
    public void unlock() {
        try {
            this.release(1);
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    @Override
    public AbstractQueuedSynchronizer.ConditionObject newCondition() {
        throw new UnsupportedOperationException("Not supported in this implementation!");
    }

    @Override
    protected final boolean tryAcquire(int acquires) {
        Object current = this.currentRequestor();
        int c = this.getState();
        if (c == 0) {
            if (this.compareAndSetState(0, acquires)) {
                this.owner = current;
                return true;
            }
        } else if (current.equals(this.owner)) {
            this.setState(c + acquires);
            return true;
        }
        return false;
    }

    @Override
    protected final boolean tryRelease(int releases) {
        int c = this.getState() - releases;
        if (!this.currentRequestor().equals(this.owner)) {
            return false;
        }
        boolean free = false;
        if (c == 0) {
            free = true;
            this.owner = null;
        }
        this.setState(c);
        return free;
    }

    @Override
    protected final boolean isHeldExclusively() {
        return this.getState() != 0 && this.currentRequestor().equals(this.owner);
    }

    public final Object getOwner() {
        int c = this.getState();
        Object o = this.owner;
        return c == 0 ? null : o;
    }

    public final int getHoldCount() {
        int c = this.getState();
        Object o = this.owner;
        return this.currentRequestor().equals(o) ? c : 0;
    }

    public final boolean isLocked() {
        return this.getState() != 0;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.setState(0);
    }

    @Override
    public String toString() {
        Object owner = this.getOwner();
        return super.toString() + (owner == null ? "[Unlocked]" : "[Locked by " + owner + "]");
    }
}

