/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class Tag {
    QName name;
    Map<QName, String> attributes;
    String text;
    List<Tag> tags;
    Tag parent;
    List<String> ignoreAttr;

    public List<String> getIgnoreAttr() {
        if (this.ignoreAttr == null) {
            this.ignoreAttr = new ArrayList<String>();
        }
        return this.ignoreAttr;
    }

    public Tag getParent() {
        return this.parent;
    }

    public void setParent(Tag nTag) {
        this.parent = nTag;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ArrayList<Tag>();
        }
        return this.tags;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String nText) {
        this.text = nText;
    }

    public QName getName() {
        return this.name;
    }

    public void setName(QName nName) {
        this.name = nName;
    }

    public Map<QName, String> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<QName, String>();
        }
        return this.attributes;
    }

    private String createIndent(int size) {
        String indent = "    ";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append(indent);
        }
        return sb.toString();
    }

    private String formatAttribute(Tag tag) {
        StringBuilder sb = new StringBuilder();
        sb.append(tag.getName().getLocalPart());
        sb.append(" ");
        for (Map.Entry<QName, String> attr : tag.getAttributes().entrySet()) {
            sb.append(attr.getKey());
            sb.append("=\"");
            sb.append(attr.getValue());
            sb.append("\" ");
        }
        return sb.toString().trim();
    }

    private String formatTag(Tag tag, int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.createIndent(indent));
        sb.append(indent);
        sb.append("<");
        sb.append(this.formatAttribute(tag));
        sb.append(">");
        if (tag.getParent() != null) {
            sb.append(" (" + tag.getParent().getName().getLocalPart() + ")");
        }
        if (this.text != null) {
            sb.append(this.text);
        }
        sb.append("\n");
        if (tag.getTags().size() > 0) {
            ++indent;
            for (Tag subTag : tag.getTags()) {
                sb.append(this.formatTag(subTag, indent));
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.formatTag(this, 0));
        return sb.toString();
    }

    public int hashCode() {
        return this.getName().hashCode() + ((Object)this.getAttributes()).hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Tag)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        Tag tag = (Tag)object;
        if (!this.getName().equals(tag.getName())) {
            return false;
        }
        for (QName attr : this.getAttributes().keySet()) {
            if (this.getIgnoreAttr().contains(attr.getLocalPart()) || this.getIgnoreAttr().contains(this.getName().getLocalPart() + "@" + attr.getLocalPart())) continue;
            if (!tag.getAttributes().containsKey(attr)) {
                return false;
            }
            if (tag.getAttributes().get(attr).equals(this.getAttributes().get(attr))) continue;
            return false;
        }
        return true;
    }
}

