/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import org.apache.lucene.search.Filter;
import org.hibernate.search.query.dsl.SpatialContext;
import org.hibernate.search.query.dsl.SpatialMatchingContext;
import org.hibernate.search.query.dsl.impl.ConnectedQueryBuilder;
import org.hibernate.search.query.dsl.impl.ConnectedSpatialMatchingContext;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.impl.QueryCustomizer;
import org.hibernate.search.query.dsl.impl.SpatialQueryContext;

public class ConnectedSpatialContext
implements SpatialContext {
    private final QueryBuildingContext queryContext;
    private final QueryCustomizer queryCustomizer;
    private final SpatialQueryContext spatialContext;
    private final ConnectedQueryBuilder queryBuilder;

    public ConnectedSpatialContext(QueryBuildingContext context, ConnectedQueryBuilder queryBuilder) {
        this.queryContext = context;
        this.queryCustomizer = new QueryCustomizer();
        this.queryCustomizer.withConstantScore();
        this.spatialContext = new SpatialQueryContext();
        this.queryBuilder = queryBuilder;
    }

    @Override
    public SpatialMatchingContext onCoordinates(String field) {
        this.spatialContext.setCoordinatesField(field);
        return new ConnectedSpatialMatchingContext(this.queryContext, this.queryCustomizer, this.spatialContext, this.queryBuilder);
    }

    @Override
    public SpatialMatchingContext onDefaultCoordinates() {
        this.spatialContext.setDefaultCoordinatesField();
        return new ConnectedSpatialMatchingContext(this.queryContext, this.queryCustomizer, this.spatialContext, this.queryBuilder);
    }

    @Override
    public SpatialContext boostedTo(float boost) {
        this.queryCustomizer.boostedTo(boost);
        return this;
    }

    @Override
    public SpatialContext withConstantScore() {
        this.queryCustomizer.withConstantScore();
        return this;
    }

    @Override
    public SpatialContext filteredBy(Filter filter) {
        this.queryCustomizer.filteredBy(filter);
        return this;
    }
}

