/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import javax.ejb.EJBException;
import javax.ejb.TransactionManagementType;
import javax.transaction.Synchronization;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInstanceInterceptorFactory;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.interceptors.AbstractEJBInterceptor;
import org.jboss.as.ejb3.component.stateful.StatefulComponentInstanceInterceptor;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentInstance;
import org.jboss.as.ejb3.component.stateful.StatefulTransactionMarker;
import org.jboss.as.ejb3.concurrency.AccessTimeoutDetails;
import org.jboss.as.ejb3.tx.OwnableReentrantLock;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;

public class StatefulSessionSynchronizationInterceptor
extends AbstractEJBInterceptor {
    private final boolean containerManagedTransactions;
    private static final Factory CONTAINER_MANAGED = new Factory(TransactionManagementType.CONTAINER);
    private static final Factory BEAN_MANAGED = new Factory(TransactionManagementType.BEAN);

    public static InterceptorFactory factory(TransactionManagementType type) {
        return type == TransactionManagementType.CONTAINER ? CONTAINER_MANAGED : BEAN_MANAGED;
    }

    public StatefulSessionSynchronizationInterceptor(boolean containerManagedTransactions) {
        this.containerManagedTransactions = containerManagedTransactions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processInvocation(InterceptorContext context) throws Exception {
        StatefulSessionComponent component = StatefulSessionSynchronizationInterceptor.getComponent(context, StatefulSessionComponent.class);
        StatefulSessionComponentInstance instance = StatefulComponentInstanceInterceptor.getComponentInstance(context);
        OwnableReentrantLock lock = instance.getLock();
        Object threadLock = instance.getThreadLock();
        TransactionSynchronizationRegistry transactionSynchronizationRegistry = component.getTransactionSynchronizationRegistry();
        Object lockOwner = StatefulSessionSynchronizationInterceptor.getLockOwner(transactionSynchronizationRegistry);
        lock.pushOwner(lockOwner);
        try {
            boolean acquired;
            AccessTimeoutDetails timeout = component.getAccessTimeout(context.getMethod());
            if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
                EjbLogger.ROOT_LOGGER.trace("Trying to acquire lock: " + lock + " for stateful component instance: " + instance + " during invocation: " + context);
            }
            if (!(acquired = lock.tryLock(timeout.getValue(), timeout.getTimeUnit()))) {
                throw EjbMessages.MESSAGES.failToObtainLock(context, timeout.getValue(), timeout.getTimeUnit());
            }
            Object object = threadLock;
            synchronized (object) {
                Object object2;
                block24: {
                    if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
                        EjbLogger.ROOT_LOGGER.trace("Acquired lock: " + lock + " for stateful component instance: " + instance + " during invocation: " + context);
                    }
                    Object currentTransactionKey = null;
                    boolean wasTxSyncRegistered = false;
                    try {
                        if (this.containerManagedTransactions) {
                            if (!instance.isSynchronizationRegistered()) {
                                currentTransactionKey = transactionSynchronizationRegistry.getTransactionKey();
                                int status = transactionSynchronizationRegistry.getTransactionStatus();
                                if (currentTransactionKey != null && status != 3 && status != 4) {
                                    StatefulSessionSynchronization statefulSessionSync = new StatefulSessionSynchronization(instance, lockOwner);
                                    transactionSynchronizationRegistry.registerInterposedSynchronization((Synchronization)statefulSessionSync);
                                    wasTxSyncRegistered = true;
                                    if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
                                        EjbLogger.ROOT_LOGGER.trace("Registered tx synchronization: " + statefulSessionSync + " for tx: " + currentTransactionKey + " associated with stateful component instance: " + instance);
                                    }
                                    instance.afterBegin();
                                    instance.setSynchronizationRegistered(true);
                                    context.putPrivateData(StatefulTransactionMarker.class, (Object)StatefulTransactionMarker.of(true));
                                }
                            } else {
                                context.putPrivateData(StatefulTransactionMarker.class, (Object)StatefulTransactionMarker.of(false));
                            }
                        }
                        object2 = context.proceed();
                        if (!wasTxSyncRegistered && !instance.isSynchronizationRegistered()) {
                            this.releaseInstance(instance);
                            break block24;
                        }
                        if (wasTxSyncRegistered) break block24;
                        this.releaseLock(instance);
                    }
                    catch (Throwable throwable) {
                        if (!wasTxSyncRegistered && !instance.isSynchronizationRegistered()) {
                            this.releaseInstance(instance);
                        } else if (!wasTxSyncRegistered) {
                            this.releaseLock(instance);
                            if (!instance.isDiscarded()) {
                                instance.getComponent().getCache().release(instance);
                            }
                        }
                        throw throwable;
                    }
                    if (!instance.isDiscarded()) {
                        instance.getComponent().getCache().release(instance);
                    }
                }
                return object2;
            }
        }
        finally {
            lock.popOwner();
        }
    }

    private static Object getLockOwner(TransactionSynchronizationRegistry transactionSynchronizationRegistry) {
        Object owner = transactionSynchronizationRegistry.getTransactionKey();
        return owner != null ? owner : Thread.currentThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseInstance(StatefulSessionComponentInstance instance) {
        try {
            if (!instance.isDiscarded()) {
                instance.getComponent().getCache().release(instance);
            }
        }
        finally {
            instance.setSynchronizationRegistered(false);
            this.releaseLock(instance);
        }
    }

    void releaseLock(StatefulSessionComponentInstance instance) {
        instance.getLock().unlock();
        if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
            EjbLogger.ROOT_LOGGER.tracef("Released lock: %s", instance.getLock());
        }
    }

    private class StatefulSessionSynchronization
    implements Synchronization {
        private final StatefulSessionComponentInstance statefulSessionComponentInstance;
        private final Object lockOwner;

        StatefulSessionSynchronization(StatefulSessionComponentInstance statefulSessionComponentInstance, Object lockOwner) {
            this.statefulSessionComponentInstance = statefulSessionComponentInstance;
            this.lockOwner = lockOwner;
        }

        public void beforeCompletion() {
            try {
                if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
                    EjbLogger.ROOT_LOGGER.trace("Before completion callback invoked on Transaction synchronization: " + this + " of stateful component instance: " + this.statefulSessionComponentInstance);
                }
                if (!this.statefulSessionComponentInstance.isDiscarded()) {
                    this.statefulSessionComponentInstance.beforeCompletion();
                }
            }
            catch (Throwable t) {
                this.handleThrowable(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            boolean committed = status == 3;
            try {
                if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
                    EjbLogger.ROOT_LOGGER.trace("After completion callback invoked on Transaction synchronization: " + this + " of stateful component instance: " + this.statefulSessionComponentInstance);
                }
                if (!this.statefulSessionComponentInstance.isDiscarded()) {
                    this.statefulSessionComponentInstance.afterCompletion(committed);
                }
            }
            catch (Throwable t) {
                this.handleThrowable(t);
            }
            if (this.statefulSessionComponentInstance.isRemoved() && !this.statefulSessionComponentInstance.isDiscarded()) {
                try {
                    this.statefulSessionComponentInstance.destroy();
                }
                catch (Throwable t) {
                    this.handleThrowable(t);
                }
            }
            this.statefulSessionComponentInstance.getLock().pushOwner(this.lockOwner);
            try {
                StatefulSessionSynchronizationInterceptor.this.releaseInstance(this.statefulSessionComponentInstance);
            }
            finally {
                this.statefulSessionComponentInstance.getLock().popOwner();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleThrowable(Throwable t) {
            EjbLogger.ROOT_LOGGER.discardingStatefulComponent(this.statefulSessionComponentInstance, t);
            try {
                this.statefulSessionComponentInstance.discard();
            }
            finally {
                this.statefulSessionComponentInstance.getLock().pushOwner(this.lockOwner);
                try {
                    StatefulSessionSynchronizationInterceptor.this.releaseLock(this.statefulSessionComponentInstance);
                }
                finally {
                    this.statefulSessionComponentInstance.getLock().popOwner();
                }
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw (EJBException)new EJBException().initCause(t);
        }
    }

    private static class Factory
    extends ComponentInstanceInterceptorFactory {
        private final TransactionManagementType type;

        public Factory(TransactionManagementType type) {
            this.type = type;
        }

        protected Interceptor create(Component component, InterceptorFactoryContext context) {
            return new StatefulSessionSynchronizationInterceptor(this.type == TransactionManagementType.CONTAINER);
        }
    }
}

