/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamConstants;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DefaultCheckersAndConverter;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.wildfly.extension.mod_cluster.CustomLoadMetricDefinition;
import org.wildfly.extension.mod_cluster.DynamicLoadProviderDefinition;
import org.wildfly.extension.mod_cluster.LoadMetricDefinition;
import org.wildfly.extension.mod_cluster.ModClusterConfigResourceDefinition;
import org.wildfly.extension.mod_cluster.ModClusterDefinition;
import org.wildfly.extension.mod_cluster.ModClusterLogger;
import org.wildfly.extension.mod_cluster.ModClusterMessages;
import org.wildfly.extension.mod_cluster.ModClusterSSLResourceDefinition;
import org.wildfly.extension.mod_cluster.ModClusterSubsystemXMLWriter;
import org.wildfly.extension.mod_cluster.Namespace;

public class ModClusterExtension
implements XMLStreamConstants,
Extension {
    public static final String SUBSYSTEM_NAME = "modcluster";
    private static final int MANAGEMENT_API_MAJOR_VERSION = 2;
    private static final int MANAGEMENT_API_MINOR_VERSION = 0;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;
    static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"modcluster");
    static final PathElement CONFIGURATION_PATH = PathElement.pathElement((String)"mod-cluster-config", (String)"configuration");
    static final PathElement SSL_CONFIGURATION_PATH = PathElement.pathElement((String)"ssl", (String)"configuration");
    static final PathElement DYNAMIC_LOAD_PROVIDER_PATH = PathElement.pathElement((String)"dynamic-load-provider", (String)"configuration");
    static final PathElement LOAD_METRIC_PATH = PathElement.pathElement((String)"load-metric");
    static final PathElement CUSTOM_LOAD_METRIC_PATH = PathElement.pathElement((String)"custom-load-metric");
    private static final String RESOURCE_NAME = ModClusterExtension.class.getPackage().getName() + ".LocalDescriptions";
    static final SensitivityClassification MOD_CLUSTER_SECURITY = new SensitivityClassification("modcluster", "mod_cluster-security", false, true, true);
    static final SensitiveTargetAccessConstraintDefinition MOD_CLUSTER_SECURITY_DEF = new SensitiveTargetAccessConstraintDefinition(MOD_CLUSTER_SECURITY);
    static final SensitivityClassification MOD_CLUSTER_PROXIES = new SensitivityClassification("modcluster", "mod_cluster-proxies", false, false, false);
    static final SensitiveTargetAccessConstraintDefinition MOD_CLUSTER_PROXIES_DEF = new SensitiveTargetAccessConstraintDefinition(MOD_CLUSTER_PROXIES);

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, ModClusterExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        ModClusterLogger.ROOT_LOGGER.debugf("Activating mod_cluster extension", new Object[0]);
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 2, 0, 0);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)new ModClusterDefinition(context.isRuntimeOnlyRegistrationValid()));
        ManagementResourceRegistration configuration = registration.registerSubModel((ResourceDefinition)new ModClusterConfigResourceDefinition());
        configuration.registerSubModel((ResourceDefinition)new ModClusterSSLResourceDefinition());
        ManagementResourceRegistration dynamicLoadProvider = configuration.registerSubModel((ResourceDefinition)DynamicLoadProviderDefinition.INSTANCE);
        dynamicLoadProvider.registerSubModel((ResourceDefinition)LoadMetricDefinition.INSTANCE);
        dynamicLoadProvider.registerSubModel((ResourceDefinition)CustomLoadMetricDefinition.INSTANCE);
        subsystem.registerXMLElementWriter((XMLElementWriter)new ModClusterSubsystemXMLWriter());
        if (context.isRegisterTransformers()) {
            ModClusterExtension.registerTransformers_1_2_0(subsystem);
            ModClusterExtension.registerTransformers_1_3_0(subsystem);
            ModClusterExtension.registerTransformers_1_4_0(subsystem);
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        for (Namespace namespace : Namespace.values()) {
            XMLElementReader<List<ModelNode>> reader = namespace.getXMLReader();
            if (reader == null) continue;
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, namespace.getUri(), namespace.getXMLReader());
        }
    }

    private static void registerTransformers_1_2_0(SubsystemRegistration subsystem) {
        ResourceTransformationDescriptionBuilder builder = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        ResourceTransformationDescriptionBuilder configurationBuilder = builder.addChildResource(CONFIGURATION_PATH);
        ResourceTransformationDescriptionBuilder dynamicLoadProvider = ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)configurationBuilder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{ModClusterConfigResourceDefinition.ADVERTISE, ModClusterConfigResourceDefinition.AUTO_ENABLE_CONTEXTS, ModClusterConfigResourceDefinition.FLUSH_PACKETS, ModClusterConfigResourceDefinition.STICKY_SESSION, ModClusterConfigResourceDefinition.STICKY_SESSION_REMOVE, ModClusterConfigResourceDefinition.STICKY_SESSION_FORCE, ModClusterConfigResourceDefinition.PING})).addRejectCheck((RejectAttributeChecker)SessionDrainingStrategyChecker.INSTANCE, new AttributeDefinition[]{ModClusterConfigResourceDefinition.SESSION_DRAINING_STRATEGY})).setDiscard((DiscardAttributeChecker)SessionDrainingStrategyChecker.INSTANCE, new AttributeDefinition[]{ModClusterConfigResourceDefinition.SESSION_DRAINING_STRATEGY})).end().addChildResource(DYNAMIC_LOAD_PROVIDER_PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{DynamicLoadProviderDefinition.DECAY, DynamicLoadProviderDefinition.HISTORY})).end();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)dynamicLoadProvider.addChildResource(CUSTOM_LOAD_METRIC_PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{CustomLoadMetricDefinition.CLASS, LoadMetricDefinition.WEIGHT})).addRejectCheck((RejectAttributeChecker)CapacityCheckerAndConverter.INSTANCE, new AttributeDefinition[]{LoadMetricDefinition.CAPACITY})).setValueConverter((AttributeConverter)CapacityCheckerAndConverter.INSTANCE, new AttributeDefinition[]{LoadMetricDefinition.CAPACITY})).end();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)dynamicLoadProvider.addChildResource(LOAD_METRIC_PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{LoadMetricDefinition.TYPE, LoadMetricDefinition.WEIGHT, LoadMetricDefinition.CAPACITY, LoadMetricDefinition.PROPERTY})).addRejectCheck((RejectAttributeChecker)CapacityCheckerAndConverter.INSTANCE, new AttributeDefinition[]{LoadMetricDefinition.CAPACITY})).setValueConverter((AttributeConverter)CapacityCheckerAndConverter.INSTANCE, new AttributeDefinition[]{LoadMetricDefinition.CAPACITY})).addRejectCheck((RejectAttributeChecker)PropertyCheckerAndConverter.INSTANCE, new AttributeDefinition[]{LoadMetricDefinition.PROPERTY})).setValueConverter((AttributeConverter)PropertyCheckerAndConverter.INSTANCE, new AttributeDefinition[]{LoadMetricDefinition.PROPERTY})).end();
        ((AttributeTransformationDescriptionBuilder)configurationBuilder.addChildResource(SSL_CONFIGURATION_PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{ModClusterSSLResourceDefinition.CIPHER_SUITE, ModClusterSSLResourceDefinition.KEY_ALIAS, ModClusterSSLResourceDefinition.PROTOCOL})).end();
        TransformationDescription.Tools.register((TransformationDescription)builder.build(), (SubsystemRegistration)subsystem, (ModelVersionRange)ModelVersion.create((int)1, (int)2, (int)0));
    }

    private static void registerTransformers_1_3_0(SubsystemRegistration subsystem) {
        TransformationDescription.Tools.register((TransformationDescription)ModClusterExtension.get1_3_0_1_4_0Description(), (SubsystemRegistration)subsystem, (ModelVersionRange)ModelVersion.create((int)1, (int)3, (int)0));
    }

    private static void registerTransformers_1_4_0(SubsystemRegistration subsystem) {
        TransformationDescription.Tools.register((TransformationDescription)ModClusterExtension.get1_3_0_1_4_0Description(), (SubsystemRegistration)subsystem, (ModelVersionRange)ModelVersion.create((int)1, (int)4, (int)0));
    }

    private static TransformationDescription get1_3_0_1_4_0Description() {
        ResourceTransformationDescriptionBuilder builder = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        ResourceTransformationDescriptionBuilder configurationBuilder = builder.addChildResource(CONFIGURATION_PATH);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)configurationBuilder.getAttributeBuilder().addRejectCheck((RejectAttributeChecker)SessionDrainingStrategyChecker.INSTANCE, new AttributeDefinition[]{ModClusterConfigResourceDefinition.SESSION_DRAINING_STRATEGY})).setDiscard((DiscardAttributeChecker)SessionDrainingStrategyChecker.INSTANCE, new AttributeDefinition[]{ModClusterConfigResourceDefinition.SESSION_DRAINING_STRATEGY})).end();
        return builder.build();
    }

    private static class SessionDrainingStrategyChecker
    extends DefaultCheckersAndConverter {
        private static final SessionDrainingStrategyChecker INSTANCE = new SessionDrainingStrategyChecker();

        private SessionDrainingStrategyChecker() {
        }

        public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
            return ModClusterMessages.MESSAGES.sessionDrainingStrategyMustBeUndefinedOrDefault();
        }

        protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            if (attributeValue.isDefined()) {
                if (this.checkForExpression(attributeValue)) {
                    return true;
                }
                return !attributeValue.asString().equals("DEFAULT");
            }
            return false;
        }

        protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
        }

        protected boolean isValueDiscardable(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            if (attributeValue.isDefined()) {
                if (this.checkForExpression(attributeValue)) {
                    return false;
                }
                return attributeValue.asString().equals("DEFAULT");
            }
            return false;
        }
    }

    private static class PropertyCheckerAndConverter
    extends DefaultCheckersAndConverter {
        private static final PropertyCheckerAndConverter INSTANCE = new PropertyCheckerAndConverter();

        private PropertyCheckerAndConverter() {
        }

        public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
            return ModClusterMessages.MESSAGES.propertyCanOnlyHaveOneEntry();
        }

        protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            return attributeValue.isDefined() && attributeValue.asPropertyList().size() > 1;
        }

        protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            List list;
            if (attributeValue.isDefined() && (list = attributeValue.asPropertyList()).size() == 1) {
                attributeValue.set(((Property)list.get(0)).getName(), ((Property)list.get(0)).getValue().asString());
            }
        }

        protected boolean isValueDiscardable(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            return false;
        }
    }

    static class CapacityCheckerAndConverter
    extends DefaultCheckersAndConverter {
        static final CapacityCheckerAndConverter INSTANCE = new CapacityCheckerAndConverter();

        CapacityCheckerAndConverter() {
        }

        public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
            return ModClusterMessages.MESSAGES.capacityIsExpressionOrGreaterThanIntegerMaxValue(attributes.get(LoadMetricDefinition.CAPACITY.getName()));
        }

        protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            if (this.checkForExpression(attributeValue) || attributeValue.isDefined() && !this.isIntegerValue(attributeValue.asDouble())) {
                return true;
            }
            Long converted = this.convert(attributeValue);
            return converted != null && (converted > Integer.MAX_VALUE || converted < Integer.MIN_VALUE);
        }

        protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            Long converted = this.convert(attributeValue);
            if (converted != null && converted <= Integer.MAX_VALUE && converted >= Integer.MIN_VALUE) {
                attributeValue.set((int)converted.longValue());
            }
        }

        protected boolean isValueDiscardable(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            return false;
        }

        private Long convert(ModelNode attributeValue) {
            double raw;
            if (attributeValue.isDefined() && !this.checkForExpression(attributeValue) && this.isIntegerValue(raw = attributeValue.asDouble())) {
                return Math.round(raw);
            }
            return null;
        }

        private boolean isIntegerValue(double raw) {
            return raw == Double.valueOf(Math.round(raw));
        }
    }
}

