/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.structure;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.metadata.EJBClientDescriptorMetaData;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

class EJBClientDescriptor11Parser
implements XMLElementReader<EJBClientDescriptorMetaData> {
    public static final String NAMESPACE_1_1 = "urn:jboss:ejb-client:1.1";
    public static final EJBClientDescriptor11Parser INSTANCE = new EJBClientDescriptor11Parser();

    private EJBClientDescriptor11Parser() {
    }

    public void readElement(XMLExtendedStreamReader reader, EJBClientDescriptorMetaData ejbClientDescriptorMetaData) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case CLIENT_CONTEXT: {
                            this.parseClientContext(reader, ejbClientDescriptorMetaData);
                            continue block7;
                        }
                    }
                    EJBClientDescriptor11Parser.unexpectedElement(reader);
                    continue block7;
                }
            }
            EJBClientDescriptor11Parser.unexpectedContent((XMLStreamReader)reader);
        }
        EJBClientDescriptor11Parser.unexpectedEndOfDocument(reader.getLocation());
    }

    private void parseClientContext(XMLExtendedStreamReader reader, EJBClientDescriptorMetaData ejbClientDescriptorMetaData) throws XMLStreamException {
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block8: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    if (visited.contains((Object)element)) {
                        EJBClientDescriptor11Parser.unexpectedElement(reader);
                    }
                    visited.add(element);
                    switch (element) {
                        case EJB_RECEIVERS: {
                            this.parseEJBReceivers(reader, ejbClientDescriptorMetaData);
                            continue block8;
                        }
                        case CLUSTERS: {
                            this.parseClusters(reader, ejbClientDescriptorMetaData);
                            continue block8;
                        }
                    }
                    EJBClientDescriptor11Parser.unexpectedElement(reader);
                    continue block8;
                }
            }
            EJBClientDescriptor11Parser.unexpectedContent((XMLStreamReader)reader);
        }
        EJBClientDescriptor11Parser.unexpectedEndOfDocument(reader.getLocation());
    }

    private void parseEJBReceivers(XMLExtendedStreamReader reader, EJBClientDescriptorMetaData ejbClientDescriptorMetaData) throws XMLStreamException {
        Boolean localReceiverPassByValue = null;
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            String val = reader.getAttributeValue(i);
            switch (attribute) {
                case EXCLUDE_LOCAL_RECEIVER: {
                    boolean excludeLocalReceiver = Boolean.parseBoolean(val.trim());
                    ejbClientDescriptorMetaData.setExcludeLocalReceiver(excludeLocalReceiver);
                    continue block11;
                }
                case LOCAL_RECEIVER_PASS_BY_VALUE: {
                    localReceiverPassByValue = Boolean.parseBoolean(val.trim());
                    continue block11;
                }
                default: {
                    EJBClientDescriptor11Parser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        ejbClientDescriptorMetaData.setLocalReceiverPassByValue(localReceiverPassByValue);
        block12: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case REMOTING_EJB_RECEIVER: {
                            this.parseRemotingReceiver(reader, ejbClientDescriptorMetaData);
                            continue block12;
                        }
                    }
                    EJBClientDescriptor11Parser.unexpectedElement(reader);
                    continue block12;
                }
            }
            EJBClientDescriptor11Parser.unexpectedContent((XMLStreamReader)reader);
        }
        EJBClientDescriptor11Parser.unexpectedEndOfDocument(reader.getLocation());
    }

    private void parseRemotingReceiver(XMLExtendedStreamReader reader, EJBClientDescriptorMetaData ejbClientDescriptorMetaData) throws XMLStreamException {
        String outboundConnectionRef = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.OUTBOUND_CONNECTION_REF);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case OUTBOUND_CONNECTION_REF: {
                    outboundConnectionRef = reader.getAttributeValue(i).trim();
                    ejbClientDescriptorMetaData.addRemotingReceiverConnectionRef(outboundConnectionRef);
                    continue block3;
                }
                default: {
                    EJBClientDescriptor11Parser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            EJBClientDescriptor11Parser.missingAttributes(reader.getLocation(), required);
        }
        if (reader.hasNext() && reader.nextTag() != 2) {
            EJBClientDescriptor11Parser.unexpectedContent((XMLStreamReader)reader);
        }
    }

    private void parseClusters(XMLExtendedStreamReader reader, EJBClientDescriptorMetaData ejbClientDescriptorMetaData) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case CLUSTER: {
                            this.parseCluster(reader, ejbClientDescriptorMetaData);
                            continue block7;
                        }
                    }
                    EJBClientDescriptor11Parser.unexpectedElement(reader);
                    continue block7;
                }
            }
            EJBClientDescriptor11Parser.unexpectedContent((XMLStreamReader)reader);
        }
        EJBClientDescriptor11Parser.unexpectedEndOfDocument(reader.getLocation());
    }

    private void parseCluster(XMLExtendedStreamReader reader, EJBClientDescriptorMetaData ejbClientDescriptorMetaData) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        String clusterName = null;
        String clusterNodeSelector = null;
        long connectTimeout = 5000L;
        long maxAllowedConnectedNodes = 10L;
        String userName = null;
        String securityRealm = null;
        block17: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    clusterName = reader.getAttributeValue(i).trim();
                    continue block17;
                }
                case CONNECT_TIMEOUT: {
                    connectTimeout = reader.getLongAttributeValue(i);
                    continue block17;
                }
                case CLUSTER_NODE_SELECTOR: {
                    clusterNodeSelector = reader.getAttributeValue(i).trim();
                    continue block17;
                }
                case MAX_ALLOWED_CONNECTED_NODES: {
                    maxAllowedConnectedNodes = reader.getLongAttributeValue(i);
                    continue block17;
                }
                case USERNAME: {
                    userName = reader.getAttributeValue(i).trim();
                    continue block17;
                }
                case SECURITY_REALM: {
                    securityRealm = reader.getAttributeValue(i).trim();
                    continue block17;
                }
                default: {
                    EJBClientDescriptor11Parser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            EJBClientDescriptor11Parser.missingAttributes(reader.getLocation(), required);
        }
        EJBClientDescriptorMetaData.ClusterConfig clusterConfig = ejbClientDescriptorMetaData.newClusterConfig(clusterName);
        clusterConfig.setConnectTimeout(connectTimeout);
        clusterConfig.setNodeSelector(clusterNodeSelector);
        clusterConfig.setMaxAllowedConnectedNodes(maxAllowedConnectedNodes);
        clusterConfig.setSecurityRealm(securityRealm);
        clusterConfig.setUserName(userName);
        block18: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case CONNECTION_CREATION_OPTIONS: {
                            Properties connectionCreationOptions = this.parseConnectionCreationOptions(reader);
                            clusterConfig.setConnectionOptions(connectionCreationOptions);
                            continue block18;
                        }
                        case CHANNEL_CREATION_OPTIONS: {
                            Properties channelCreationOptions = this.parseChannelCreationOptions(reader);
                            clusterConfig.setChannelCreationOptions(channelCreationOptions);
                            continue block18;
                        }
                        case NODE: {
                            this.parseClusterNode(reader, clusterConfig);
                            continue block18;
                        }
                    }
                    EJBClientDescriptor11Parser.unexpectedElement(reader);
                    continue block18;
                }
            }
            EJBClientDescriptor11Parser.unexpectedContent((XMLStreamReader)reader);
        }
        EJBClientDescriptor11Parser.unexpectedEndOfDocument(reader.getLocation());
    }

    private Properties parseConnectionCreationOptions(XMLExtendedStreamReader reader) throws XMLStreamException {
        Properties connectionCreationOptions = new Properties();
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return connectionCreationOptions;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case PROPERTY: {
                            connectionCreationOptions.putAll((Map<?, ?>)this.parseProperty(reader));
                            continue block7;
                        }
                    }
                    EJBClientDescriptor11Parser.unexpectedElement(reader);
                    continue block7;
                }
            }
            EJBClientDescriptor11Parser.unexpectedContent((XMLStreamReader)reader);
        }
        EJBClientDescriptor11Parser.unexpectedEndOfDocument(reader.getLocation());
        return connectionCreationOptions;
    }

    private Properties parseChannelCreationOptions(XMLExtendedStreamReader reader) throws XMLStreamException {
        Properties channelCreationOptions = new Properties();
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return channelCreationOptions;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case PROPERTY: {
                            channelCreationOptions.putAll((Map<?, ?>)this.parseProperty(reader));
                            continue block7;
                        }
                    }
                    EJBClientDescriptor11Parser.unexpectedElement(reader);
                    continue block7;
                }
            }
            EJBClientDescriptor11Parser.unexpectedContent((XMLStreamReader)reader);
        }
        EJBClientDescriptor11Parser.unexpectedEndOfDocument(reader.getLocation());
        return channelCreationOptions;
    }

    private void parseClusterNode(XMLExtendedStreamReader reader, EJBClientDescriptorMetaData.ClusterConfig clusterConfig) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        String nodeName = null;
        long connectTimeout = 5000L;
        String userName = null;
        String securityRealm = null;
        block14: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    nodeName = reader.getAttributeValue(i).trim();
                    continue block14;
                }
                case CONNECT_TIMEOUT: {
                    connectTimeout = reader.getLongAttributeValue(i);
                    continue block14;
                }
                case USERNAME: {
                    userName = reader.getAttributeValue(i).trim();
                    continue block14;
                }
                case SECURITY_REALM: {
                    securityRealm = reader.getAttributeValue(i).trim();
                    continue block14;
                }
                default: {
                    EJBClientDescriptor11Parser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            EJBClientDescriptor11Parser.missingAttributes(reader.getLocation(), required);
        }
        EJBClientDescriptorMetaData.ClusterNodeConfig clusterNodeConfig = clusterConfig.newClusterNode(nodeName);
        clusterNodeConfig.setConnectTimeout(connectTimeout);
        clusterNodeConfig.setSecurityRealm(securityRealm);
        clusterNodeConfig.setUserName(userName);
        block15: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case CONNECTION_CREATION_OPTIONS: {
                            Properties connectionCreationOptions = this.parseConnectionCreationOptions(reader);
                            clusterNodeConfig.setConnectionOptions(connectionCreationOptions);
                            continue block15;
                        }
                        case CHANNEL_CREATION_OPTIONS: {
                            Properties channelCreationOptions = this.parseChannelCreationOptions(reader);
                            clusterNodeConfig.setChannelCreationOptions(channelCreationOptions);
                            continue block15;
                        }
                    }
                    EJBClientDescriptor11Parser.unexpectedElement(reader);
                    continue block15;
                }
            }
            EJBClientDescriptor11Parser.unexpectedContent((XMLStreamReader)reader);
        }
        EJBClientDescriptor11Parser.unexpectedEndOfDocument(reader.getLocation());
    }

    private Properties parseProperty(XMLExtendedStreamReader reader) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.VALUE);
        int count = reader.getAttributeCount();
        String name = null;
        String value = null;
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i).trim();
                    continue block4;
                }
                case VALUE: {
                    value = reader.getAttributeValue(i).trim();
                    continue block4;
                }
                default: {
                    EJBClientDescriptor11Parser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            EJBClientDescriptor11Parser.missingAttributes(reader.getLocation(), required);
        }
        EJBClientDescriptor11Parser.requireNoContent(reader);
        Properties property = new Properties();
        property.put(name, value);
        return property;
    }

    private static void unexpectedEndOfDocument(Location location) throws XMLStreamException {
        throw EeMessages.MESSAGES.errorParsingEJBClientDescriptor("Unexpected end of document", location);
    }

    private static void missingAttributes(Location location, Set<Attribute> required) throws XMLStreamException {
        StringBuilder b = new StringBuilder("Missing one or more required attributes:");
        for (Attribute attribute : required) {
            b.append(' ').append((Object)attribute);
        }
        throw EeMessages.MESSAGES.errorParsingEJBClientDescriptor(b.toString(), location);
    }

    public static void requireNoContent(XMLExtendedStreamReader reader) throws XMLStreamException {
        if (reader.hasNext() && reader.nextTag() != 2) {
            EJBClientDescriptor11Parser.unexpectedElement(reader);
        }
    }

    public static void unexpectedElement(XMLExtendedStreamReader reader) throws XMLStreamException {
        throw EeMessages.MESSAGES.unexpectedElement(reader.getName(), reader.getLocation());
    }

    private static void unexpectedContent(XMLStreamReader reader) throws XMLStreamException {
        String kind;
        switch (reader.getEventType()) {
            case 10: {
                kind = "attribute";
                break;
            }
            case 12: {
                kind = "cdata";
                break;
            }
            case 4: {
                kind = "characters";
                break;
            }
            case 5: {
                kind = "comment";
                break;
            }
            case 11: {
                kind = "dtd";
                break;
            }
            case 8: {
                kind = "document end";
                break;
            }
            case 2: {
                kind = "element end";
                break;
            }
            case 15: {
                kind = "entity declaration";
                break;
            }
            case 9: {
                kind = "entity ref";
                break;
            }
            case 13: {
                kind = "namespace";
                break;
            }
            case 14: {
                kind = "notation declaration";
                break;
            }
            case 3: {
                kind = "processing instruction";
                break;
            }
            case 6: {
                kind = "whitespace";
                break;
            }
            case 7: {
                kind = "document start";
                break;
            }
            case 1: {
                kind = "element start";
                break;
            }
            default: {
                kind = "unknown";
            }
        }
        StringBuilder b = new StringBuilder("Unexpected content of type '").append(kind).append('\'');
        if (reader.hasName()) {
            b.append(" named '").append(reader.getName()).append('\'');
        }
        if (reader.hasText()) {
            b.append(", text is: '").append(reader.getText()).append('\'');
        }
        throw EeMessages.MESSAGES.errorParsingEJBClientDescriptor(b.toString(), reader.getLocation());
    }

    static enum Attribute {
        EXCLUDE_LOCAL_RECEIVER,
        LOCAL_RECEIVER_PASS_BY_VALUE,
        CONNECT_TIMEOUT,
        NAME,
        OUTBOUND_CONNECTION_REF,
        VALUE,
        MAX_ALLOWED_CONNECTED_NODES,
        CLUSTER_NODE_SELECTOR,
        USERNAME,
        SECURITY_REALM,
        UNKNOWN;

        private static final Map<QName, Attribute> attributes;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        static {
            HashMap<QName, Attribute> attributesMap = new HashMap<QName, Attribute>();
            attributesMap.put(new QName("exclude-local-receiver"), EXCLUDE_LOCAL_RECEIVER);
            attributesMap.put(new QName("local-receiver-pass-by-value"), LOCAL_RECEIVER_PASS_BY_VALUE);
            attributesMap.put(new QName("name"), NAME);
            attributesMap.put(new QName("value"), VALUE);
            attributesMap.put(new QName("outbound-connection-ref"), OUTBOUND_CONNECTION_REF);
            attributesMap.put(new QName("connect-timeout"), CONNECT_TIMEOUT);
            attributesMap.put(new QName("max-allowed-connected-nodes"), MAX_ALLOWED_CONNECTED_NODES);
            attributesMap.put(new QName("cluster-node-selector"), CLUSTER_NODE_SELECTOR);
            attributesMap.put(new QName("username"), USERNAME);
            attributesMap.put(new QName("security-realm"), SECURITY_REALM);
            attributes = attributesMap;
        }
    }

    static enum Element {
        CLIENT_CONTEXT,
        NODE,
        EJB_RECEIVERS,
        JBOSS_EJB_CLIENT,
        REMOTING_EJB_RECEIVER,
        CLUSTERS,
        CLUSTER,
        CHANNEL_CREATION_OPTIONS,
        CONNECTION_CREATION_OPTIONS,
        PROPERTY,
        UNKNOWN;

        private static final Map<QName, Element> elements;

        static Element of(QName qName) {
            QName name = qName.getNamespaceURI().equals("") ? new QName(EJBClientDescriptor11Parser.NAMESPACE_1_1, qName.getLocalPart()) : qName;
            Element element = elements.get(name);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<QName, Element> elementsMap = new HashMap<QName, Element>();
            elementsMap.put(new QName(EJBClientDescriptor11Parser.NAMESPACE_1_1, "jboss-ejb-client"), JBOSS_EJB_CLIENT);
            elementsMap.put(new QName(EJBClientDescriptor11Parser.NAMESPACE_1_1, "client-context"), CLIENT_CONTEXT);
            elementsMap.put(new QName(EJBClientDescriptor11Parser.NAMESPACE_1_1, "ejb-receivers"), EJB_RECEIVERS);
            elementsMap.put(new QName(EJBClientDescriptor11Parser.NAMESPACE_1_1, "remoting-ejb-receiver"), REMOTING_EJB_RECEIVER);
            elementsMap.put(new QName(EJBClientDescriptor11Parser.NAMESPACE_1_1, "clusters"), CLUSTERS);
            elementsMap.put(new QName(EJBClientDescriptor11Parser.NAMESPACE_1_1, "cluster"), CLUSTER);
            elementsMap.put(new QName(EJBClientDescriptor11Parser.NAMESPACE_1_1, "node"), NODE);
            elementsMap.put(new QName(EJBClientDescriptor11Parser.NAMESPACE_1_1, "channel-creation-options"), CHANNEL_CREATION_OPTIONS);
            elementsMap.put(new QName(EJBClientDescriptor11Parser.NAMESPACE_1_1, "connection-creation-options"), CONNECTION_CREATION_OPTIONS);
            elementsMap.put(new QName(EJBClientDescriptor11Parser.NAMESPACE_1_1, "property"), PROPERTY);
            elements = elementsMap;
        }
    }
}

