/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.ignored;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.host.controller.descriptions.HostResolver;
import org.jboss.as.host.controller.ignored.IgnoreDomainResourceTypeResource;
import org.jboss.as.host.controller.ignored.IgnoredDomainResourceRoot;
import org.jboss.as.host.controller.ignored.IgnoredDomainTypeResourceDefinition;
import org.jboss.dmr.ModelNode;

public class IgnoredDomainResourceRegistry {
    private final LocalHostControllerInfo localHostControllerInfo;
    private volatile IgnoredDomainResourceRoot rootResource;

    public IgnoredDomainResourceRegistry(LocalHostControllerInfo localHostControllerInfo) {
        this.localHostControllerInfo = localHostControllerInfo;
    }

    public boolean isResourceExcluded(PathAddress address) {
        if (!this.localHostControllerInfo.isMasterDomainController() && address.size() > 0) {
            IgnoreDomainResourceTypeResource typeResource;
            IgnoredDomainResourceRoot root = this.rootResource;
            PathElement firstElement = address.getElement(0);
            IgnoreDomainResourceTypeResource ignoreDomainResourceTypeResource = typeResource = root == null ? null : root.getChildInternal(firstElement.getKey());
            if (typeResource != null && typeResource.hasName(firstElement.getValue())) {
                return true;
            }
        }
        return false;
    }

    public void registerResources(ManagementResourceRegistration parentRegistration) {
        parentRegistration.registerSubModel((org.jboss.as.controller.ResourceDefinition)new ResourceDefinition());
    }

    public Resource.ResourceEntry getRootResource() {
        IgnoredDomainResourceRoot root;
        this.rootResource = root = new IgnoredDomainResourceRoot(this);
        return root;
    }

    public ModelNode getIgnoredResourcesAsModel() {
        IgnoredDomainResourceRoot root = this.rootResource;
        ModelNode model = root == null ? new ModelNode() : Resource.Tools.readModel((Resource)root);
        return model;
    }

    void publish(IgnoredDomainResourceRoot root) {
        this.rootResource = root;
    }

    boolean isMaster() {
        return this.localHostControllerInfo.isMasterDomainController();
    }

    private class ResourceDefinition
    extends SimpleResourceDefinition {
        public ResourceDefinition() {
            super(IgnoredDomainResourceRoot.PATH_ELEMENT, HostResolver.getResolver("ignored-resources"));
        }

        public void registerChildren(ManagementResourceRegistration resourceRegistration) {
            resourceRegistration.registerSubModel((org.jboss.as.controller.ResourceDefinition)new IgnoredDomainTypeResourceDefinition());
        }
    }
}

