/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.UndertowMessages;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionListeners;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.wildfly.clustering.web.Batch;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.undertow.session.DistributableImmutableSession;
import org.wildfly.clustering.web.undertow.session.DistributableSession;
import org.wildfly.clustering.web.undertow.session.LocalSessionContext;
import org.wildfly.clustering.web.undertow.session.UndertowSessionManager;

public class DistributableSessionManager
implements UndertowSessionManager {
    private static final int MAX_SESSION_ID_GENERATION_ATTEMPTS = 10;
    private final String deploymentName;
    private final SessionListeners sessionListeners = new SessionListeners();
    private final SessionManager<LocalSessionContext> manager;

    public DistributableSessionManager(String deploymentName, SessionManager<LocalSessionContext> manager) {
        this.deploymentName = deploymentName;
        this.manager = manager;
    }

    @Override
    public SessionListeners getSessionListeners() {
        return this.sessionListeners;
    }

    @Override
    public SessionManager<LocalSessionContext> getSessionManager() {
        return this.manager;
    }

    public void start() {
        this.manager.start();
    }

    public void stop() {
        this.manager.stop();
    }

    public io.undertow.server.session.Session createSession(HttpServerExchange exchange, SessionConfig config) {
        if (config == null) {
            throw UndertowMessages.MESSAGES.couldNotFindSessionCookieConfig();
        }
        String id = config.findSessionId(exchange);
        if (id == null) {
            int attempts = 0;
            do {
                if (++attempts <= 10) continue;
                throw UndertowMessages.MESSAGES.couldNotGenerateUniqueSessionId();
            } while (this.manager.containsSession(id = (String)this.manager.createIdentifier()));
            config.setSessionId(exchange, id);
        }
        Batch batch = this.manager.getBatcher().startBatch();
        try {
            Session session = this.manager.createSession(id);
            DistributableSession adapter = new DistributableSession(this, (Session<LocalSessionContext>)session, config, batch);
            this.sessionListeners.sessionCreated((io.undertow.server.session.Session)adapter, exchange);
            return adapter;
        }
        catch (Error | RuntimeException e) {
            batch.discard();
            throw e;
        }
    }

    public io.undertow.server.session.Session getSession(HttpServerExchange exchange, SessionConfig config) {
        String id = config.findSessionId(exchange);
        if (id == null) {
            return null;
        }
        Batch batch = this.manager.getBatcher().startBatch();
        try {
            Session session = this.manager.findSession(id);
            if (session == null) {
                batch.close();
                return null;
            }
            return new DistributableSession(this, (Session<LocalSessionContext>)session, config, batch);
        }
        catch (Error | RuntimeException e) {
            batch.discard();
            throw e;
        }
    }

    public void registerSessionListener(SessionListener listener) {
        this.sessionListeners.addSessionListener(listener);
    }

    public void removeSessionListener(SessionListener listener) {
        this.sessionListeners.removeSessionListener(listener);
    }

    public void setDefaultSessionTimeout(int timeout) {
        this.manager.setDefaultMaxInactiveInterval((long)timeout, TimeUnit.SECONDS);
    }

    public Set<String> getTransientSessions() {
        return Collections.emptySet();
    }

    public Set<String> getActiveSessions() {
        return this.manager.getActiveSessions();
    }

    public Set<String> getAllSessions() {
        return this.manager.getLocalSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public io.undertow.server.session.Session getSession(String sessionId) {
        Batch batch = this.manager.getBatcher().startBatch();
        try {
            ImmutableSession session = this.manager.viewSession(sessionId);
            DistributableImmutableSession distributableImmutableSession = session != null ? new DistributableImmutableSession(this, session) : null;
            return distributableImmutableSession;
        }
        finally {
            batch.discard();
        }
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DistributableSessionManager)) {
            return false;
        }
        DistributableSessionManager manager = (DistributableSessionManager)object;
        return this.deploymentName.equals(manager.getDeploymentName());
    }

    public int hashCode() {
        return this.deploymentName.hashCode();
    }

    public String toString() {
        return this.deploymentName;
    }
}

