/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.Cache;
import org.infinispan.affinity.KeyAffinityService;
import org.infinispan.affinity.KeyGenerator;
import org.infinispan.context.Flag;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.notifications.KeyFilter;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryPassivated;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.CacheEntryActivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryPassivatedEvent;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.clustering.concurrent.Scheduler;
import org.jboss.as.clustering.infinispan.affinity.KeyAffinityServiceFactory;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.ClusterAffinity;
import org.jboss.ejb.client.NodeAffinity;
import org.wildfly.clustering.ejb.Batcher;
import org.wildfly.clustering.ejb.Bean;
import org.wildfly.clustering.ejb.BeanManager;
import org.wildfly.clustering.ejb.IdentifierFactory;
import org.wildfly.clustering.ejb.RemoveListener;
import org.wildfly.clustering.ejb.Time;
import org.wildfly.clustering.ejb.infinispan.BeanEntry;
import org.wildfly.clustering.ejb.infinispan.BeanEvictionScheduler;
import org.wildfly.clustering.ejb.infinispan.BeanExpirationScheduler;
import org.wildfly.clustering.ejb.infinispan.BeanFactory;
import org.wildfly.clustering.ejb.infinispan.BeanGroup;
import org.wildfly.clustering.ejb.infinispan.BeanGroupEntry;
import org.wildfly.clustering.ejb.infinispan.BeanGroupFactory;
import org.wildfly.clustering.ejb.infinispan.BeanKey;
import org.wildfly.clustering.ejb.infinispan.Configuration;
import org.wildfly.clustering.ejb.infinispan.ExpirationConfiguration;
import org.wildfly.clustering.ejb.infinispan.ExpiredBeanRemover;
import org.wildfly.clustering.ejb.infinispan.InfinispanBatcher;
import org.wildfly.clustering.ejb.infinispan.InfinispanEjbLogger;
import org.wildfly.clustering.ejb.infinispan.PassivationConfiguration;
import org.wildfly.clustering.ejb.infinispan.TransactionBatch;
import org.wildfly.clustering.group.NodeFactory;
import org.wildfly.clustering.registry.Registry;

@Listener
public class InfinispanBeanManager<G, I, T>
implements BeanManager<G, I, T, TransactionBatch>,
KeyFilter {
    final Cache<G, BeanGroupEntry<I, T>> groupCache;
    private final String beanName;
    private final Cache<BeanKey<I>, BeanEntry<G>> beanCache;
    private final BeanFactory<G, I, T> beanFactory;
    private final BeanGroupFactory<G, I, T> groupFactory;
    private final IdentifierFactory<G> groupIdentifierFactory;
    private final IdentifierFactory<I> beanIdentifierFactory;
    private final List<KeyAffinityService<?>> affinityServices = new ArrayList(2);
    private final Registry<String, ?> registry;
    private final NodeFactory<Address> nodeFactory;
    private final ExpirationConfiguration<T> expiration;
    private final PassivationConfiguration<T> passivation;
    private final List<Scheduler<Bean<G, I, T>>> schedulers = new ArrayList<Scheduler<Bean<G, I, T>>>(2);
    private final AtomicInteger passiveCount = new AtomicInteger();
    private final Batcher<TransactionBatch> batcher;

    public InfinispanBeanManager(String beanName, final Configuration<I, BeanKey<I>, BeanEntry<G>, BeanFactory<G, I, T>> beanConfiguration, final Configuration<G, G, BeanGroupEntry<I, T>, BeanGroupFactory<G, I, T>> groupConfiguration, KeyAffinityServiceFactory affinityFactory, Registry<String, ?> registry, NodeFactory<Address> nodeFactory, ExpirationConfiguration<T> expiration, PassivationConfiguration<T> passivation) {
        this.beanName = beanName;
        this.groupFactory = groupConfiguration.getFactory();
        this.beanFactory = beanConfiguration.getFactory();
        this.groupCache = groupConfiguration.getCache();
        this.beanCache = beanConfiguration.getCache();
        this.batcher = new InfinispanBatcher(this.groupCache);
        final Address address = this.groupCache.getCacheManager().getAddress();
        KeyGenerator groupKeyGenerator = new KeyGenerator<G>(){

            public G getKey() {
                return groupConfiguration.getIdentifierFactory().createIdentifier();
            }
        };
        final KeyAffinityService groupAffinityService = affinityFactory.createService(this.groupCache, groupKeyGenerator);
        this.groupIdentifierFactory = new IdentifierFactory<G>(){

            public G createIdentifier() {
                return groupAffinityService.getKeyForAddress(address);
            }
        };
        this.affinityServices.add(groupAffinityService);
        KeyGenerator beanKeyGenerator = new KeyGenerator<BeanKey<I>>(){

            public BeanKey<I> getKey() {
                return ((BeanFactory)beanConfiguration.getFactory()).createKey(beanConfiguration.getIdentifierFactory().createIdentifier());
            }
        };
        final KeyAffinityService beanAffinityService = affinityFactory.createService(this.beanCache, beanKeyGenerator);
        this.beanIdentifierFactory = new IdentifierFactory<I>(){

            public I createIdentifier() {
                return ((BeanKey)beanAffinityService.getKeyForAddress(address)).getId();
            }
        };
        this.affinityServices.add(beanAffinityService);
        this.registry = registry;
        this.nodeFactory = nodeFactory;
        this.expiration = expiration;
        this.passivation = passivation;
    }

    public void start() {
        for (KeyAffinityService<?> service : this.affinityServices) {
            service.start();
        }
        Time timeout = this.expiration.getTimeout();
        if (timeout != null && timeout.getValue() >= 0L) {
            this.schedulers.add(new BeanExpirationScheduler(this.batcher, new ExpiredBeanRemover<G, I, T>(this.beanFactory), this.expiration));
        }
        if (this.passivation.isEvictionAllowed()) {
            this.schedulers.add(new BeanEvictionScheduler(this.batcher, this.beanFactory, this.passivation));
        }
        this.beanCache.addListener((Object)this, (KeyFilter)this);
    }

    public void stop() {
        this.beanCache.removeListener((Object)this);
        for (Scheduler<Bean<G, I, T>> scheduler : this.schedulers) {
            scheduler.close();
        }
        this.schedulers.clear();
        for (KeyAffinityService keyAffinityService : this.affinityServices) {
            keyAffinityService.stop();
        }
    }

    public boolean accept(Object key) {
        if (!(key instanceof BeanKey)) {
            return false;
        }
        BeanKey beanKey = (BeanKey)key;
        return beanKey.getBeanName().equals(this.beanName);
    }

    public Affinity getStrictAffinity() {
        return this.registry != null ? new ClusterAffinity(this.registry.getGroup().getName()) : null;
    }

    public Affinity getWeakAffinity(I id) {
        return this.registry != null ? new NodeAffinity((String)this.registry.getEntry(this.nodeFactory.createNode((Object)this.locate(id))).getKey()) : Affinity.NONE;
    }

    private Address locate(I id) {
        DistributionManager dist = this.beanCache.getAdvancedCache().getDistributionManager();
        return dist != null ? dist.getPrimaryLocation(id) : this.beanCache.getCacheManager().getAddress();
    }

    public Bean<G, I, T> createBean(I id, G groupId, T bean) {
        InfinispanEjbLogger.ROOT_LOGGER.tracef("Creating bean %s associated with group %s", id, groupId);
        BeanGroup<G, I, T> group = this.groupFactory.createGroup(groupId, (BeanGroupEntry)this.groupFactory.createValue(groupId));
        group.addBean(id, bean);
        group.releaseBean(id, this.passivation.isPersistent() ? this.passivation.getPassivationListener() : null);
        return new SchedulableBean<G, I, T>(this.beanFactory.createBean(id, this.beanFactory.createValue(id, groupId)), this.schedulers);
    }

    public Bean<G, I, T> findBean(I id) {
        InfinispanEjbLogger.ROOT_LOGGER.tracef("Locating bean %s", id);
        BeanEntry entry = (BeanEntry)this.beanFactory.findValue(id);
        if (entry == null) {
            InfinispanEjbLogger.ROOT_LOGGER.debugf("Could not find bean %s", id);
            return null;
        }
        Bean<G, I, T> bean = this.beanFactory.createBean(id, entry);
        for (Scheduler<Bean<G, I, T>> scheduler : this.schedulers) {
            scheduler.cancel(bean);
        }
        return new SchedulableBean<G, I, T>(bean, this.schedulers);
    }

    public boolean containsBean(I id) {
        return this.beanCache.containsKey(this.beanFactory.createKey(id));
    }

    public IdentifierFactory<G> getGroupIdentifierFactory() {
        return this.groupIdentifierFactory;
    }

    public IdentifierFactory<I> getBeanIdentifierFactory() {
        return this.beanIdentifierFactory;
    }

    public Batcher<TransactionBatch> getBatcher() {
        return this.batcher;
    }

    public int getActiveCount() {
        int size = 0;
        for (Object key : this.beanCache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_LOAD, Flag.SKIP_LOCKING}).keySet()) {
            if (!this.accept(key)) continue;
            ++size;
        }
        return size;
    }

    public int getPassiveCount() {
        return this.passiveCount.get();
    }

    @CacheEntryPassivated
    public void passivated(CacheEntryPassivatedEvent<BeanKey<I>, BeanEntry<G>> event) {
        if (event.isPre() && event.isOriginLocal()) {
            Object groupId;
            BeanGroupEntry entry;
            this.passiveCount.incrementAndGet();
            if (!this.passivation.isPersistent() && (entry = (BeanGroupEntry)this.groupFactory.findValue(groupId = ((BeanEntry)event.getValue()).getGroupId())) != null) {
                try (BeanGroup group = this.groupFactory.createGroup(groupId, entry);){
                    group.prePassivate(((BeanKey)event.getKey()).getId(), this.passivation.getPassivationListener());
                }
            }
        }
    }

    @CacheEntryActivated
    public void activated(CacheEntryActivatedEvent<BeanKey<I>, BeanEntry<G>> event) {
        if (!event.isPre() && event.isOriginLocal()) {
            Object groupId;
            BeanGroupEntry entry;
            this.passiveCount.decrementAndGet();
            if (!this.passivation.isPersistent() && (entry = (BeanGroupEntry)this.groupFactory.findValue(groupId = ((BeanEntry)event.getValue()).getGroupId())) != null) {
                try (BeanGroup group = this.groupFactory.createGroup(groupId, entry);){
                    group.postActivate(((BeanKey)event.getKey()).getId(), this.passivation.getPassivationListener());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TopologyChanged
    public void topologyChanged(TopologyChangedEvent<BeanKey<I>, BeanEntry<G>> event) {
        if (event.isPre()) {
            return;
        }
        Cache cache = event.getCache();
        Address localAddress = cache.getCacheManager().getAddress();
        ConsistentHash oldHash = event.getConsistentHashAtStart();
        ConsistentHash newHash = event.getConsistentHashAtEnd();
        HashSet oldAddresses = new HashSet(oldHash.getMembers());
        oldAddresses.removeAll(newHash.getMembers());
        if (!oldAddresses.isEmpty()) {
            for (Object cacheKey : cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_LOAD, Flag.SKIP_LOCKING}).keySet()) {
                BeanKey key;
                Address oldOwner;
                if (!this.accept(cacheKey) || !oldAddresses.contains(oldOwner = oldHash.locatePrimaryOwner((Object)(key = (BeanKey)cacheKey)))) continue;
                Address newOwner = newHash.locatePrimaryOwner((Object)key);
                Object id = key.getId();
                if (localAddress.equals(newOwner)) {
                    boolean started = cache.startBatch();
                    try {
                        BeanEntry entry = (BeanEntry)this.beanFactory.findValue(id);
                        if (entry == null) continue;
                        InfinispanEjbLogger.ROOT_LOGGER.debugf("Scheduling expiration of bean %s on behalf of previous owner: %s", id, oldOwner);
                        Bean<G, I, T> bean = this.beanFactory.createBean(id, entry);
                        for (Scheduler<Bean<G, I, T>> scheduler : this.schedulers) {
                            scheduler.cancel(bean);
                            scheduler.schedule(bean);
                        }
                        continue;
                    }
                    finally {
                        if (started) {
                            cache.endBatch(false);
                        }
                        continue;
                    }
                }
                InfinispanEjbLogger.ROOT_LOGGER.tracef("Expiration of bean %s will be scheduled by node %s on behalf of previous owner: %s", id, newOwner, oldOwner);
            }
        }
    }

    private static class SchedulableBean<G, I, T>
    implements Bean<G, I, T> {
        private final Bean<G, I, T> bean;
        private final List<Scheduler<Bean<G, I, T>>> schedulers;

        SchedulableBean(Bean<G, I, T> bean, List<Scheduler<Bean<G, I, T>>> schedulers) {
            this.bean = bean;
            this.schedulers = schedulers;
        }

        public I getId() {
            return (I)this.bean.getId();
        }

        public G getGroupId() {
            return (G)this.bean.getGroupId();
        }

        public void remove(RemoveListener<T> listener) {
            this.bean.remove(listener);
        }

        public boolean isExpired() {
            return this.bean.isExpired();
        }

        public T acquire() {
            return (T)this.bean.acquire();
        }

        public boolean release() {
            return this.bean.release();
        }

        public void close() {
            this.bean.close();
            for (Scheduler<Bean<G, I, T>> scheduler : this.schedulers) {
                scheduler.schedule(this.bean);
            }
        }
    }
}

