/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.job.model;

import java.io.InputStream;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jberet._private.BatchMessages;
import org.jberet.job.model.BatchArtifacts;
import org.jberet.job.model.Chunk;
import org.jberet.job.model.Decision;
import org.jberet.job.model.ExceptionClassFilter;
import org.jberet.job.model.Flow;
import org.jberet.job.model.Job;
import org.jberet.job.model.Listeners;
import org.jberet.job.model.Partition;
import org.jberet.job.model.PartitionPlan;
import org.jberet.job.model.Properties;
import org.jberet.job.model.RefArtifact;
import org.jberet.job.model.Split;
import org.jberet.job.model.Step;
import org.jberet.job.model.Transition;
import org.jberet.job.model.XmlAttribute;
import org.jberet.job.model.XmlElement;

public final class JobParser {
    private static final String namespaceURI = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Job parseJob(InputStream inputStream, ClassLoader classLoader) throws XMLStreamException {
        XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
        Job job = null;
        try {
            block16: while (reader.hasNext()) {
                int eventType = reader.next();
                if (eventType != 1 && eventType != 2) continue;
                XmlElement element = XmlElement.forName(reader.getLocalName());
                block1 : switch (eventType) {
                    case 1: {
                        switch (element) {
                            case JOB: {
                                job = new Job(JobParser.getAttributeValue(reader, XmlAttribute.ID, true));
                                job.setRestartable(JobParser.getAttributeValue(reader, XmlAttribute.RESTARTABLE, false));
                                job.setAbstract(JobParser.getAttributeValue(reader, XmlAttribute.ABSTRACT, false));
                                String parentVal = JobParser.getAttributeValue(reader, XmlAttribute.PARENT, false);
                                if (parentVal == null) continue block16;
                                job.setParentAndJslName(parentVal, null);
                                job.inheritingJobElements.add(job);
                                break block1;
                            }
                            case STEP: {
                                job.addJobElement(JobParser.parseStep(reader, job));
                                break block1;
                            }
                            case FLOW: {
                                job.addJobElement(JobParser.parseFlow(reader, job));
                                break block1;
                            }
                            case SPLIT: {
                                job.addJobElement(JobParser.parseSplit(reader, job));
                                break block1;
                            }
                            case DECISION: {
                                job.addJobElement(JobParser.parseDecision(reader));
                                break block1;
                            }
                            case PROPERTIES: {
                                job.setProperties(JobParser.parseProperties(reader));
                                break block1;
                            }
                            case LISTENERS: {
                                job.setListeners(JobParser.parseListeners(reader));
                                break block1;
                            }
                        }
                        throw BatchMessages.MESSAGES.unexpectedXmlElement(reader.getLocalName(), reader.getLocation());
                    }
                    case 2: {
                        if (element == XmlElement.JOB) break;
                        throw BatchMessages.MESSAGES.unexpectedXmlElement(reader.getLocalName(), reader.getLocation());
                    }
                }
            }
            return job;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BatchArtifacts parseBatchArtifacts(InputStream inputStream) throws XMLStreamException {
        XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
        BatchArtifacts batchArtifacts = null;
        try {
            while (reader.hasNext()) {
                int eventType = reader.next();
                if (eventType != 1 && eventType != 2) continue;
                XmlElement element = XmlElement.forName(reader.getLocalName());
                block1 : switch (eventType) {
                    case 1: {
                        switch (element) {
                            case BATCH_ARTIFACTS: {
                                batchArtifacts = new BatchArtifacts();
                                break block1;
                            }
                            case REF: {
                                batchArtifacts.addRef(JobParser.getAttributeValue(reader, XmlAttribute.ID, true), JobParser.getAttributeValue(reader, XmlAttribute.CLASS, true));
                                break block1;
                            }
                        }
                        throw BatchMessages.MESSAGES.unexpectedXmlElement(reader.getLocalName(), reader.getLocation());
                    }
                    case 2: {
                        if (element == XmlElement.BATCH_ARTIFACTS || element == XmlElement.REF) break;
                        throw BatchMessages.MESSAGES.unexpectedXmlElement(reader.getLocalName(), reader.getLocation());
                    }
                }
            }
        }
        finally {
            reader.close();
        }
        return batchArtifacts;
    }

    private static Step parseStep(XMLStreamReader reader, Job job) throws XMLStreamException {
        Step step = new Step(JobParser.getAttributeValue(reader, XmlAttribute.ID, true));
        step.setStartLimit(JobParser.getAttributeValue(reader, XmlAttribute.START_LIMIT, false));
        step.setAllowStartIfComplete(JobParser.getAttributeValue(reader, XmlAttribute.ALLOW_START_IF_COMPLETE, false));
        step.setAttributeNext(JobParser.getAttributeValue(reader, XmlAttribute.NEXT, false));
        step.setAbstract(JobParser.getAttributeValue(reader, XmlAttribute.ABSTRACT, false));
        String parentVal = JobParser.getAttributeValue(reader, XmlAttribute.PARENT, false);
        if (parentVal != null) {
            step.setParentAndJslName(parentVal, JobParser.getAttributeValue(reader, XmlAttribute.JSL_NAME, false));
            job.inheritingJobElements.add(step);
        }
        while (reader.hasNext()) {
            int eventType = reader.next();
            if (eventType != 1 && eventType != 2) continue;
            XmlElement element = XmlElement.forName(reader.getLocalName());
            block0 : switch (eventType) {
                case 1: {
                    switch (element) {
                        case PROPERTIES: {
                            step.setProperties(JobParser.parseProperties(reader));
                            break block0;
                        }
                        case LISTENERS: {
                            step.setListeners(JobParser.parseListeners(reader));
                            break block0;
                        }
                        case BATCHLET: {
                            step.setBatchlet(JobParser.parseRefArtifact(reader, XmlElement.BATCHLET));
                            break block0;
                        }
                        case CHUNK: {
                            step.setChunk(JobParser.parseChunk(reader));
                            break block0;
                        }
                        case PARTITION: {
                            step.setPartition(JobParser.parsePartition(reader));
                            break block0;
                        }
                        case NEXT: {
                            if (step.getAttributeNext() != null) {
                                throw BatchMessages.MESSAGES.cannotHaveBothNextAttributeAndElement(reader.getLocation(), step.getAttributeNext());
                            }
                            step.addTransitionElement(JobParser.parseNext(reader));
                            break block0;
                        }
                        case FAIL: {
                            step.addTransitionElement(JobParser.parseFail(reader));
                            break block0;
                        }
                        case END: {
                            step.addTransitionElement(JobParser.parseEnd(reader));
                            break block0;
                        }
                        case STOP: {
                            step.addTransitionElement(JobParser.parseStop(reader));
                            break block0;
                        }
                    }
                    throw BatchMessages.MESSAGES.unexpectedXmlElement(reader.getLocalName(), reader.getLocation());
                }
                case 2: {
                    switch (element) {
                        case STEP: {
                            return step;
                        }
                    }
                    throw BatchMessages.MESSAGES.unexpectedXmlElement(reader.getLocalName(), reader.getLocation());
                }
            }
        }
        throw BatchMessages.MESSAGES.unexpectedXmlElement(reader.getLocalName(), reader.getLocation());
    }

    private static String getAttributeValue(XMLStreamReader reader, XmlAttribute attribute, boolean required) {
        String val = reader.getAttributeValue(namespaceURI, attribute.getLocalName());
        if (val == null && required) {
            throw BatchMessages.MESSAGES.failToGetAttribute(attribute.getLocalName(), reader.getLocation());
        }
        return val;
    }

    private static Decision parseDecision(XMLStreamReader reader) throws XMLStreamException {
        Decision decision = new Decision(JobParser.getAttributeValue(reader, XmlAttribute.ID, true), JobParser.getAttributeValue(reader, XmlAttribute.REF, true));
        while (reader.hasNext()) {
            int eventType = reader.next();
            if (eventType != 1 && eventType != 2) continue;
            XmlElement element = XmlElement.forName(reader.getLocalName());
            block0 : switch (eventType) {
                case 1: {
                    switch (element) {
                        case PROPERTIES: {
                            decision.setProperties(JobParser.parseProperties(reader));
                            break block0;
                        }
                        case NEXT: {
                            decision.addTransitionElement(JobParser.parseNext(reader));
                            break block0;
                        }
                        case FAIL: {
                            decision.addTransitionElement(JobParser.parseFail(reader));
                            break block0;
                        }
                        case END: {
                            decision.addTransitionElement(JobParser.parseEnd(reader));
                            break block0;
                        }
                        case STOP: {
                            decision.addTransitionElement(JobParser.parseStop(reader));
                            break block0;
                        }
                    }
                    throw BatchMessages.MESSAGES.unexpectedXmlElement(reader.getLocalName(), reader.getLocation());
                }
                case 2: {
                    switch (element) {
                        case DECISION: {
                            return decision;
                        }
                    }
                    throw BatchMessages.MESSAGES.unexpectedXmlElement(reader.getLocalName(), reader.getLocation());
                }
            }
        }
        throw BatchMessages.MESSAGES.unexpectedXmlElement(reader.getLocalName(), reader.getLocation());
    }

    private static Flow parseFlow(XMLStreamReader reader, Job job) throws XMLStreamException {
        Flow flow = new Flow(JobParser.getAttributeValue(reader, XmlAttribute.ID, true));
        flow.next = JobParser.getAttributeValue(reader, XmlAttribute.NEXT, false);
        flow.setAbstract(JobParser.getAttributeValue(reader, XmlAttribute.ABSTRACT, false));
        String parentVal = JobParser.getAttributeValue(reader, XmlAttribute.PARENT, false);
        if (parentVal != null) {
            flow.setParentAndJslName(parentVal, JobParser.getAttributeValue(reader, XmlAttribute.JSL_NAME, false));
            job.inheritingJobElements.add(flow);
        }
        while (reader.hasNext()) {
            int eventType = reader.next();
            if (eventType != 1 && eventType != 2) continue;
            XmlElement element = XmlElement.forName(reader.getLocalName());
            block0 : switch (eventType) {
                case 1: {
                    switch (element) {
                        case DECISION: {
                            flow.jobElements.add(JobParser.parseDecision(reader));
                            break block0;
                        }
                        case FLOW: {
                            flow.jobElements.add(JobParser.parseFlow(reader, job));
                            break block0;
                        }
                        case SPLIT: {
                            flow.jobElements.add(JobParser.parseSplit(reader, job));
                            break block0;
                        }
                        case STEP: {
                            flow.jobElements.add(JobParser.parseStep(reader, job));
                            break block0;
                        }
                        case NEXT: {
                            if (flow.getAttributeNext() != null) {
                                throw BatchMessages.MESSAGES.cannotHaveBothNextAttributeAndElement(reader.getLocation(), flow.getAttributeNext());
                            }
                            flow.addTransitionElement(JobParser.parseNext(reader));
                            break block0;
                        }
                        case FAIL: {
                            flow.addTransitionElement(JobParser.parseFail(reader));
                            break block0;
                        }
                        case END: {
                            flow.addTransitionElement(JobParser.parseEnd(reader));
                            break block0;
                        }
                        case STOP: {
                            flow.addTransitionElement(JobParser.parseStop(reader));
                            break block0;
                        }
                    }
                    throw BatchMessages.MESSAGES.unexpectedXmlElement(reader.getLocalName(), reader.getLocation());
                }
                case 2: {
                    switch (element) {
                        case FLOW: {
                            return flow;
                        }
                    }
                    throw BatchMessages.MESSAGES.unexpectedXmlElement(reader.getLocalName(), reader.getLocation());
                }
            }
        }
        throw BatchMessages.MESSAGES.unexpectedXmlElement(reader.getLocalName(), reader.getLocation());
    }

    private static Split parseSplit(XMLStreamReader reader, Job job) throws XMLStreamException {
        Split split = new Split(JobParser.getAttributeValue(reader, XmlAttribute.ID, true));
        split.setAttributeNext(JobParser.getAttributeValue(reader, XmlAttribute.NEXT, false));
        while (reader.hasNext()) {
            int eventType = reader.next();
            if (eventType != 1 && eventType != 2) continue;
            XmlElement element = XmlElement.forName(reader.getLocalName());
            switch (eventType) {
                case 1: {
                    if (element == XmlElement.FLOW) {
                        split.addFlow(JobParser.parseFlow(reader, job));
                        break;
                    }
                    throw BatchMessages.MESSAGES.unexpectedXmlElement(reader.getLocalName(), reader.getLocation());
                }
                case 2: {
                    if (element == XmlElement.SPLIT) {
                        return split;
                    }
                    throw BatchMessages.MESSAGES.unexpectedXmlElement(reader.getLocalName(), reader.getLocation());
                }
            }
        }
        throw BatchMessages.MESSAGES.unexpectedXmlElement(reader.getLocalName(), reader.getLocation());
    }

    private static Properties parseProperties(XMLStreamReader reader) throws XMLStreamException {
        Properties properties = new Properties();
        properties.setPartition(JobParser.getAttributeValue(reader, XmlAttribute.PARTITION, false));
        properties.setMerge(JobParser.getAttributeValue(reader, XmlAttribute.MERGE, false));
        while (reader.hasNext()) {
            int eventType = reader.next();
            if (eventType != 1 && eventType != 2) continue;
            XmlElement element = XmlElement.forName(reader.getLocalName());
            switch (eventType) {
                case 1: {
                    if (element == XmlElement.PROPERTY) {
                        properties.add(JobParser.getAttributeValue(reader, XmlAttribute.NAME, true), JobParser.getAttributeValue(reader, XmlAttribute.VALUE, false));
                        break;
                    }
                    throw BatchMessages.MESSAGES.unexpectedXmlElement(reader.getLocalName(), reader.getLocation());
                }
                case 2: {
                    if (element == XmlElement.PROPERTIES) {
                        return properties;
                    }
                    if (element == XmlElement.PROPERTY) break;
                    throw BatchMessages.MESSAGES.unexpectedXmlElement(reader.getLocalName(), reader.getLocation());
                }
            }
        }
        throw BatchMessages.MESSAGES.unexpectedXmlElement(reader.getLocalName(), reader.getLocation());
    }

    private static Listeners parseListeners(XMLStreamReader reader) throws XMLStreamException {
        Listeners listeners = new Listeners();
        List<RefArtifact> listenerList = listeners.getListeners();
        listeners.setMerge(JobParser.getAttributeValue(reader, XmlAttribute.MERGE, false));
        while (reader.hasNext()) {
            int eventType = reader.next();
            if (eventType != 1 && eventType != 2) continue;
            XmlElement element = XmlElement.forName(reader.getLocalName());
            switch (eventType) {
                case 1: {
                    if (element == XmlElement.LISTENER) {
                        listenerList.add(JobParser.parseRefArtifact(reader, element));
                        break;
                    }
                    throw BatchMessages.MESSAGES.unexpectedXmlElement(reader.getLocalName(), reader.getLocation());
                }
                case 2: {
                    if (element == XmlElement.LISTENERS) {
                        return listeners;
                    }
                    throw BatchMessages.MESSAGES.unexpectedXmlElement(reader.getLocalName(), reader.getLocation());
                }
            }
        }
        throw BatchMessages.MESSAGES.unexpectedXmlElement(reader.getLocalName(), reader.getLocation());
    }

    private static RefArtifact parseRefArtifact(XMLStreamReader reader, XmlElement artifactElementType) throws XMLStreamException {
        RefArtifact refArtifact = new RefArtifact(JobParser.getAttributeValue(reader, XmlAttribute.REF, true));
        while (reader.hasNext()) {
            int eventType = reader.next();
            if (eventType != 1 && eventType != 2) continue;
            XmlElement element = XmlElement.forName(reader.getLocalName());
            switch (eventType) {
                case 1: {
                    if (element == XmlElement.PROPERTIES) {
                        refArtifact.setProperties(JobParser.parseProperties(reader));
                        break;
                    }
                    throw BatchMessages.MESSAGES.unexpectedXmlElement(reader.getLocalName(), reader.getLocation());
                }
                case 2: {
                    if (element == artifactElementType) {
                        return refArtifact;
                    }
                    throw BatchMessages.MESSAGES.unexpectedXmlElement(reader.getLocalName(), reader.getLocation());
                }
            }
        }
        throw BatchMessages.MESSAGES.unexpectedXmlElement(reader.getLocalName(), reader.getLocation());
    }

    private static Chunk parseChunk(XMLStreamReader reader) throws XMLStreamException {
        Chunk chunk = new Chunk();
        chunk.setCheckpointPolicy(JobParser.getAttributeValue(reader, XmlAttribute.CHECKPOINT_POLICY, false));
        chunk.setItemCount(JobParser.getAttributeValue(reader, XmlAttribute.ITEM_COUNT, false));
        chunk.setTimeLimit(JobParser.getAttributeValue(reader, XmlAttribute.TIME_LIMIT, false));
        chunk.setSkipLimit(JobParser.getAttributeValue(reader, XmlAttribute.SKIP_LIMIT, false));
        chunk.setRetryLimit(JobParser.getAttributeValue(reader, XmlAttribute.RETRY_LIMIT, false));
        while (reader.hasNext()) {
            int eventType = reader.next();
            if (eventType != 1 && eventType != 2) continue;
            XmlElement element = XmlElement.forName(reader.getLocalName());
            block0 : switch (eventType) {
                case 1: {
                    switch (element) {
                        case READER: {
                            chunk.setReader(JobParser.parseRefArtifact(reader, XmlElement.READER));
                            break block0;
                        }
                        case PROCESSOR: {
                            chunk.setProcessor(JobParser.parseRefArtifact(reader, XmlElement.PROCESSOR));
                            break block0;
                        }
                        case WRITER: {
                            chunk.setWriter(JobParser.parseRefArtifact(reader, XmlElement.WRITER));
                            break block0;
                        }
                        case CHECKPOINT_ALGORITHM: {
                            chunk.setCheckpointAlgorithm(JobParser.parseRefArtifact(reader, XmlElement.CHECKPOINT_ALGORITHM));
                            break block0;
                        }
                        case SKIPPABLE_EXCEPTION_CLASSES: {
                            chunk.setSkippableExceptionClasses(JobParser.parseExceptionClassFilter(reader, XmlElement.SKIPPABLE_EXCEPTION_CLASSES));
                            break block0;
                        }
                        case RETRYABLE_EXCEPTION_CLASSES: {
                            chunk.setRetryableExceptionClasses(JobParser.parseExceptionClassFilter(reader, XmlElement.RETRYABLE_EXCEPTION_CLASSES));
                            break block0;
                        }
                        case NO_ROLLBACK_EXCEPTION_CLASSES: {
                            chunk.setNoRollbackExceptionClasses(JobParser.parseExceptionClassFilter(reader, XmlElement.NO_ROLLBACK_EXCEPTION_CLASSES));
                            break block0;
                        }
                    }
                    throw BatchMessages.MESSAGES.unexpectedXmlElement(reader.getLocalName(), reader.getLocation());
                }
                case 2: {
                    if (element == XmlElement.CHUNK) {
                        return chunk;
                    }
                    throw BatchMessages.MESSAGES.unexpectedXmlElement(reader.getLocalName(), reader.getLocation());
                }
            }
        }
        throw BatchMessages.MESSAGES.unexpectedXmlElement(reader.getLocalName(), reader.getLocation());
    }

    private static Partition parsePartition(XMLStreamReader reader) throws XMLStreamException {
        Partition partition = new Partition();
        while (reader.hasNext()) {
            int eventType = reader.next();
            if (eventType != 1 && eventType != 2) continue;
            XmlElement element = XmlElement.forName(reader.getLocalName());
            block0 : switch (eventType) {
                case 1: {
                    switch (element) {
                        case MAPPER: {
                            partition.setMapper(JobParser.parseRefArtifact(reader, XmlElement.MAPPER));
                            break block0;
                        }
                        case PLAN: {
                            partition.setPlan(JobParser.parsePartitionPlan(reader));
                            break block0;
                        }
                        case COLLECTOR: {
                            partition.setCollector(JobParser.parseRefArtifact(reader, XmlElement.COLLECTOR));
                            break block0;
                        }
                        case ANALYZER: {
                            partition.setAnalyzer(JobParser.parseRefArtifact(reader, XmlElement.ANALYZER));
                            break block0;
                        }
                        case REDUCER: {
                            partition.setReducer(JobParser.parseRefArtifact(reader, XmlElement.REDUCER));
                            break block0;
                        }
                    }
                    throw BatchMessages.MESSAGES.unexpectedXmlElement(reader.getLocalName(), reader.getLocation());
                }
                case 2: {
                    if (element == XmlElement.PARTITION) {
                        return partition;
                    }
                    throw BatchMessages.MESSAGES.unexpectedXmlElement(reader.getLocalName(), reader.getLocation());
                }
            }
        }
        throw BatchMessages.MESSAGES.unexpectedXmlElement(reader.getLocalName(), reader.getLocation());
    }

    private static PartitionPlan parsePartitionPlan(XMLStreamReader reader) throws XMLStreamException {
        PartitionPlan partitionPlan = new PartitionPlan();
        partitionPlan.setThreads(JobParser.getAttributeValue(reader, XmlAttribute.THREADS, false));
        partitionPlan.setPartitions(JobParser.getAttributeValue(reader, XmlAttribute.PARTITIONS, false));
        while (reader.hasNext()) {
            int eventType = reader.next();
            if (eventType != 1 && eventType != 2) continue;
            XmlElement element = XmlElement.forName(reader.getLocalName());
            switch (eventType) {
                case 1: {
                    if (element == XmlElement.PROPERTIES) {
                        partitionPlan.addProperties(JobParser.parseProperties(reader));
                        break;
                    }
                    throw BatchMessages.MESSAGES.unexpectedXmlElement(reader.getLocalName(), reader.getLocation());
                }
                case 2: {
                    if (element == XmlElement.PLAN) {
                        return partitionPlan;
                    }
                    throw BatchMessages.MESSAGES.unexpectedXmlElement(reader.getLocalName(), reader.getLocation());
                }
            }
        }
        throw BatchMessages.MESSAGES.unexpectedXmlElement(reader.getLocalName(), reader.getLocation());
    }

    private static Transition.Next parseNext(XMLStreamReader reader) throws XMLStreamException {
        Transition.Next next = new Transition.Next(JobParser.getAttributeValue(reader, XmlAttribute.ON, true));
        next.setTo(JobParser.getAttributeValue(reader, XmlAttribute.TO, true));
        JobParser.finishTransitionElement(reader, XmlElement.NEXT);
        return next;
    }

    private static Transition.Fail parseFail(XMLStreamReader reader) throws XMLStreamException {
        Transition.Fail fail = new Transition.Fail(JobParser.getAttributeValue(reader, XmlAttribute.ON, true));
        fail.setExitStatus(JobParser.getAttributeValue(reader, XmlAttribute.EXIT_STATUS, false));
        JobParser.finishTransitionElement(reader, XmlElement.FAIL);
        return fail;
    }

    private static Transition.End parseEnd(XMLStreamReader reader) throws XMLStreamException {
        Transition.End end = new Transition.End(JobParser.getAttributeValue(reader, XmlAttribute.ON, true));
        end.setExitStatus(JobParser.getAttributeValue(reader, XmlAttribute.EXIT_STATUS, false));
        JobParser.finishTransitionElement(reader, XmlElement.END);
        return end;
    }

    private static Transition.Stop parseStop(XMLStreamReader reader) throws XMLStreamException {
        Transition.Stop stop = new Transition.Stop(JobParser.getAttributeValue(reader, XmlAttribute.ON, true), JobParser.getAttributeValue(reader, XmlAttribute.RESTART, false));
        stop.setExitStatus(JobParser.getAttributeValue(reader, XmlAttribute.EXIT_STATUS, false));
        JobParser.finishTransitionElement(reader, XmlElement.STOP);
        return stop;
    }

    private static void finishTransitionElement(XMLStreamReader reader, XmlElement transitionElement) throws XMLStreamException {
        while (reader.hasNext()) {
            int eventType = reader.next();
            if (eventType != 1 && eventType != 2) continue;
            XmlElement element = XmlElement.forName(reader.getLocalName());
            if (eventType == 2 && element == transitionElement) {
                return;
            }
            throw BatchMessages.MESSAGES.unexpectedXmlElement(reader.getLocalName(), reader.getLocation());
        }
        throw BatchMessages.MESSAGES.unexpectedXmlElement(reader.getLocalName(), reader.getLocation());
    }

    private static ExceptionClassFilter parseExceptionClassFilter(XMLStreamReader reader, XmlElement artifactElementType) throws XMLStreamException {
        ExceptionClassFilter filter = new ExceptionClassFilter();
        filter.setMerge(JobParser.getAttributeValue(reader, XmlAttribute.MERGE, false));
        while (reader.hasNext()) {
            int eventType = reader.next();
            if (eventType != 1 && eventType != 2) continue;
            XmlElement element = XmlElement.forName(reader.getLocalName());
            block0 : switch (eventType) {
                case 1: {
                    switch (element) {
                        case INCLUDE: {
                            ExceptionClassFilter.addExceptionClassTo(JobParser.getAttributeValue(reader, XmlAttribute.CLASS, true), filter.include);
                            break block0;
                        }
                        case EXCLUDE: {
                            ExceptionClassFilter.addExceptionClassTo(JobParser.getAttributeValue(reader, XmlAttribute.CLASS, true), filter.exclude);
                            break block0;
                        }
                    }
                    throw BatchMessages.MESSAGES.unexpectedXmlElement(reader.getLocalName(), reader.getLocation());
                }
                case 2: {
                    if (element == artifactElementType) {
                        return filter;
                    }
                    if (element == XmlElement.INCLUDE || element == XmlElement.EXCLUDE) break;
                    throw BatchMessages.MESSAGES.unexpectedXmlElement(reader.getLocalName(), reader.getLocation());
                }
            }
        }
        throw BatchMessages.MESSAGES.unexpectedXmlElement(reader.getLocalName(), reader.getLocation());
    }
}

