/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.runner;

import java.io.File;
import org.jboss.as.patching.metadata.ContentItem;
import org.jboss.as.patching.runner.PatchContentLoader;

public interface PatchContentProvider {
    public static final PatchContentProvider ROLLBACK_PROVIDER = new PatchContentProvider(){

        @Override
        public PatchContentLoader getLoader(String patchId) {
            return new PatchContentLoader(){

                @Override
                public File getFile(ContentItem item) {
                    throw new IllegalStateException();
                }
            };
        }

        @Override
        public void cleanup() {
        }
    };

    public PatchContentLoader getLoader(String var1);

    public void cleanup();

    public static class DefaultContentProvider
    implements PatchContentProvider {
        private final File workDir;

        private DefaultContentProvider(File tempDir) {
            this.workDir = tempDir;
        }

        @Override
        public PatchContentLoader getLoader(String patchId) {
            File root = new File(this.workDir, patchId);
            return PatchContentLoader.create(root);
        }

        @Override
        public void cleanup() {
        }

        static DefaultContentProvider create(File tempDir) {
            return new DefaultContentProvider(tempDir);
        }
    }
}

