/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.tools.log;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.objectstore.ObjectStoreIterator;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.tools.log.TransactionTypeManager;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import com.arjuna.ats.internal.arjuna.tools.log.EditableTransaction;
import java.io.IOException;

class LogConsole {
    public static final int MAX_COMMAND_LEN = 1024;
    public static final String DEFAULT_TYPE = "AtomicAction";
    public static final String ls = "ls";
    public static final String attach = "attach";
    public static final String detach = "detach";
    public static final String forget = "forget";
    public static final String delete = "delete";
    public static final String quit = "quit";
    public static final String select = "select";
    public static final String types = "types";
    public static final String help = "help";
    private static final String SPACE = " ";
    private static final String END = "\n";
    private String _currentLog = "";
    private String _transactionType = "";

    LogConsole() {
    }

    public void doWork() {
        boolean attached = false;
        boolean exit = false;
        boolean selected = false;
        while (!exit) {
            byte[] command = new byte[1024];
            try {
                System.out.print(END + this._transactionType + " - " + this._currentLog + " > ");
                System.in.read(command);
                String commandString = new String(command);
                Command com = this.validCommand(commandString);
                switch (com) {
                    case quit: {
                        return;
                    }
                    case help: {
                        this.help();
                        break;
                    }
                    case ls: {
                        if (!selected) {
                            System.err.println("No transaction type selected.");
                        } else if (this._currentLog == "") {
                            this.listLogs(this._transactionType);
                        } else {
                            this.dumpLog(new Uid(this._currentLog));
                        }
                        System.out.println();
                        break;
                    }
                    case select: {
                        if (attached) {
                            System.out.println("Detaching from existing log.");
                            attached = false;
                        }
                        this.setTransactionType(commandString);
                        if ("".equals(this._transactionType)) {
                            System.err.println("Unsupported type.");
                            selected = false;
                            break;
                        }
                        selected = true;
                        break;
                    }
                    case attach: {
                        if (attached) {
                            System.err.println("Already attached.");
                            break;
                        }
                        this.setLogId(commandString);
                        if ("".equals(this._currentLog)) {
                            System.err.println("Invalid log id.");
                            break;
                        }
                        attached = true;
                        break;
                    }
                    case detach: {
                        if (!attached) {
                            System.err.println("Not attached.");
                        }
                        this._currentLog = "";
                        attached = false;
                        break;
                    }
                    case forget: {
                        if (!attached) {
                            System.err.println("Not attached.");
                        }
                        Uid u = new Uid(this._currentLog);
                        EditableTransaction act = TransactionTypeManager.getInstance().getTransaction(this._transactionType, u);
                        try {
                            act.moveHeuristicToPrepared(this.getIndex(commandString));
                        }
                        catch (IndexOutOfBoundsException ex) {
                            System.err.println("Invalid index.");
                        }
                        this.dumpLog(u);
                        break;
                    }
                    case delete: {
                        if (!attached) {
                            System.err.println("Not attached.");
                        }
                        Uid uid = new Uid(this._currentLog);
                        EditableTransaction ract = TransactionTypeManager.getInstance().getTransaction(this._transactionType, uid);
                        try {
                            ract.deleteHeuristicParticipant(this.getIndex(commandString));
                        }
                        catch (IndexOutOfBoundsException ex) {
                            System.err.println("Invalid index.");
                        }
                        this.dumpLog(uid);
                        break;
                    }
                    case types: {
                        this.printSupportedTypes();
                        break;
                    }
                    default: {
                        System.err.println("Invalid command " + new String(command));
                        break;
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void dumpLog(Uid u) {
        EditableTransaction act = TransactionTypeManager.getInstance().getTransaction(this._transactionType, u);
        if (act == null) {
            System.out.println("Dump failed! Unknown type " + this._transactionType);
        } else {
            System.out.println(act.toString());
        }
    }

    private void printSupportedTypes() {
        System.out.println(DEFAULT_TYPE);
    }

    private final Command validCommand(String command) {
        if (command == null) {
            return Command.invalid;
        }
        if (!command.startsWith(ls)) {
            if (!command.startsWith(attach)) {
                if (!command.startsWith(detach)) {
                    if (!command.startsWith(forget)) {
                        if (!command.startsWith(delete)) {
                            if (!command.startsWith(quit)) {
                                if (!command.startsWith(select)) {
                                    if (!command.startsWith(types)) {
                                        if (!command.startsWith(help)) {
                                            return Command.invalid;
                                        }
                                        return Command.help;
                                    }
                                    return Command.types;
                                }
                                return Command.select;
                            }
                            return Command.quit;
                        }
                        return Command.delete;
                    }
                    return Command.forget;
                }
                return Command.detach;
            }
            return Command.attach;
        }
        return Command.ls;
    }

    private final void setTransactionType(String command) {
        int index = command.indexOf(SPACE);
        int end = command.indexOf(END);
        this._transactionType = index != -1 ? new String(command.substring(index + 1, end).trim()) : DEFAULT_TYPE;
        if (!TransactionTypeManager.getInstance().present(this._transactionType)) {
            System.err.println("Transaction log type " + this._transactionType + " not supported.");
            this._transactionType = "";
        }
    }

    private final void setLogId(String command) {
        int index = command.indexOf(SPACE);
        int end = command.indexOf(END);
        if (index != -1) {
            this._currentLog = new String(command.substring(index + 1, end).trim());
            if (!this.supportedLog(this._currentLog)) {
                this._currentLog = "";
            }
        } else {
            this._currentLog = "";
        }
    }

    private final int getIndex(String command) {
        int index = command.indexOf(SPACE);
        int end = command.indexOf(END);
        if (index != -1) {
            try {
                return Integer.parseInt(command.substring(index + 1, end).trim());
            }
            catch (Exception ex) {
                return -1;
            }
        }
        return -1;
    }

    private final void listLogs(String type) throws IOException {
        InputObjectState buff = new InputObjectState();
        try {
            if (StoreManager.getRecoveryStore().allObjUids(TransactionTypeManager.getInstance().getTransactionType(type), buff)) {
                Uid u = null;
                do {
                    u = UidHelper.unpackFrom(buff);
                    if (!Uid.nullUid().notEquals(u)) continue;
                    System.out.println("Log: " + u);
                } while (Uid.nullUid().notEquals(u));
            }
        }
        catch (ObjectStoreException ex) {
            throw new IOException();
        }
    }

    private final boolean supportedLog(String logID) {
        Uid u;
        Uid id = new Uid(logID);
        if (id.equals(Uid.nullUid())) {
            return false;
        }
        ObjectStoreIterator iter = new ObjectStoreIterator(StoreManager.getRecoveryStore(), TransactionTypeManager.getInstance().getTransactionType(this._transactionType));
        do {
            if (!(u = iter.iterate()).equals(id)) continue;
            return true;
        } while (Uid.nullUid().notEquals(u));
        return false;
    }

    private final void help() {
        System.out.println("\nls <type> - list logs for specified type. If no type specified then must be already attached.");
        System.out.println("select [<type] - browse a specific type of transaction. Automatically detaches.");
        System.out.println("attach <log> - cannot be attached to another log.");
        System.out.println("detach - must be attached to log.");
        System.out.println("forget <pid> - must be attached to log.");
        System.out.println("delete <pid> - must be attached to log.");
        System.out.println("types - lists supported transaction types.");
        System.out.println("quit - exit.");
        System.out.println("help - print out commands.\n");
    }

    private static enum Command {
        invalid,
        ls,
        attach,
        detach,
        forget,
        delete,
        quit,
        select,
        types,
        help;

    }
}

