/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.service;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.acl.Group;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.jacc.EJBRoleRefPermission;
import org.jboss.as.core.security.ServerSecurityManager;
import org.jboss.as.core.security.SubjectUserInfo;
import org.jboss.as.domain.management.security.PasswordCredential;
import org.jboss.as.security.SecurityMessages;
import org.jboss.as.security.remoting.RemotingConnectionCredential;
import org.jboss.as.security.remoting.RemotingConnectionPrincipal;
import org.jboss.as.security.service.SecurityActions;
import org.jboss.as.security.service.ThreadLocalStack;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.security.UserInfo;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.RunAs;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;
import org.jboss.security.SecurityContextUtil;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.SubjectInfo;
import org.jboss.security.audit.AuditEvent;
import org.jboss.security.audit.AuditManager;
import org.jboss.security.authorization.Resource;
import org.jboss.security.authorization.config.AuthorizationModuleEntry;
import org.jboss.security.authorization.modules.JACCAuthorizationModule;
import org.jboss.security.authorization.resources.EJBResource;
import org.jboss.security.callbacks.SecurityContextCallbackHandler;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.AuthorizationInfo;
import org.jboss.security.config.SecurityConfiguration;
import org.jboss.security.identity.Identity;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.identity.plugins.SimpleIdentity;
import org.jboss.security.identity.plugins.SimpleRoleGroup;
import org.jboss.security.javaee.AbstractEJBAuthorizationHelper;
import org.jboss.security.javaee.SecurityHelperFactory;
import org.wildfly.security.manager.WildFlySecurityManager;

public class SimpleSecurityManager
implements ServerSecurityManager {
    private ThreadLocalStack<SecurityContext> contexts = new ThreadLocalStack();
    private boolean propagate = true;
    private ISecurityManagement securityManagement = null;

    public SimpleSecurityManager() {
    }

    public SimpleSecurityManager(SimpleSecurityManager delegate) {
        this.securityManagement = delegate.securityManagement;
        this.propagate = false;
    }

    private PrivilegedAction<SecurityContext> securityContext() {
        return new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        };
    }

    private SecurityContext establishSecurityContext(String securityDomain) {
        try {
            SecurityContext securityContext = SecurityContextFactory.createSecurityContext((String)securityDomain);
            if (this.securityManagement == null) {
                throw SecurityMessages.MESSAGES.securityManagementNotInjected();
            }
            securityContext.setSecurityManagement(this.securityManagement);
            SecurityContextAssociation.setSecurityContext((SecurityContext)securityContext);
            return securityContext;
        }
        catch (Exception e) {
            throw SecurityMessages.MESSAGES.securityException(e);
        }
    }

    public void setSecurityManagement(ISecurityManagement iSecurityManagement) {
        this.securityManagement = iSecurityManagement;
    }

    public Principal getCallerPrincipal() {
        SecurityContext securityContext = AccessController.doPrivileged(this.securityContext());
        if (securityContext == null) {
            return this.getUnauthenticatedIdentity().asPrincipal();
        }
        Object principal = securityContext.getIncomingRunAs();
        if (principal == null) {
            principal = this.getPrincipal(this.getSubjectInfo(securityContext).getAuthenticatedSubject());
        }
        if (principal == null) {
            return this.getUnauthenticatedIdentity().asPrincipal();
        }
        return principal;
    }

    public Subject getSubject() {
        SecurityContext securityContext = AccessController.doPrivileged(this.securityContext());
        if (securityContext != null) {
            return this.getSubjectInfo(securityContext).getAuthenticatedSubject();
        }
        return null;
    }

    private Principal getPrincipal(Subject subject) {
        Set<Principal> principals;
        Principal principal = null;
        Principal callerPrincipal = null;
        if (subject != null && (principals = subject.getPrincipals()) != null && !principals.isEmpty()) {
            for (Principal p : principals) {
                Enumeration e;
                Group g;
                if (!(p instanceof Group) && principal == null) {
                    principal = p;
                }
                if (!(p instanceof Group) || !(g = (Group)Group.class.cast(p)).getName().equals("CallerPrincipal") || callerPrincipal != null || !(e = g.members()).hasMoreElements()) continue;
                callerPrincipal = (Principal)e.nextElement();
            }
        }
        return callerPrincipal == null ? principal : callerPrincipal;
    }

    public boolean isCallerInRole(String ejbName, Object incommingMappedRoles, Map<String, Collection<String>> roleLinks, String ... roleNames) {
        Principal callerPrincipal;
        Set mapped;
        SecurityRolesMetaData mappedRoles = (SecurityRolesMetaData)incommingMappedRoles;
        SecurityContext securityContext = AccessController.doPrivileged(this.securityContext());
        if (securityContext == null) {
            return false;
        }
        RoleGroup roleGroup = null;
        RunAs runAs = securityContext.getIncomingRunAs();
        if (runAs != null && runAs instanceof RunAsIdentity) {
            RunAsIdentity runAsIdentity = (RunAsIdentity)runAs;
            roleGroup = runAsIdentity.getRunAsRolesAsRoleGroup();
        } else {
            AuthorizationManager am = securityContext.getAuthorizationManager();
            SecurityContextCallbackHandler scb = new SecurityContextCallbackHandler(securityContext);
            Subject authenticatedSubject = this.getSubjectInfo(securityContext).getAuthenticatedSubject();
            roleGroup = this.getSubjectRoles(am, scb, authenticatedSubject);
        }
        if (roleGroup == null) {
            return false;
        }
        List roles = roleGroup.getRoles();
        HashSet<String> requiredRoles = new HashSet<String>();
        for (String current : roleNames) {
            requiredRoles.add(current);
        }
        HashSet<String> actualRoles = new HashSet<String>();
        for (Role current : roles) {
            actualRoles.add(current.getRoleName());
        }
        if (mappedRoles != null && (mapped = mappedRoles.getSecurityRoleNamesByPrincipal((callerPrincipal = this.getCallerPrincipal()).getName())) != null) {
            actualRoles.addAll(mapped);
        }
        if (this.isJaccEnabled(securityContext.getSecurityDomain())) {
            HashSet<SimplePrincipal> rolesPrincipals = new HashSet<SimplePrincipal>();
            for (String role : actualRoles) {
                rolesPrincipals.add(new SimplePrincipal(role));
            }
            for (String roleName : requiredRoles) {
                EJBRoleRefPermission permission = new EJBRoleRefPermission(ejbName, roleName);
                ProtectionDomain pd = new ProtectionDomain(null, null, null, rolesPrincipals.toArray(new Principal[rolesPrincipals.size()]));
                if (!SecurityActions.getPolicy().implies(pd, (Permission)permission)) continue;
                return true;
            }
            return false;
        }
        if (!Collections.disjoint(requiredRoles, actualRoles)) {
            return true;
        }
        if (roleLinks != null) {
            for (String actualRole : actualRoles) {
                Set<String> aliases = this.getRoleAliases(actualRole, roleLinks);
                if (Collections.disjoint(requiredRoles, aliases)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean authorize(String ejbName, CodeSource ejbCodeSource, String ejbMethodIntf, Method ejbMethod, Set<Principal> methodRoles, String contextID) {
        SecurityContext securityContext = AccessController.doPrivileged(this.securityContext());
        if (securityContext == null) {
            return false;
        }
        EJBResource resource = new EJBResource(new HashMap());
        resource.setEjbName(ejbName);
        resource.setEjbMethod(ejbMethod);
        resource.setEjbMethodInterface(ejbMethodIntf);
        resource.setEjbMethodRoles((RoleGroup)new SimpleRoleGroup(methodRoles));
        resource.setCodeSource(ejbCodeSource);
        resource.setPolicyContextID(contextID);
        resource.setCallerRunAsIdentity(securityContext.getIncomingRunAs());
        resource.setCallerSubject(securityContext.getUtil().getSubject());
        Principal userPrincipal = securityContext.getUtil().getUserPrincipal();
        resource.setPrincipal(userPrincipal);
        try {
            AbstractEJBAuthorizationHelper helper = SecurityHelperFactory.getEJBAuthorizationHelper((SecurityContext)securityContext);
            return helper.authorize((Resource)resource);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void push(String securityDomain) {
        RunAs currentRunAs;
        boolean trusted;
        SecurityContext previous = SecurityContextAssociation.getSecurityContext();
        this.contexts.push(previous);
        SecurityContext current = this.establishSecurityContext(securityDomain);
        if (this.propagate && previous != null) {
            current.setSubjectInfo(this.getSubjectInfo(previous));
            current.setIncomingRunAs(previous.getOutgoingRunAs());
        }
        boolean bl = trusted = (currentRunAs = current.getIncomingRunAs()) != null && currentRunAs instanceof RunAsIdentity;
        if (!trusted && SecurityActions.remotingContextIsSet()) {
            SubjectUserInfo sinfo;
            Subject subject;
            Set<PasswordCredential> pcSet;
            SecurityContextUtil util = current.getUtil();
            Connection connection = SecurityActions.remotingContextGetConnection();
            UserInfo userInfo = connection.getUserInfo();
            RemotingConnectionPrincipal p = null;
            Object credential = null;
            if (userInfo instanceof SubjectUserInfo && (pcSet = (subject = (sinfo = (SubjectUserInfo)userInfo).getSubject()).getPrivateCredentials(PasswordCredential.class)).size() > 0) {
                PasswordCredential pc = pcSet.iterator().next();
                p = new SimplePrincipal(pc.getUserName());
                credential = new String(pc.getCredential());
            }
            if (p == null || credential == null) {
                p = new RemotingConnectionPrincipal(connection);
                credential = new RemotingConnectionCredential(connection);
            }
            SecurityActions.remotingContextClear();
            util.createSubjectInfo((Principal)p, credential, null);
        }
    }

    public void push(String securityDomain, String userName, char[] password, Subject subject) {
        RunAs currentRunAs;
        boolean trusted;
        SecurityContext previous = SecurityContextAssociation.getSecurityContext();
        this.contexts.push(previous);
        SecurityContext current = this.establishSecurityContext(securityDomain);
        if (this.propagate && previous != null) {
            current.setSubjectInfo(this.getSubjectInfo(previous));
            current.setIncomingRunAs(previous.getOutgoingRunAs());
        }
        boolean bl = trusted = (currentRunAs = current.getIncomingRunAs()) != null && currentRunAs instanceof RunAsIdentity;
        if (!trusted) {
            SecurityContextUtil util = current.getUtil();
            util.createSubjectInfo((Principal)new SimplePrincipal(userName), (Object)new String(password), subject);
        }
    }

    public void authenticate() {
        this.authenticate(null, null, null);
    }

    public void authenticate(String runAs, String runAsPrincipal, Set<String> extraRoles) {
        SecurityContext context = SecurityContextAssociation.getSecurityContext();
        SecurityContextUtil util = context.getUtil();
        Object credential = util.getCredential();
        Subject subject = null;
        if (credential instanceof RemotingConnectionCredential) {
            subject = ((RemotingConnectionCredential)credential).getSubject();
        }
        if (!this.authenticate(context, subject)) {
            throw SecurityMessages.MESSAGES.invalidUserException();
        }
        SecurityContext previous = this.contexts.peek();
        if (runAs != null) {
            RunAsIdentity runAsIdentity = new RunAsIdentity(runAs, runAsPrincipal, extraRoles);
            context.setOutgoingRunAs((RunAs)runAsIdentity);
        } else if (this.propagate && previous != null && previous.getOutgoingRunAs() != null) {
            context.setOutgoingRunAs(previous.getOutgoingRunAs());
        }
    }

    private boolean authenticate(SecurityContext context, Subject subject) {
        AuditManager auditManager;
        Principal principal;
        SecurityContextUtil util = context.getUtil();
        SubjectInfo subjectInfo = this.getSubjectInfo(context);
        if (subject == null) {
            subject = new Subject();
        }
        Principal auditPrincipal = principal = util.getUserPrincipal();
        Object credential = util.getCredential();
        Identity unauthenticatedIdentity = null;
        boolean authenticated = false;
        if (principal == null) {
            unauthenticatedIdentity = this.getUnauthenticatedIdentity();
            subjectInfo.addIdentity(unauthenticatedIdentity);
            auditPrincipal = unauthenticatedIdentity.asPrincipal();
            subject.getPrincipals().add(auditPrincipal);
            authenticated = true;
        } else {
            subject.getPrincipals().add(principal);
        }
        if (!authenticated) {
            AuthenticationManager authenticationManager = context.getAuthenticationManager();
            authenticated = authenticationManager.isValid(principal, credential, subject);
        }
        if (authenticated) {
            subjectInfo.setAuthenticatedSubject(subject);
        }
        if ((auditManager = context.getAuditManager()) != null) {
            this.audit(authenticated ? "Success" : "Failure", auditManager, auditPrincipal);
        }
        return authenticated;
    }

    private Identity getUnauthenticatedIdentity() {
        return new SimpleIdentity("anonymous");
    }

    public void pop() {
        SecurityContext sc = this.contexts.pop();
        SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
    }

    private Set<String> getRoleAliases(String roleName, Map<String, Collection<String>> roleLinks) {
        if (roleLinks == null || roleLinks.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> aliases = new HashSet<String>();
        for (Map.Entry<String, Collection<String>> roleLinkEntry : roleLinks.entrySet()) {
            String aliasRoleName = roleLinkEntry.getKey();
            Collection<String> realRoleNames = roleLinkEntry.getValue();
            if (realRoleNames == null || !realRoleNames.contains(roleName)) continue;
            aliases.add(aliasRoleName);
        }
        return aliases;
    }

    private void audit(String level, AuditManager auditManager, Principal userPrincipal) {
        AuditEvent auditEvent = new AuditEvent("Success");
        HashMap<String, String> ctxMap = new HashMap<String, String>();
        ctxMap.put("principal", userPrincipal != null ? userPrincipal.getName() : "null");
        ctxMap.put("Source", this.getClass().getCanonicalName());
        ctxMap.put("Action", "authentication");
        auditEvent.setContextMap(ctxMap);
        auditManager.audit(auditEvent);
    }

    private SubjectInfo getSubjectInfo(final SecurityContext context) {
        if (System.getSecurityManager() == null) {
            return context.getSubjectInfo();
        }
        return AccessController.doPrivileged(new PrivilegedAction<SubjectInfo>(){

            @Override
            public SubjectInfo run() {
                return context.getSubjectInfo();
            }
        });
    }

    private RoleGroup getSubjectRoles(final AuthorizationManager am, final SecurityContextCallbackHandler scb, final Subject authenticatedSubject) {
        if (System.getSecurityManager() == null) {
            return am.getSubjectRoles(authenticatedSubject, (CallbackHandler)scb);
        }
        return AccessController.doPrivileged(new PrivilegedAction<RoleGroup>(){

            @Override
            public RoleGroup run() {
                return am.getSubjectRoles(authenticatedSubject, (CallbackHandler)scb);
            }
        });
    }

    private boolean isJaccEnabled(final String securityDomain) {
        AuthorizationInfo authorizationInfo;
        if (WildFlySecurityManager.isChecking()) {
            return (Boolean)WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    AuthorizationInfo authorizationInfo;
                    ApplicationPolicy applicationPolicy = SecurityConfiguration.getApplicationPolicy((String)securityDomain);
                    if (applicationPolicy != null && (authorizationInfo = applicationPolicy.getAuthorizationInfo()) != null) {
                        for (AuthorizationModuleEntry entry : authorizationInfo.getModuleEntries()) {
                            if (!JACCAuthorizationModule.class.getName().equals(entry.getPolicyModuleName())) continue;
                            return true;
                        }
                    }
                    return false;
                }
            });
        }
        ApplicationPolicy applicationPolicy = SecurityConfiguration.getApplicationPolicy((String)securityDomain);
        if (applicationPolicy != null && (authorizationInfo = applicationPolicy.getAuthorizationInfo()) != null) {
            for (AuthorizationModuleEntry entry : authorizationInfo.getModuleEntries()) {
                if (!JACCAuthorizationModule.class.getName().equals(entry.getPolicyModuleName())) continue;
                return true;
            }
        }
        return false;
    }
}

