/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.discovery;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.weld.WeldLogger;
import org.jboss.as.weld.WeldMessages;
import org.jboss.as.weld.discovery.WeldClassFileInfo;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.weld.resources.spi.ClassFileInfo;
import org.jboss.weld.resources.spi.ClassFileServices;

public class WeldClassFileServices
implements ClassFileServices {
    private CompositeIndex index;
    private LoadingCache<DotName, Set<String>> annotationClassAnnotationsCache;
    private final ClassLoader moduleClassLoader;

    public WeldClassFileServices(CompositeIndex index, ClassLoader moduleClassLoader) {
        if (index == null) {
            throw WeldMessages.MESSAGES.cannotUseAtRuntime(ClassFileServices.class.getSimpleName());
        }
        this.moduleClassLoader = moduleClassLoader;
        this.index = index;
        this.annotationClassAnnotationsCache = CacheBuilder.newBuilder().build((CacheLoader)new AnnotationClassAnnotationLoader());
    }

    public ClassFileInfo getClassFileInfo(String className) {
        return new WeldClassFileInfo(className, this.index, this.annotationClassAnnotationsCache, this.moduleClassLoader);
    }

    public void cleanupAfterBoot() {
        if (this.annotationClassAnnotationsCache != null) {
            this.annotationClassAnnotationsCache.invalidateAll();
            this.annotationClassAnnotationsCache = null;
        }
        this.index = null;
    }

    public void cleanup() {
        this.cleanupAfterBoot();
    }

    private class AnnotationClassAnnotationLoader
    extends CacheLoader<DotName, Set<String>> {
        private AnnotationClassAnnotationLoader() {
        }

        public Set<String> load(DotName name) throws Exception {
            ClassInfo annotationClassInfo = WeldClassFileServices.this.index.getClassByName(name);
            ImmutableSet.Builder builder = ImmutableSet.builder();
            if (annotationClassInfo != null) {
                for (DotName annotationName : annotationClassInfo.annotations().keySet()) {
                    builder.add((Object)annotationName.toString());
                }
            } else {
                try {
                    Class<?> annotationClass = WeldClassFileServices.this.moduleClassLoader.loadClass(name.toString());
                    for (Annotation annotation : annotationClass.getDeclaredAnnotations()) {
                        builder.add((Object)annotation.annotationType().getName());
                    }
                }
                catch (ClassNotFoundException e) {
                    WeldLogger.DEPLOYMENT_LOGGER.unableToLoadAnnotation(name.toString());
                }
            }
            return builder.build();
        }
    }
}

