/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.delegation;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.sts.request.ReceivedToken;
import org.apache.cxf.sts.token.delegation.SAMLDelegationHandler;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.w3c.dom.Element;

public class HOKDelegationHandler
extends SAMLDelegationHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(HOKDelegationHandler.class);

    @Override
    protected boolean isDelegationAllowed(ReceivedToken receivedToken, String appliesToAddress) {
        Element validateTargetElement = (Element)receivedToken.getToken();
        try {
            List<String> addresses;
            AssertionWrapper assertion = new AssertionWrapper(validateTargetElement);
            for (String confirmationMethod : assertion.getConfirmationMethods()) {
                if ("urn:oasis:names:tc:SAML:1.0:cm:bearer".equals(confirmationMethod) || "urn:oasis:names:tc:SAML:1.0:cm:holder-of-key".equals(confirmationMethod) || "urn:oasis:names:tc:SAML:2.0:cm:bearer".equals(confirmationMethod) || "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key".equals(confirmationMethod)) continue;
                return false;
            }
            if (this.isCheckAudienceRestriction() && appliesToAddress != null && !(addresses = this.getAudienceRestrictions(assertion)).isEmpty() && !addresses.contains(appliesToAddress)) {
                return false;
            }
        }
        catch (WSSecurityException ex) {
            LOG.log(Level.WARNING, "Error in ascertaining whether delegation is allowed", ex);
            return false;
        }
        return true;
    }
}

