/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.HashMap;
import java.util.List;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.ConnectorServiceConfiguration;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.ConnectorServiceDefinition;
import org.jboss.as.messaging.ConnectorServiceParamDefinition;
import org.jboss.as.messaging.HornetQReloadRequiredHandlers;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class ConnectorServiceAdd
extends HornetQReloadRequiredHandlers.AddStepHandler {
    public static final ConnectorServiceAdd INSTANCE = new ConnectorServiceAdd();

    private ConnectorServiceAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attributeDefinition : ConnectorServiceDefinition.ATTRIBUTES) {
            attributeDefinition.validateAndSet(operation, model);
        }
    }

    static void addConnectorServiceConfigs(OperationContext context, Configuration configuration, ModelNode model) throws OperationFailedException {
        if (model.hasDefined("connector-service")) {
            List configs = configuration.getConnectorServiceConfigurations();
            for (Property prop : model.get("connector-service").asPropertyList()) {
                configs.add(ConnectorServiceAdd.createConnectorServiceConfiguration(context, prop.getName(), prop.getValue()));
            }
        }
    }

    static ConnectorServiceConfiguration createConnectorServiceConfiguration(OperationContext context, String name, ModelNode model) throws OperationFailedException {
        String factoryClass = CommonAttributes.FACTORY_CLASS.resolveModelAttribute(context, model).asString();
        HashMap<String, String> params = new HashMap<String, String>();
        if (model.hasDefined("param")) {
            for (Property property : model.get("param").asPropertyList()) {
                String value = ConnectorServiceParamDefinition.VALUE.resolveModelAttribute(context, property.getValue()).asString();
                params.put(property.getName(), value);
            }
        }
        return new ConnectorServiceConfiguration(factoryClass, params, name);
    }
}

