/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import java.io.OutputStream;

public class UnsafeByteArrayOutputStream
extends OutputStream {
    private byte[] buffer;
    private int index;
    private int startIndex;

    public UnsafeByteArrayOutputStream() {
        this.reInit(new byte[32], 0);
    }

    public UnsafeByteArrayOutputStream(byte[] buffer) {
        this.reInit(buffer, 0);
    }

    public UnsafeByteArrayOutputStream(byte[] buffer, int startPos) {
        this.reInit(buffer, startPos);
    }

    private void grow(int newLength) {
        byte[] newBuffer = new byte[newLength];
        System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
        this.buffer = newBuffer;
    }

    public void reInit(byte[] buffer, int startPos) {
        if (buffer.length == 0) {
            throw new IllegalArgumentException("initial buffer length must be greater than 0.");
        }
        this.buffer = buffer;
        this.index = this.startIndex = startPos;
    }

    public void reInit(byte[] buffer) {
        this.reInit(buffer, 0);
    }

    public void write(int value) throws IOException {
        if (this.index >= this.buffer.length) {
            this.grow(this.buffer.length << 1);
        }
        this.buffer[this.index++] = (byte)value;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int targetLength = this.index + len;
        if (targetLength >= this.buffer.length) {
            int newlen = this.buffer.length;
            while ((newlen <<= 1) < targetLength) {
            }
            this.grow(newlen);
        }
        System.arraycopy(b, off, this.buffer, this.index, len);
        this.index += len;
    }

    public byte[] toByteArray() {
        return this.buffer;
    }

    public int length() {
        return this.index;
    }

    public int getStartPos() {
        return this.startIndex;
    }
}

