/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.encoding;

import java.io.IOException;
import org.apache.lucene.util.encoding.IntDecoder;
import org.apache.lucene.util.encoding.IntEncoder;
import org.apache.lucene.util.encoding.VInt8IntDecoder;

public class VInt8IntEncoder
extends IntEncoder {
    public void encode(int value) throws IOException {
        if ((value & 0xFFFFFF80) == 0) {
            this.out.write(value);
        } else if ((value & 0xFFFFC000) == 0) {
            this.out.write(0x80 | value >> 7);
            this.out.write(0x7F & value);
        } else if ((value & 0xFFE00000) == 0) {
            this.out.write(0x80 | value >> 14);
            this.out.write(0x80 | value >> 7);
            this.out.write(0x7F & value);
        } else if ((value & 0xF0000000) == 0) {
            this.out.write(0x80 | value >> 21);
            this.out.write(0x80 | value >> 14);
            this.out.write(0x80 | value >> 7);
            this.out.write(0x7F & value);
        } else {
            this.out.write(0x80 | value >> 28);
            this.out.write(0x80 | value >> 21);
            this.out.write(0x80 | value >> 14);
            this.out.write(0x80 | value >> 7);
            this.out.write(0x7F & value);
        }
    }

    public IntDecoder createMatchingDecoder() {
        return new VInt8IntDecoder();
    }

    public String toString() {
        return "VInt8";
    }
}

