/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.ListenerRegistry;
import java.io.IOException;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLContext;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.network.SocketBinding;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.undertow.HttpListenerService;
import org.wildfly.extension.undertow.UndertowLogger;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.StreamConnection;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;
import org.xnio.ssl.JsseXnioSsl;
import org.xnio.ssl.SslConnection;

public class HttpsListenerService
extends HttpListenerService {
    private final InjectedValue<SecurityRealm> securityRealm = new InjectedValue();
    private volatile AcceptingChannel<SslConnection> sslServer;
    static final String PROTOCOL = "https";

    public HttpsListenerService(String name, String serverName, OptionMap listenerOptions, OptionMap socketOptions) {
        super(name, serverName, listenerOptions, socketOptions, false, false);
    }

    @Override
    protected void startListening(XnioWorker worker, InetSocketAddress socketAddress, ChannelListener<AcceptingChannel<StreamConnection>> acceptListener) throws IOException {
        SSLContext sslContext = ((SecurityRealm)this.securityRealm.getValue()).getSSLContext();
        OptionMap.Builder builder = OptionMap.builder().addAll(commonOptions);
        builder.addAll(this.socketOptions);
        builder.set(Options.USE_DIRECT_BUFFERS, true);
        OptionMap combined = builder.getMap();
        JsseXnioSsl xnioSsl = new JsseXnioSsl(worker.getXnio(), combined, sslContext);
        this.sslServer = xnioSsl.createSslConnectionServer(worker, socketAddress, acceptListener, combined);
        this.sslServer.resumeAccepts();
        UndertowLogger.ROOT_LOGGER.listenerStarted("HTTPS", this.getName(), socketAddress);
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    @Override
    protected void stopListening() {
        this.sslServer.suspendAccepts();
        UndertowLogger.ROOT_LOGGER.listenerSuspend("HTTPS", this.getName());
        IoUtils.safeClose(this.sslServer);
        this.sslServer = null;
        UndertowLogger.ROOT_LOGGER.listenerStopped("HTTPS", this.getName(), ((SocketBinding)this.getBinding().getValue()).getSocketAddress());
        ((ListenerRegistry)this.httpListenerRegistry.getValue()).removeListener(this.getName());
    }

    public InjectedValue<SecurityRealm> getSecurityRealm() {
        return this.securityRealm;
    }

    @Override
    protected String getProtocol() {
        return PROTOCOL;
    }
}

