/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.deployment;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.cxf.service.Service;
import org.jboss.ws.common.configuration.ConfigHelper;
import org.jboss.wsf.spi.metadata.config.CommonConfig;
import org.jboss.wsf.stack.cxf.Loggers;
import org.jboss.wsf.stack.cxf.deployment.WSDLFilePublisher;

public class EndpointImpl
extends org.apache.cxf.jaxws22.EndpointImpl {
    private WSDLFilePublisher wsdlPublisher;
    private CommonConfig config;

    public EndpointImpl(Object implementor) {
        super(implementor);
    }

    public EndpointImpl(Bus bus, Object implementor) {
        super(bus, implementor);
    }

    protected void doPublish(String addr) {
        super.getServerFactory().setBlockPostConstruct(true);
        super.doPublish(addr);
        this.configureObject((Object)this);
        this.setupConfigHandlers();
        this.publishContractToFilesystem();
    }

    public void setEndpointConfig(CommonConfig config) {
        if (this.config == null) {
            this.config = config;
            Map epConfProps = config.getProperties();
            if (!epConfProps.isEmpty()) {
                if (this.getProperties() == null) {
                    this.setProperties(new HashMap(epConfProps));
                } else {
                    this.getProperties().putAll(epConfProps);
                }
            }
        }
    }

    protected void setupConfigHandlers() {
        if (this.config != null) {
            ConfigHelper helper = new ConfigHelper();
            helper.setupConfigHandlers(this.getBinding(), this.config);
        }
    }

    protected void publishContractToFilesystem() {
        if (this.wsdlPublisher != null) {
            Endpoint endpoint = this.getServer().getEndpoint();
            Service service = endpoint.getService();
            try {
                String wsdlLocation = this.getWsdlLocation();
                if (wsdlLocation == null) {
                    JaxWsImplementorInfo info = new JaxWsImplementorInfo(this.getImplementorClass());
                    wsdlLocation = info.getWsdlLocation();
                }
                this.wsdlPublisher.publishWsdlFiles(service.getName(), wsdlLocation, this.getBus(), service.getServiceInfos());
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        } else {
            Loggers.DEPLOYMENT_LOGGER.unableToPublishContractDueToMissingPublisher(this.getImplementorClass());
        }
    }

    private void configureObject(Object instance) {
        Configurer configurer = (Configurer)this.getBus().getExtension(Configurer.class);
        if (null != configurer) {
            configurer.configureBean(instance);
        }
    }

    public String getBeanName() {
        QName endpointName = this.getEndpointName();
        if (endpointName == null) {
            JaxWsImplementorInfo implInfo = new JaxWsImplementorInfo(this.getImplementorClass());
            endpointName = implInfo.getEndpointName();
        }
        return endpointName.toString() + ".jaxws-endpoint";
    }

    public WSDLFilePublisher getWsdlPublisher() {
        return this.wsdlPublisher;
    }

    public void setWsdlPublisher(WSDLFilePublisher wsdlPublisher) {
        this.wsdlPublisher = wsdlPublisher;
    }
}

