/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.ldap.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.Binding;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.picketlink.common.util.LDAPUtil;
import org.picketlink.idm.IDMInternalLog;
import org.picketlink.idm.IDMInternalMessages;
import org.picketlink.idm.IDMLog;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.config.LDAPIdentityStoreConfiguration;
import org.picketlink.idm.config.LDAPMappingConfiguration;

public class LDAPOperationManager {
    private final LDAPIdentityStoreConfiguration config;
    private final Map<String, Object> connectionProperties;

    public LDAPOperationManager(LDAPIdentityStoreConfiguration config) throws NamingException {
        this.config = config;
        this.connectionProperties = Collections.unmodifiableMap(this.createConnectionProperties());
    }

    public void modifyAttribute(String dn, Attribute attribute) {
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, attribute)};
        this.modifyAttributes(dn, mods);
    }

    public void removeAttribute(String dn, Attribute attribute) {
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(3, attribute)};
        this.modifyAttributes(dn, mods);
    }

    public void addAttribute(String dn, Attribute attribute) {
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(1, attribute)};
        this.modifyAttributes(dn, mods);
    }

    public void removeEntryById(final String baseDN, String id) {
        try {
            final BasicAttributes attributesToSearch = new BasicAttributes(true);
            attributesToSearch.put(new BasicAttribute(this.getUniqueIdentifierAttributeName(), id));
            this.execute(new LdapOperation<Void>(){

                @Override
                public Void execute(LdapContext context) throws NamingException {
                    NamingEnumeration<SearchResult> result = context.search(baseDN, attributesToSearch);
                    if (result.hasMore()) {
                        SearchResult sr = result.next();
                        LDAPOperationManager.this.destroySubcontext(context, sr.getNameInNamespace());
                    }
                    result.close();
                    return null;
                }
            });
        }
        catch (NamingException e) {
            IDMInternalLog.LDAP_STORE_LOGGER.errorf(e, "Could not remove entry from DN [%s] and id [%s]", baseDN, id);
            throw new RuntimeException(e);
        }
    }

    public List<SearchResult> search(final String baseDN, final String filter, LDAPMappingConfiguration mappingConfiguration) throws NamingException {
        final ArrayList result = new ArrayList();
        final SearchControls cons = new SearchControls();
        cons.setSearchScope(2);
        cons.setReturningObjFlag(false);
        List<String> returningAttributes = this.getReturningAttributes(mappingConfiguration);
        cons.setReturningAttributes(returningAttributes.toArray(new String[returningAttributes.size()]));
        try {
            return this.execute(new LdapOperation<List<SearchResult>>(){

                @Override
                public List<SearchResult> execute(LdapContext context) throws NamingException {
                    NamingEnumeration<SearchResult> search = context.search(baseDN, filter, cons);
                    while (search.hasMoreElements()) {
                        result.add(search.nextElement());
                    }
                    search.close();
                    return result;
                }
            });
        }
        catch (NamingException e) {
            IDMInternalLog.LDAP_STORE_LOGGER.errorf(e, "Could not query server using DN [%s] and filter [%s]", baseDN, filter);
            throw e;
        }
    }

    public String getFilterById(String baseDN, String id) {
        String filter = null;
        if (this.config.isActiveDirectory()) {
            final String strObjectGUID = "<GUID=" + id + ">";
            try {
                Attributes attributes = this.execute(new LdapOperation<Attributes>(){

                    @Override
                    public Attributes execute(LdapContext context) throws NamingException {
                        return context.getAttributes(strObjectGUID);
                    }
                });
                byte[] objectGUID = (byte[])attributes.get("objectGUID").get();
                filter = "(&(objectClass=*)(" + this.getUniqueIdentifierAttributeName() + "=" + LDAPUtil.convertObjectGUIToByteString((byte[])objectGUID) + "))";
            }
            catch (NamingException ne) {
                return filter;
            }
        }
        if (filter == null) {
            filter = "(&(objectClass=*)(" + this.getUniqueIdentifierAttributeName() + "=" + id + "))";
        }
        return filter;
    }

    public SearchResult lookupById(final String baseDN, String id, LDAPMappingConfiguration mappingConfiguration) {
        final String filter = this.getFilterById(baseDN, id);
        if (filter != null) {
            try {
                final SearchControls cons = new SearchControls();
                cons.setSearchScope(2);
                cons.setReturningObjFlag(false);
                cons.setCountLimit(1L);
                List<String> returningAttributes = this.getReturningAttributes(mappingConfiguration);
                cons.setReturningAttributes(returningAttributes.toArray(new String[returningAttributes.size()]));
                return this.execute(new LdapOperation<SearchResult>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public SearchResult execute(LdapContext context) throws NamingException {
                        NamingEnumeration<SearchResult> search = context.search(baseDN, filter, cons);
                        try {
                            if (search.hasMoreElements()) {
                                SearchResult searchResult = search.next();
                                return searchResult;
                            }
                        }
                        finally {
                            if (search != null) {
                                search.close();
                            }
                        }
                        return null;
                    }
                });
            }
            catch (NamingException e) {
                IDMInternalLog.LDAP_STORE_LOGGER.errorf(e, "Could not query server using DN [%s] and filter [%s]", baseDN, filter);
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroySubcontext(LdapContext context, String dn) {
        try {
            NamingEnumeration<Binding> enumeration = null;
            try {
                enumeration = context.listBindings(dn);
                while (enumeration.hasMore()) {
                    Binding binding = enumeration.next();
                    String name = binding.getNameInNamespace();
                    this.destroySubcontext(context, name);
                }
                context.unbind(dn);
            }
            finally {
                try {
                    enumeration.close();
                }
                catch (Exception e) {}
            }
        }
        catch (Exception e) {
            IDMInternalLog.LDAP_STORE_LOGGER.errorf(e, "Could not unbind DN [%s]", dn);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticate(String dn, String password) {
        InitialContext authCtx = null;
        try {
            Hashtable<String, Object> env = new Hashtable<String, Object>(this.connectionProperties);
            env.put("java.naming.security.principal", dn);
            env.put("java.naming.security.credentials", password);
            env.put("com.sun.jndi.ldap.connect.pool", "false");
            authCtx = new InitialLdapContext(env, null);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (IDMInternalLog.LDAP_STORE_LOGGER.isDebugEnabled()) {
                IDMInternalLog.LDAP_STORE_LOGGER.debugf(e, "Authentication failed for DN [%s]", dn);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (authCtx != null) {
                try {
                    authCtx.close();
                }
                catch (NamingException e) {}
            }
        }
    }

    private void modifyAttributes(final String dn, final ModificationItem[] mods) {
        try {
            if (IDMInternalLog.LDAP_STORE_LOGGER.isDebugEnabled()) {
                IDMInternalLog.LDAP_STORE_LOGGER.debugf("Modifying attributes for entry [%s]: [", dn);
                for (ModificationItem item : mods) {
                    IDMInternalLog.LDAP_STORE_LOGGER.debugf("  Op [%s]: %s = %s", item.getModificationOp(), item.getAttribute().getID(), item.getAttribute().get());
                }
                IDMInternalLog.LDAP_STORE_LOGGER.debugf("]", new Object[0]);
            }
            this.execute(new LdapOperation<Void>(){

                @Override
                public Void execute(LdapContext context) throws NamingException {
                    context.modifyAttributes(dn, mods);
                    return null;
                }
            });
        }
        catch (NamingException e) {
            IDMInternalLog.LDAP_STORE_LOGGER.errorf(e, "Could not modify attribute for DN [%s].", dn);
            throw new IdentityManagementException("Could not modify attribute for DN [" + dn + "]", (Throwable)e);
        }
    }

    public void createSubContext(final String name, final Attributes attributes) {
        try {
            if (IDMInternalLog.LDAP_STORE_LOGGER.isDebugEnabled()) {
                IDMInternalLog.LDAP_STORE_LOGGER.debugf("Creating entry [%s] with attributes: [", name);
                NamingEnumeration<? extends Attribute> all = attributes.getAll();
                while (all.hasMore()) {
                    Attribute attribute = all.next();
                    IDMInternalLog.LDAP_STORE_LOGGER.debugf("  %s = %s", attribute.getID(), attribute.get());
                }
                IDMInternalLog.LDAP_STORE_LOGGER.debugf("]", new Object[0]);
            }
            this.execute(new LdapOperation<Void>(){

                @Override
                public Void execute(LdapContext context) throws NamingException {
                    DirContext subcontext = context.createSubcontext(name, attributes);
                    subcontext.close();
                    return null;
                }
            });
        }
        catch (NamingException e) {
            IDMInternalLog.LDAP_STORE_LOGGER.errorf(e, "Could not create entry [%s].", name);
            throw new IdentityManagementException("Error creating subcontext [" + name + "]", (Throwable)e);
        }
    }

    private String getUniqueIdentifierAttributeName() {
        return this.config.getUniqueIdentifierAttributeName();
    }

    private NamingEnumeration<SearchResult> createEmptyEnumeration() {
        return new NamingEnumeration<SearchResult>(){

            @Override
            public SearchResult next() throws NamingException {
                return null;
            }

            @Override
            public boolean hasMore() throws NamingException {
                return false;
            }

            @Override
            public void close() throws NamingException {
            }

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            @Override
            public SearchResult nextElement() {
                return null;
            }
        };
    }

    public Attributes getAttributes(String entryUUID, String baseDN, LDAPMappingConfiguration mappingConfiguration) {
        SearchResult search = this.lookupById(baseDN, entryUUID, mappingConfiguration);
        if (search == null) {
            throw IDMInternalMessages.MESSAGES.storeLdapEntryNotFoundWithId(entryUUID, baseDN);
        }
        return search.getAttributes();
    }

    public String decodeEntryUUID(Object entryUUID) {
        String id = this.config.isActiveDirectory() ? LDAPUtil.decodeObjectGUID((byte[])((byte[])entryUUID)) : entryUUID.toString();
        return id;
    }

    private LdapContext createLdapContext() throws NamingException {
        return new InitialLdapContext(new Hashtable<String, Object>(this.connectionProperties), null);
    }

    private Map<String, Object> createConnectionProperties() {
        String url;
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("java.naming.factory.initial", this.config.getFactoryName());
        env.put("java.naming.security.authentication", this.config.getAuthType());
        String protocol = this.config.getProtocol();
        if (protocol != null) {
            env.put("java.naming.security.protocol", protocol);
        }
        String bindDN = this.config.getBindDN();
        char[] bindCredential = null;
        if (this.config.getBindCredential() != null) {
            bindCredential = this.config.getBindCredential().toCharArray();
        }
        if (bindDN != null) {
            env.put("java.naming.security.principal", bindDN);
            env.put("java.naming.security.credentials", bindCredential);
        }
        if ((url = this.config.getLdapURL()) == null) {
            throw new RuntimeException("url");
        }
        env.put("java.naming.provider.url", url);
        Properties additionalProperties = this.config.getConnectionProperties();
        if (additionalProperties != null) {
            for (Object key : additionalProperties.keySet()) {
                env.put(key.toString(), additionalProperties.getProperty(key.toString()));
            }
        }
        if (this.config.isActiveDirectory()) {
            env.put("java.naming.ldap.attributes.binary", "objectGUID");
        }
        if (IDMInternalLog.LDAP_STORE_LOGGER.isDebugEnabled()) {
            IDMInternalLog.LDAP_STORE_LOGGER.debugf("Creating LdapContext using properties: [%s]", env);
        }
        return env;
    }

    private <R> R execute(LdapOperation<R> operation) throws NamingException {
        LdapContext context = null;
        try {
            context = this.createLdapContext();
            R r = operation.execute(context);
            return r;
        }
        catch (NamingException ne) {
            IDMLog.IDENTITY_STORE_LOGGER.error((Object)"Could not create Ldap context.", (Throwable)ne);
            throw ne;
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException ne) {
                    IDMLog.IDENTITY_STORE_LOGGER.error((Object)"Could not close Ldap context.", (Throwable)ne);
                }
            }
        }
    }

    private List<String> getReturningAttributes(LDAPMappingConfiguration mappingConfiguration) {
        ArrayList<String> returningAttributes = new ArrayList<String>();
        if (mappingConfiguration != null) {
            returningAttributes.addAll(mappingConfiguration.getMappedProperties().values());
            returningAttributes.add(mappingConfiguration.getParentMembershipAttributeName());
            for (LDAPMappingConfiguration relationshipConfig : this.config.getRelationshipConfigs()) {
                if (!relationshipConfig.getRelatedAttributedType().equals(mappingConfiguration.getMappedClass())) continue;
                returningAttributes.addAll(relationshipConfig.getMappedProperties().values());
            }
        } else {
            returningAttributes.add("*");
        }
        returningAttributes.add(this.getUniqueIdentifierAttributeName());
        returningAttributes.add("createTimeStamp");
        returningAttributes.add("objectclass");
        return returningAttributes;
    }

    private static interface LdapOperation<R> {
        public R execute(LdapContext var1) throws NamingException;
    }
}

