/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.deployment;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.CompositeOperationAwareTransformer;
import org.jboss.as.controller.operations.OperationAttachments;
import org.jboss.as.domain.controller.DomainControllerMessages;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.repository.ContentRepository;
import org.jboss.dmr.ModelNode;

class DeploymentUploadUtil {
    private DeploymentUploadUtil() {
    }

    public static byte[] storeContentAndTransformOperation(OperationContext context, ModelNode operation, ContentRepository contentRepository) throws IOException, OperationFailedException {
        if (!operation.hasDefined("content")) {
            throw DeploymentUploadUtil.createFailureException(DomainControllerMessages.MESSAGES.invalidContentDeclaration());
        }
        ModelNode content = operation.get("content").get(0);
        if (content.hasDefined("hash")) {
            throw DeploymentUploadUtil.createFailureException(DomainControllerMessages.MESSAGES.invalidContentDeclaration());
        }
        byte[] hash = DeploymentUploadUtil.storeDeploymentContent(context, operation, contentRepository);
        ModelNode slave = operation.clone();
        slave.get("content").setEmptyList().add().get("hash").set(hash);
        ArrayList<CompositeOperationAwareTransformer> transformers = (ArrayList<CompositeOperationAwareTransformer>)context.getAttachment(OperationAttachments.SLAVE_SERVER_OPERATION_TRANSFORMERS);
        if (transformers == null) {
            transformers = new ArrayList<CompositeOperationAwareTransformer>();
            context.attach(OperationAttachments.SLAVE_SERVER_OPERATION_TRANSFORMERS, transformers);
        }
        transformers.add(new CompositeOperationAwareTransformer(slave));
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] storeDeploymentContent(OperationContext context, ModelNode operation, ContentRepository contentRepository) throws IOException, OperationFailedException {
        InputStream in = DeploymentUploadUtil.getContents(context, operation);
        try {
            byte[] byArray = contentRepository.addContent(in);
            return byArray;
        }
        finally {
            StreamUtils.safeClose((Closeable)in);
        }
    }

    private static InputStream getContents(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (!operation.hasDefined("content")) {
            throw DeploymentUploadUtil.createFailureException(DomainControllerMessages.MESSAGES.invalidContentDeclaration());
        }
        return DeploymentUploadUtil.getInputStream(context, operation.require("content").get(0));
    }

    private static InputStream getInputStream(OperationContext context, ModelNode content) throws OperationFailedException {
        InputStream in = null;
        String message = "";
        if (content.hasDefined("input-stream-index")) {
            int streamIndex = content.get("input-stream-index").asInt();
            if (streamIndex > context.getAttachmentStreamCount() - 1) {
                message = DomainControllerMessages.MESSAGES.invalidValue("input-stream-index", streamIndex, context.getAttachmentStreamCount() - 1);
                throw DeploymentUploadUtil.createFailureException(message);
            }
            message = DomainControllerMessages.MESSAGES.nullStream(streamIndex);
            in = context.getAttachmentStream(streamIndex);
        } else if (content.hasDefined("bytes")) {
            in = new ByteArrayInputStream(content.get("bytes").asBytes());
            message = DomainControllerMessages.MESSAGES.invalidByteStream();
        } else if (content.hasDefined("url")) {
            String urlSpec = content.get("url").asString();
            try {
                message = DomainControllerMessages.MESSAGES.invalidUrlStream();
                in = new URL(urlSpec).openStream();
            }
            catch (MalformedURLException e) {
                throw DeploymentUploadUtil.createFailureException(message);
            }
            catch (IOException e) {
                throw DeploymentUploadUtil.createFailureException(message);
            }
        }
        if (in == null) {
            throw DeploymentUploadUtil.createFailureException(message);
        }
        return in;
    }

    private static OperationFailedException createFailureException(String msg) {
        return new OperationFailedException(new ModelNode().set(msg));
    }
}

