/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

final class ArraySetUpdater<C, E> {
    private final AtomicReferenceFieldUpdater<C, E[]> fieldUpdater;
    private final E[] empty;

    ArraySetUpdater(AtomicReferenceFieldUpdater<C, E[]> fieldUpdater, Class<E> elementType) {
        this.fieldUpdater = fieldUpdater;
        this.empty = (Object[])Array.newInstance(elementType, 0);
    }

    public static <C, E> ArraySetUpdater<C, E> create(AtomicReferenceFieldUpdater<C, E[]> fieldUpdater, Class<E> elementType) {
        return new ArraySetUpdater<C, E>(fieldUpdater, elementType);
    }

    private static <E> E[] grow(E[] orig, E newItem) {
        int origLen = orig.length;
        E[] copy = Arrays.copyOf(orig, origLen + 1);
        copy[origLen] = newItem;
        return copy;
    }

    private E[] remove(E[] orig, int idx) {
        int len = orig.length;
        if (len == 1) {
            return this.empty;
        }
        if (idx == len - 1) {
            return Arrays.copyOf(orig, idx);
        }
        E[] copy = Arrays.copyOf(this.empty, idx);
        if (idx > 0) {
            System.arraycopy(orig, 0, copy, 0, idx);
        }
        if (idx < len - 1) {
            System.arraycopy(orig, idx + 1, copy, idx, len - 1 - idx);
        }
        return copy;
    }

    public boolean add(C instance, E newElement) {
        E[] old;
        do {
            for (E item : old = this.fieldUpdater.get(instance)) {
                if (item != newElement) continue;
                return false;
            }
        } while (!this.fieldUpdater.compareAndSet(instance, old, ArraySetUpdater.grow(old, newElement)));
        return true;
    }

    public boolean addAndCheckNull(C instance, E newElement) {
        E[] old;
        do {
            if ((old = this.fieldUpdater.get(instance)) == null) {
                return true;
            }
            for (E item : old) {
                if (item != newElement) continue;
                return false;
            }
        } while (!this.fieldUpdater.compareAndSet(instance, old, ArraySetUpdater.grow(old, newElement)));
        return false;
    }

    public boolean remove(C instance, E oldElement) {
        E[] old = this.fieldUpdater.get(instance);
        if (old == null) {
            return false;
        }
        while (true) {
            for (int idx = 0; idx < old.length; ++idx) {
                if (old[idx] != oldElement) continue;
                if (!this.fieldUpdater.compareAndSet(instance, old, this.remove(old, idx))) continue;
                return true;
            }
            break;
        }
        return false;
    }

    public E[] getAndSet(C instance, E[] newValue) {
        return this.fieldUpdater.getAndSet(instance, newValue);
    }
}

