/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.pool;

import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import org.jboss.jca.core.api.connectionmanager.pool.PoolConfiguration;
import org.jboss.jca.core.connectionmanager.pool.AbstractPool;
import org.jboss.jca.core.connectionmanager.pool.api.PrefillPool;

public abstract class AbstractPrefillPool
extends AbstractPool
implements PrefillPool {
    private boolean shouldPrefill = false;

    protected AbstractPrefillPool(ManagedConnectionFactory mcf, PoolConfiguration pc, boolean noTxSeparatePools, boolean sharable) {
        super(mcf, pc, noTxSeparatePools, sharable);
        this.shouldPrefill = pc.isPrefill();
    }

    @Override
    public void prefill(Subject subject, ConnectionRequestInfo cri, boolean noTxnSeperatePool) {
        if (this.shouldPrefill) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Attempting to prefill pool: " + this.getName());
            }
            try {
                Object key = this.getKey(subject, cri, noTxnSeperatePool);
                this.getManagedConnectionPool(key, subject, cri);
            }
            catch (Throwable t) {
                this.log.error("Unable to prefill pool: " + this.getName(), t);
            }
        }
    }

    @Override
    protected boolean isPrefill() {
        return this.getPoolConfiguration().getMinSize() > 0;
    }
}

