/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.tracer;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.jboss.jca.core.tracer.TraceEvent;
import org.jboss.logging.Logger;

public class Tracer {
    private static Logger log = Logger.getLogger(Tracer.class);
    private static boolean enabled = log.isTraceEnabled();

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean v) {
        enabled = v;
    }

    public static void getConnectionListener(String poolName, Object cl, boolean pooled, boolean interleaving) {
        if (!interleaving) {
            if (pooled) {
                log.tracef("%s", (Object)new TraceEvent(poolName, 0, Integer.toHexString(System.identityHashCode(cl))));
            } else {
                log.tracef("%s", (Object)new TraceEvent(poolName, 1, Integer.toHexString(System.identityHashCode(cl))));
            }
        } else if (pooled) {
            log.tracef("%s", (Object)new TraceEvent(poolName, 2, Integer.toHexString(System.identityHashCode(cl))));
        } else {
            log.tracef("%s", (Object)new TraceEvent(poolName, 3, Integer.toHexString(System.identityHashCode(cl))));
        }
    }

    public static void returnConnectionListener(String poolName, Object cl, boolean kill, boolean interleaving) {
        if (!interleaving) {
            if (!kill) {
                log.tracef("%s", (Object)new TraceEvent(poolName, 10, Integer.toHexString(System.identityHashCode(cl))));
            } else {
                log.tracef("%s", (Object)new TraceEvent(poolName, 11, Integer.toHexString(System.identityHashCode(cl))));
            }
        } else if (!kill) {
            log.tracef("%s", (Object)new TraceEvent(poolName, 12, Integer.toHexString(System.identityHashCode(cl))));
        } else {
            log.tracef("%s", (Object)new TraceEvent(poolName, 13, Integer.toHexString(System.identityHashCode(cl))));
        }
    }

    public static void clearConnectionListener(String poolName, Object cl) {
        log.tracef("%s", (Object)new TraceEvent(poolName, 14, Integer.toHexString(System.identityHashCode(cl))));
    }

    public static void enlistConnectionListener(String poolName, Object cl, boolean success, boolean interleaving) {
        if (!interleaving) {
            if (success) {
                log.tracef("%s", (Object)new TraceEvent(poolName, 20, Integer.toHexString(System.identityHashCode(cl))));
            } else {
                log.tracef("%s", (Object)new TraceEvent(poolName, 21, Integer.toHexString(System.identityHashCode(cl))));
            }
        } else if (success) {
            log.tracef("%s", (Object)new TraceEvent(poolName, 22, Integer.toHexString(System.identityHashCode(cl))));
        } else {
            log.tracef("%s", (Object)new TraceEvent(poolName, 23, Integer.toHexString(System.identityHashCode(cl))));
        }
    }

    public static void delistConnectionListener(String poolName, Object cl, boolean success, boolean rollbacked, boolean interleaving) {
        if (!rollbacked) {
            if (!interleaving) {
                if (success) {
                    log.tracef("%s", (Object)new TraceEvent(poolName, 30, Integer.toHexString(System.identityHashCode(cl))));
                } else {
                    log.tracef("%s", (Object)new TraceEvent(poolName, 31, Integer.toHexString(System.identityHashCode(cl))));
                }
            } else if (success) {
                log.tracef("%s", (Object)new TraceEvent(poolName, 32, Integer.toHexString(System.identityHashCode(cl))));
            } else {
                log.tracef("%s", (Object)new TraceEvent(poolName, 33, Integer.toHexString(System.identityHashCode(cl))));
            }
        } else {
            log.tracef("%s", (Object)new TraceEvent(poolName, 34, Integer.toHexString(System.identityHashCode(cl))));
        }
    }

    public static void getConnection(String poolName, Object cl, Object connection) {
        log.tracef("%s", (Object)new TraceEvent(poolName, 40, Integer.toHexString(System.identityHashCode(cl)), Integer.toHexString(System.identityHashCode(connection))));
    }

    public static void returnConnection(String poolName, Object cl, Object connection) {
        log.tracef("%s", (Object)new TraceEvent(poolName, 41, Integer.toHexString(System.identityHashCode(cl)), Integer.toHexString(System.identityHashCode(connection))));
    }

    public static void clearConnection(String poolName, Object cl, Object connection) {
        log.tracef("%s", (Object)new TraceEvent(poolName, 42, Integer.toHexString(System.identityHashCode(cl)), Integer.toHexString(System.identityHashCode(connection))));
    }

    public static void exception(String poolName, Object cl, Throwable exception) {
        CharArrayWriter caw = new CharArrayWriter();
        PrintWriter pw = new PrintWriter((Writer)caw, true);
        exception.printStackTrace(pw);
        pw.flush();
        char[] data = caw.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            char c = data[i];
            sb = c == '\n' ? sb.append('|') : (c == '\r' ? sb.append('/') : (c == '\t' ? sb.append('\\') : (c == ' ' ? sb.append('_') : sb.append(c))));
        }
        log.tracef("%s", (Object)new TraceEvent(poolName, 50, Integer.toHexString(System.identityHashCode(cl)), sb.toString()));
    }
}

