/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.settings.impl;

import java.util.regex.Pattern;
import org.hornetq.core.server.HornetQMessageBundle;

public class Match<T> {
    public static final String WORD_WILDCARD = "*";
    private static final String WORD_WILDCARD_REPLACEMENT = "[^.]+";
    public static final String WILDCARD = "#";
    private static final String WILDCARD_REPLACEMENT = ".+";
    private static final String DOT = ".";
    private static final String DOT_REPLACEMENT = "\\.";
    private String match;
    private final Pattern pattern;
    private T value;

    public Match(String match) {
        this.match = match;
        String actMatch = match;
        if (WILDCARD.equals(match)) {
            actMatch = WILDCARD_REPLACEMENT;
        } else {
            actMatch = actMatch.replace(DOT, DOT_REPLACEMENT);
            actMatch = actMatch.replace(WILDCARD, WILDCARD_REPLACEMENT);
            actMatch = actMatch.replace(WORD_WILDCARD, WORD_WILDCARD_REPLACEMENT);
        }
        this.pattern = Pattern.compile(actMatch);
    }

    public String getMatch() {
        return this.match;
    }

    public void setMatch(String match) {
        this.match = match;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Match that = (Match)o;
        return !(this.match == null ? that.match != null : !this.match.equals(that.match));
    }

    public int hashCode() {
        return this.match != null ? this.match.hashCode() : 0;
    }

    public static void verify(String match) throws IllegalArgumentException {
        if (match == null) {
            throw HornetQMessageBundle.BUNDLE.nullMatch();
        }
        if (match.contains(WILDCARD) && match.indexOf(WILDCARD) < match.length() - 1) {
            throw HornetQMessageBundle.BUNDLE.invalidMatch();
        }
    }
}

