/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.massindex;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.util.concurrent.Futures;
import org.infinispan.commons.util.concurrent.NotifyingFuture;
import org.infinispan.distexec.DefaultExecutorService;
import org.infinispan.distexec.DistributedExecutorService;
import org.infinispan.distexec.DistributedTask;
import org.infinispan.query.MassIndexer;
import org.infinispan.query.impl.massindex.IndexUpdater;
import org.infinispan.query.impl.massindex.IndexWorker;
import org.infinispan.query.indexmanager.InfinispanIndexManager;
import org.infinispan.query.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DistributedExecutorMassIndexer
implements MassIndexer {
    private static final Log LOG = (Log)LogFactory.getLog(DistributedExecutorMassIndexer.class, Log.class);
    private final AdvancedCache cache;
    private final SearchIntegrator searchIntegrator;
    private final IndexUpdater indexUpdater;
    private final DistributedExecutorService executor;

    public DistributedExecutorMassIndexer(AdvancedCache cache, SearchIntegrator searchIntegrator) {
        this.cache = cache;
        this.searchIntegrator = searchIntegrator;
        this.indexUpdater = new IndexUpdater((Cache<?, ?>)cache);
        this.executor = new DefaultExecutorService((Cache)cache);
    }

    @Override
    public void start() {
        ExecutionResult<Void> executionResult = this.executeInternal();
        ((ExecutionResult)executionResult).waitForAll();
        executionResult.flushIfNeed();
    }

    @Override
    public NotifyingFuture<Void> startAsync() {
        final ExecutionResult<Void> executionResult = this.executeInternal();
        NotifyingFuture combined = Futures.combine(executionResult.futures);
        return Futures.andThen((NotifyingFuture)combined, (Runnable)new Runnable(){

            @Override
            public void run() {
                executionResult.flushIfNeed();
            }
        }, (ExecutorService)Executors.newSingleThreadExecutor());
    }

    private ExecutionResult<Void> executeInternal() {
        ArrayList futures = new ArrayList();
        LinkedList toFlush = new LinkedList();
        boolean replicated = this.cache.getAdvancedCache().getCacheConfiguration().clustering().cacheMode().isReplicated();
        for (Class indexedType : this.searchIntegrator.getIndexedTypes()) {
            IndexWorker indexWork;
            boolean sharded;
            EntityIndexBinding indexBinding = this.searchIntegrator.getIndexBinding(indexedType);
            IndexManager[] indexManagers = indexBinding.getIndexManagers();
            boolean shared = this.isShared(indexManagers[0]);
            boolean bl = sharded = indexManagers.length > 1;
            if (shared && !sharded) {
                this.indexUpdater.purge(indexedType);
                indexWork = new IndexWorker(indexedType, false);
                toFlush.add(indexedType);
            } else {
                indexWork = new IndexWorker(indexedType, true);
            }
            DistributedTask task = this.executor.createDistributedTaskBuilder((Callable)((Object)indexWork)).timeout(0L, TimeUnit.NANOSECONDS).build();
            if (replicated && shared && !sharded) {
                futures.add(this.executor.submit(task, new Object[0]));
                continue;
            }
            futures.addAll(this.executor.submitEverywhere(task));
        }
        return new ExecutionResult<Void>(futures, toFlush);
    }

    private boolean isShared(IndexManager indexManager) {
        return indexManager instanceof InfinispanIndexManager;
    }

    private class ExecutionResult<T> {
        final List<NotifyingFuture<T>> futures;
        final Queue<Class<?>> toFlush;

        public ExecutionResult(List<NotifyingFuture<T>> futures, Queue<Class<?>> toFlush) {
            this.futures = futures;
            this.toFlush = toFlush;
        }

        void flushIfNeed() {
            for (Class clazz : this.toFlush) {
                DistributedExecutorMassIndexer.this.indexUpdater.flush(clazz);
            }
        }

        private void waitForAll() {
            for (Future future : this.futures) {
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    LOG.errorExecutingMassIndexer(e);
                }
            }
        }
    }
}

