/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.ServiceLoader;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.management.MBeanServer;
import org.infinispan.commons.executors.ThreadPoolExecutorFactory;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.ShutdownHookBehavior;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.remoting.transport.Transport;
import org.jboss.as.clustering.infinispan.ChannelTransport;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.MBeanServerProvider;
import org.jboss.as.clustering.infinispan.ManagedExecutorFactory;
import org.jboss.as.clustering.infinispan.ManagedScheduledExecutorFactory;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.TransportConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.TransportConfigurationBuilder;
import org.jboss.as.jmx.MBeanServerService;
import org.jboss.as.server.Services;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.infinispan.spi.io.SimpleExternalizer;
import org.wildfly.clustering.infinispan.spi.service.CacheContainerServiceName;
import org.wildfly.clustering.jgroups.spi.ProtocolStackConfiguration;
import org.wildfly.clustering.jgroups.spi.RelayConfiguration;
import org.wildfly.clustering.jgroups.spi.TransportConfiguration;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.ValueDependency;

public class CacheContainerConfigurationBuilder
implements Builder<GlobalConfiguration>,
Value<GlobalConfiguration> {
    private final InjectedValue<ModuleLoader> loader = new InjectedValue();
    private final InjectedValue<MBeanServer> server = new InjectedValue();
    private final String name;
    private boolean statisticsEnabled;
    private ModuleIdentifier module;
    private ValueDependency<TransportConfiguration> transport = null;
    private ValueDependency<Executor> listenerExecutor = null;
    private ValueDependency<ScheduledExecutorService> evictionExecutor = null;
    private ValueDependency<ScheduledExecutorService> replicationQueueExecutor = null;

    public CacheContainerConfigurationBuilder(String name) {
        this.name = name;
    }

    public ServiceName getServiceName() {
        return CacheContainerServiceName.CONFIGURATION.getServiceName(this.name);
    }

    public ServiceBuilder<GlobalConfiguration> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName(), (Service)new ValueService((Value)this)).addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ModuleLoader.class, this.loader).addDependency(MBeanServerService.SERVICE_NAME, MBeanServer.class, this.server);
        if (this.transport != null) {
            this.transport.register(builder);
        }
        if (this.listenerExecutor != null) {
            this.listenerExecutor.register(builder);
        }
        if (this.evictionExecutor != null) {
            this.evictionExecutor.register(builder);
        }
        if (this.replicationQueueExecutor != null) {
            this.replicationQueueExecutor.register(builder);
        }
        return builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public GlobalConfiguration getValue() {
        ScheduledExecutorService replicationQueueExecutor;
        ScheduledExecutorService evictionExecutor;
        Executor listenerExecutor;
        TransportConfiguration transport;
        GlobalConfigurationBuilder builder = new GlobalConfigurationBuilder();
        ModuleLoader moduleLoader = (ModuleLoader)this.loader.getValue();
        builder.serialization().classResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)moduleLoader));
        try {
            ClassLoader loader = this.module != null ? moduleLoader.loadModule(this.module).getClassLoader() : CacheContainerConfiguration.class.getClassLoader();
            builder.classLoader(loader);
            int id = 255;
            for (SimpleExternalizer externalizer : ServiceLoader.load(SimpleExternalizer.class, loader)) {
                InfinispanLogger.ROOT_LOGGER.debugf("Cache container %s will use an externalizer for %s", this.name, externalizer.getTargetClass().getName());
                builder.serialization().addAdvancedExternalizer(id++, (AdvancedExternalizer)externalizer);
            }
        }
        catch (ModuleLoadException e) {
            throw new IllegalStateException(e);
        }
        builder.shutdown().hookBehavior(ShutdownHookBehavior.DONT_REGISTER);
        TransportConfiguration transportConfiguration = transport = this.transport != null ? (TransportConfiguration)this.transport.getValue() : null;
        if (transport != null) {
            RelayConfiguration relay;
            Executor executor;
            org.infinispan.configuration.global.TransportConfigurationBuilder transportBuilder = builder.transport().clusterName(this.name).transport((Transport)new ChannelTransport(transport.getChannel(), transport.getChannelFactory())).distributedSyncTimeout(transport.getLockTimeout());
            ProtocolStackConfiguration stack = transport.getChannelFactory().getProtocolStackConfiguration();
            TransportConfiguration.Topology topology = stack.getTransport().getTopology();
            if (topology != null) {
                transportBuilder.siteId(topology.getSite()).rackId(topology.getRack()).machineId(topology.getMachine());
            }
            if ((executor = transport.getExecutor()) != null) {
                transportBuilder.transportThreadPool().threadPoolFactory((ThreadPoolExecutorFactory)new ManagedExecutorFactory(executor));
            }
            if ((relay = stack.getRelay()) != null) {
                builder.site().localSite(relay.getSiteName());
            }
        }
        Executor executor = listenerExecutor = this.listenerExecutor != null ? (Executor)this.listenerExecutor.getValue() : null;
        if (listenerExecutor != null) {
            builder.listenerThreadPool().threadPoolFactory((ThreadPoolExecutorFactory)new ManagedExecutorFactory(listenerExecutor));
        }
        ScheduledExecutorService scheduledExecutorService = evictionExecutor = this.evictionExecutor != null ? (ScheduledExecutorService)this.evictionExecutor.getValue() : null;
        if (evictionExecutor != null) {
            builder.evictionThreadPool().threadPoolFactory((ThreadPoolExecutorFactory)new ManagedScheduledExecutorFactory(evictionExecutor));
        }
        ScheduledExecutorService scheduledExecutorService2 = replicationQueueExecutor = this.replicationQueueExecutor != null ? (ScheduledExecutorService)this.replicationQueueExecutor.getValue() : null;
        if (replicationQueueExecutor != null) {
            builder.replicationQueueThreadPool().threadPoolFactory((ThreadPoolExecutorFactory)new ManagedExecutorFactory(replicationQueueExecutor));
        }
        builder.globalJmxStatistics().enabled(this.statisticsEnabled).cacheManagerName(this.name).mBeanServerLookup((MBeanServerLookup)new MBeanServerProvider((MBeanServer)this.server.getValue())).jmxDomain(CacheContainerServiceName.CACHE_CONTAINER.getServiceName("default").getParent().getCanonicalName()).allowDuplicateDomains(Boolean.valueOf(true));
        return builder.build();
    }

    public CacheContainerConfigurationBuilder setModule(ModuleIdentifier module) {
        this.module = module;
        return this;
    }

    public CacheContainerConfigurationBuilder setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
        return this;
    }

    public TransportConfigurationBuilder setTransport() {
        TransportConfigurationBuilder builder = new TransportConfigurationBuilder(this.name);
        this.transport = new InjectedValueDependency((ServiceNameProvider)builder, TransportConfiguration.class);
        return builder;
    }

    public CacheContainerConfigurationBuilder setListenerExecutor(String executorName) {
        if (executorName != null) {
            this.listenerExecutor = new InjectedValueDependency(ThreadsServices.executorName((String)executorName), Executor.class);
        }
        return this;
    }

    public CacheContainerConfigurationBuilder setEvictionExecutor(String executorName) {
        if (executorName != null) {
            this.evictionExecutor = new InjectedValueDependency(ThreadsServices.executorName((String)executorName), ScheduledExecutorService.class);
        }
        return this;
    }

    public CacheContainerConfigurationBuilder setReplicationQueueExecutor(String executorName) {
        if (executorName != null) {
            this.replicationQueueExecutor = new InjectedValueDependency(ThreadsServices.executorName((String)executorName), ScheduledExecutorService.class);
        }
        return this;
    }
}

