/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.clustering.controller.Metric;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public enum CacheContainerMetric implements Metric<EmbeddedCacheManager>
{
    CACHE_MANAGER_STATUS("cache-manager-status", ModelType.STRING){

        public ModelNode getValue(EmbeddedCacheManager manager) {
            return new ModelNode(manager.getStatus().toString());
        }
    }
    ,
    CLUSTER_NAME("cluster-name", ModelType.STRING){

        public ModelNode getValue(EmbeddedCacheManager manager) {
            String clusterName = manager.getClusterName();
            return clusterName != null ? new ModelNode(clusterName) : null;
        }
    }
    ,
    COORDINATOR_ADDRESS("coordinator-address", ModelType.STRING){

        public ModelNode getValue(EmbeddedCacheManager manager) {
            Address address = manager.getCoordinator();
            return address != null ? new ModelNode(address.toString()) : null;
        }
    }
    ,
    IS_COORDINATOR("is-coordinator", ModelType.BOOLEAN){

        public ModelNode getValue(EmbeddedCacheManager manager) {
            return new ModelNode(manager.isCoordinator());
        }
    }
    ,
    LOCAL_ADDRESS("local-address", ModelType.STRING){

        public ModelNode getValue(EmbeddedCacheManager manager) {
            Address address = manager.getAddress();
            return address != null ? new ModelNode(address.toString()) : null;
        }
    };

    private final AttributeDefinition definition;
    private static final Map<String, CacheContainerMetric> metrics;

    private CacheContainerMetric(String name, ModelType type) {
        this.definition = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type, true).setStorageRuntime()).build();
    }

    public AttributeDefinition getDefinition() {
        return this.definition;
    }

    public static CacheContainerMetric forName(String name) {
        return metrics.get(name);
    }

    static {
        metrics = new HashMap<String, CacheContainerMetric>();
        for (CacheContainerMetric metric : CacheContainerMetric.values()) {
            metrics.put(metric.definition.getName(), metric);
        }
    }
}

