/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.eviction.ActivationManager;
import org.infinispan.eviction.PassivationManager;
import org.infinispan.interceptors.CacheMgmtInterceptor;
import org.infinispan.interceptors.InvalidationInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.jboss.as.clustering.controller.Metric;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public enum CacheMetric implements Metric<Cache<?, ?>>
{
    ACTIVATIONS("activations", ModelType.LONG){

        public ModelNode getValue(Cache<?, ?> cache) {
            ActivationManager manager = (ActivationManager)cache.getAdvancedCache().getComponentRegistry().getComponent(ActivationManager.class);
            return new ModelNode(manager != null ? manager.getActivationCount() : 0L);
        }
    }
    ,
    AVERAGE_READ_TIME("average-read-time", ModelType.LONG){

        public ModelNode getValue(Cache<?, ?> cache) {
            CacheMgmtInterceptor interceptor = 2.findInterceptor(cache, CacheMgmtInterceptor.class);
            return new ModelNode(interceptor != null ? interceptor.getAverageReadTime() : 0L);
        }
    }
    ,
    AVERAGE_WRITE_TIME("average-write-time", ModelType.LONG){

        public ModelNode getValue(Cache<?, ?> cache) {
            CacheMgmtInterceptor interceptor = 3.findInterceptor(cache, CacheMgmtInterceptor.class);
            return new ModelNode(interceptor != null ? interceptor.getAverageWriteTime() : 0L);
        }
    }
    ,
    CACHE_STATUS("cache-status", ModelType.STRING){

        public ModelNode getValue(Cache<?, ?> cache) {
            return new ModelNode(cache.getStatus().toString());
        }
    }
    ,
    ELAPSED_TIME("elapsed-time", ModelType.LONG){

        public ModelNode getValue(Cache<?, ?> cache) {
            CacheMgmtInterceptor interceptor = 5.findInterceptor(cache, CacheMgmtInterceptor.class);
            return new ModelNode(interceptor != null ? interceptor.getElapsedTime() : 0L);
        }
    }
    ,
    HIT_RATIO("hit-ratio", ModelType.DOUBLE){

        public ModelNode getValue(Cache<?, ?> cache) {
            CacheMgmtInterceptor interceptor = 6.findInterceptor(cache, CacheMgmtInterceptor.class);
            return new ModelNode(interceptor != null ? interceptor.getHitRatio() : 0.0);
        }
    }
    ,
    HITS("hits", ModelType.LONG){

        public ModelNode getValue(Cache<?, ?> cache) {
            CacheMgmtInterceptor interceptor = 7.findInterceptor(cache, CacheMgmtInterceptor.class);
            return new ModelNode(interceptor != null ? interceptor.getHits() : 0L);
        }
    }
    ,
    INVALIDATIONS("invalidations", ModelType.LONG){

        public ModelNode getValue(Cache<?, ?> cache) {
            InvalidationInterceptor interceptor = 8.findInterceptor(cache, InvalidationInterceptor.class);
            return new ModelNode(interceptor != null ? interceptor.getInvalidations() : 0L);
        }
    }
    ,
    MISSES("misses", ModelType.LONG){

        public ModelNode getValue(Cache<?, ?> cache) {
            CacheMgmtInterceptor interceptor = 9.findInterceptor(cache, CacheMgmtInterceptor.class);
            return new ModelNode(interceptor != null ? interceptor.getMisses() : 0L);
        }
    }
    ,
    NUMBER_OF_ENTRIES("number-of-entries", ModelType.INT){

        public ModelNode getValue(Cache<?, ?> cache) {
            CacheMgmtInterceptor interceptor = 10.findInterceptor(cache, CacheMgmtInterceptor.class);
            return new ModelNode(interceptor != null ? interceptor.getNumberOfEntries() : 0);
        }
    }
    ,
    PASSIVATIONS("passivations", ModelType.LONG){

        public ModelNode getValue(Cache<?, ?> cache) {
            PassivationManager manager = (PassivationManager)cache.getAdvancedCache().getComponentRegistry().getComponent(PassivationManager.class);
            return new ModelNode(manager != null ? manager.getPassivations() : 0L);
        }
    }
    ,
    READ_WRITE_RATIO("read-write-ratio", ModelType.DOUBLE){

        public ModelNode getValue(Cache<?, ?> cache) {
            CacheMgmtInterceptor interceptor = 12.findInterceptor(cache, CacheMgmtInterceptor.class);
            return new ModelNode(interceptor != null ? interceptor.getReadWriteRatio() : 0.0);
        }
    }
    ,
    REMOVE_HITS("remove-hits", ModelType.LONG){

        public ModelNode getValue(Cache<?, ?> cache) {
            CacheMgmtInterceptor interceptor = 13.findInterceptor(cache, CacheMgmtInterceptor.class);
            return new ModelNode(interceptor != null ? interceptor.getRemoveHits() : 0L);
        }
    }
    ,
    REMOVE_MISSES("remove-misses", ModelType.LONG){

        public ModelNode getValue(Cache<?, ?> cache) {
            CacheMgmtInterceptor interceptor = 14.findInterceptor(cache, CacheMgmtInterceptor.class);
            return new ModelNode(interceptor != null ? interceptor.getRemoveMisses() : 0L);
        }
    }
    ,
    STORES("stores", ModelType.LONG){

        public ModelNode getValue(Cache<?, ?> cache) {
            CacheMgmtInterceptor interceptor = 15.findInterceptor(cache, CacheMgmtInterceptor.class);
            return new ModelNode(interceptor != null ? interceptor.getStores() : 0L);
        }
    }
    ,
    TIME_SINCE_RESET("time-since-reset", ModelType.LONG){

        public ModelNode getValue(Cache<?, ?> cache) {
            CacheMgmtInterceptor interceptor = 16.findInterceptor(cache, CacheMgmtInterceptor.class);
            return new ModelNode(interceptor != null ? interceptor.getTimeSinceReset() : 0L);
        }
    };

    private final AttributeDefinition definition;
    private static final Map<String, CacheMetric> metrics;

    private CacheMetric(String name, ModelType type) {
        this.definition = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type, true).setStorageRuntime()).build();
    }

    public AttributeDefinition getDefinition() {
        return this.definition;
    }

    static <T extends CommandInterceptor> T findInterceptor(Cache<?, ?> cache, Class<T> interceptorClass) {
        for (CommandInterceptor interceptor : cache.getAdvancedCache().getInterceptorChain()) {
            if (!interceptorClass.isAssignableFrom(interceptor.getClass())) continue;
            return (T)((CommandInterceptor)interceptorClass.cast(interceptor));
        }
        return null;
    }

    public static CacheMetric forName(String name) {
        return metrics.get(name);
    }

    static {
        metrics = new HashMap<String, CacheMetric>();
        for (CacheMetric metric : CacheMetric.values()) {
            metrics.put(metric.definition.getName(), metric);
        }
    }
}

