/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.jboss.as.clustering.controller.Metric;
import org.jboss.as.clustering.controller.descriptions.SubsystemResourceDescriptionResolver;
import org.jboss.as.clustering.infinispan.subsystem.CacheMetric;
import org.jboss.as.clustering.infinispan.subsystem.CacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ClusteredCacheMetric;
import org.jboss.as.clustering.infinispan.subsystem.ClusteredCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.EvictionMetric;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.clustering.infinispan.subsystem.JDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.LockingMetric;
import org.jboss.as.clustering.infinispan.subsystem.StoreMetric;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.TransactionMetric;
import org.jboss.as.controller.AttributeDefinition;

public class InfinispanResourceDescriptionResolver
extends SubsystemResourceDescriptionResolver {
    private Map<String, String> sharedAttributeResolver = new HashMap<String, String>();

    InfinispanResourceDescriptionResolver() {
        this(Collections.emptyList());
    }

    InfinispanResourceDescriptionResolver(String keyPrefix) {
        this(Collections.singletonList(keyPrefix));
    }

    InfinispanResourceDescriptionResolver(String ... keyPrefixes) {
        this(Arrays.asList(keyPrefixes));
    }

    private InfinispanResourceDescriptionResolver(List<String> keyPrefixes) {
        super("infinispan", keyPrefixes, InfinispanExtension.class);
        this.initMap();
    }

    public String getResourceAttributeDescription(String attributeName, Locale locale, ResourceBundle bundle) {
        if (this.sharedAttributeResolver.containsKey(attributeName)) {
            return bundle.getString(this.getBundleKey(attributeName));
        }
        return super.getResourceAttributeDescription(attributeName, locale, bundle);
    }

    public String getResourceAttributeDeprecatedDescription(String attributeName, Locale locale, ResourceBundle bundle) {
        if (this.sharedAttributeResolver.containsKey(attributeName)) {
            return bundle.getString(this.getVariableBundleKey(attributeName, "deprecated"));
        }
        return super.getResourceAttributeDeprecatedDescription(attributeName, locale, bundle);
    }

    public String getResourceAttributeValueTypeDescription(String attributeName, Locale locale, ResourceBundle bundle, String ... suffixes) {
        if (this.sharedAttributeResolver.containsKey(attributeName)) {
            return bundle.getString(this.getVariableBundleKey(attributeName, suffixes));
        }
        return super.getResourceAttributeValueTypeDescription(attributeName, locale, bundle, suffixes);
    }

    public String getOperationParameterDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle) {
        if (this.sharedAttributeResolver.containsKey(paramName)) {
            return bundle.getString(this.getBundleKey(paramName));
        }
        return super.getOperationParameterDescription(operationName, paramName, locale, bundle);
    }

    public String getOperationParameterDeprecatedDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle) {
        if (this.sharedAttributeResolver.containsKey(paramName)) {
            return bundle.getString(this.getVariableBundleKey(paramName, "deprecated"));
        }
        return super.getOperationParameterDeprecatedDescription(operationName, paramName, locale, bundle);
    }

    public String getOperationParameterValueTypeDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle, String ... suffixes) {
        if (this.sharedAttributeResolver.containsKey(paramName)) {
            return bundle.getString(this.getVariableBundleKey(paramName, suffixes));
        }
        return super.getOperationParameterValueTypeDescription(operationName, paramName, locale, bundle, suffixes);
    }

    public String getChildTypeDescription(String childType, Locale locale, ResourceBundle bundle) {
        if (this.sharedAttributeResolver.containsKey(childType)) {
            return bundle.getString(this.getBundleKey(childType));
        }
        return super.getChildTypeDescription(childType, locale, bundle);
    }

    private String getBundleKey(String name) {
        return this.getVariableBundleKey(name, new String[0]);
    }

    private String getVariableBundleKey(String name, String ... variable) {
        String prefix = this.sharedAttributeResolver.get(name);
        StringBuilder sb = new StringBuilder("infinispan");
        if (prefix != null) {
            sb.append('.').append(prefix);
        }
        sb.append('.').append(name);
        if (variable != null) {
            for (String arg : variable) {
                sb.append('.').append(arg);
            }
        }
        return sb.toString();
    }

    private void initMap() {
        for (AttributeDefinition attribute : CacheResourceDefinition.ATTRIBUTES) {
            this.sharedAttributeResolver.put(attribute.getName(), "cache");
        }
        for (AttributeDefinition attribute : ClusteredCacheResourceDefinition.ATTRIBUTES) {
            this.sharedAttributeResolver.put(attribute.getName(), "clustered-cache");
        }
        for (AttributeDefinition attribute : StoreResourceDefinition.PARAMETERS) {
            this.sharedAttributeResolver.put(attribute.getName(), "store");
        }
        for (AttributeDefinition attribute : JDBCStoreResourceDefinition.ATTRIBUTES) {
            this.sharedAttributeResolver.put(attribute.getName(), "jdbc-store");
        }
        this.initMetric(CacheMetric.class, "cache");
        this.initMetric(ClusteredCacheMetric.class, "clustered-cache");
        this.initMetric(EvictionMetric.class, "eviction");
        this.initMetric(LockingMetric.class, "locking");
        this.initMetric(StoreMetric.class, "store");
        this.initMetric(TransactionMetric.class, "transaction");
        this.sharedAttributeResolver.put("transport", null);
        this.sharedAttributeResolver.put("locking", null);
        this.sharedAttributeResolver.put("transaction", null);
        this.sharedAttributeResolver.put("eviction", null);
        this.sharedAttributeResolver.put("expiration", null);
        this.sharedAttributeResolver.put("state-transfer", null);
        this.sharedAttributeResolver.put("store", null);
        this.sharedAttributeResolver.put("file-store", null);
        this.sharedAttributeResolver.put("remote-store", null);
        this.sharedAttributeResolver.put("string-keyed-jdbc-store", null);
        this.sharedAttributeResolver.put("binary-keyed-jdbc-store", null);
        this.sharedAttributeResolver.put("mixed-keyed-jdbc-store", null);
        this.sharedAttributeResolver.put("write-behind", null);
        this.sharedAttributeResolver.put("property", null);
        this.sharedAttributeResolver.put("backup-for", null);
    }

    private <E extends Enum<E>> void initMetric(Class<E> metricClass, String prefix) {
        for (Metric metric : EnumSet.allOf(metricClass)) {
            this.sharedAttributeResolver.put(metric.getDefinition().getName(), prefix);
        }
    }
}

