/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.ra;

import javax.jms.Message;
import javax.jms.MessageListener;
import org.hornetq.ra.HornetQRALogger;
import org.hornetq.ra.HornetQRAMessageConsumer;

public class HornetQRAMessageListener
implements MessageListener {
    private static boolean trace = HornetQRALogger.LOGGER.isTraceEnabled();
    private final MessageListener listener;
    private final HornetQRAMessageConsumer consumer;

    public HornetQRAMessageListener(MessageListener listener, HornetQRAMessageConsumer consumer) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("constructor(" + listener + ", " + consumer + ")");
        }
        this.listener = listener;
        this.consumer = consumer;
    }

    public void onMessage(Message message) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("onMessage(" + message + ")");
        }
        message = this.consumer.wrapMessage(message);
        this.listener.onMessage(message);
    }
}

