/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.repository;

import java.util.concurrent.atomic.AtomicLong;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.StepExecution;
import org.jberet.repository.AbstractRepository;
import org.jberet.runtime.JobExecutionImpl;
import org.jberet.runtime.JobInstanceImpl;
import org.jberet.runtime.StepExecutionImpl;

public final class InMemoryRepository
extends AbstractRepository {
    private final AtomicLong jobInstanceIdSequence = new AtomicLong();
    private final AtomicLong jobExecutionIdSequence = new AtomicLong();
    private final AtomicLong stepExecutionIdSequence = new AtomicLong();

    public static InMemoryRepository getInstance() {
        return Holder.instance;
    }

    public static InMemoryRepository create() {
        return new InMemoryRepository();
    }

    @Override
    void insertJobInstance(JobInstanceImpl jobInstance) {
        jobInstance.setId(this.jobInstanceIdSequence.incrementAndGet());
    }

    @Override
    void insertJobExecution(JobExecutionImpl jobExecution) {
        jobExecution.setId(this.jobExecutionIdSequence.incrementAndGet());
    }

    @Override
    void insertStepExecution(StepExecutionImpl stepExecution, JobExecutionImpl jobExecution) {
        stepExecution.setId(this.stepExecutionIdSequence.incrementAndGet());
    }

    @Override
    public void updateStepExecution(StepExecution stepExecution) {
    }

    @Override
    public int countStepStartTimes(String stepName, long jobInstanceId) {
        int count = 0;
        JobInstanceImpl jobInstanceImpl = (JobInstanceImpl)this.jobInstances.get(jobInstanceId);
        if (jobInstanceImpl != null) {
            for (JobExecution jobExecution : jobInstanceImpl.getJobExecutions()) {
                JobExecutionImpl jobExecutionImpl = (JobExecutionImpl)jobExecution;
                for (StepExecution stepExecution : jobExecutionImpl.getStepExecutions()) {
                    if (!stepExecution.getStepName().equals(stepName)) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    private static class Holder {
        private static final InMemoryRepository instance = new InMemoryRepository();

        private Holder() {
        }
    }
}

