/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.repository;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.StepExecution;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jberet._private.BatchMessages;
import org.jberet.job.model.Job;
import org.jberet.repository.AbstractRepository;
import org.jberet.repository.ApplicationAndJobName;
import org.jberet.runtime.AbstractStepExecution;
import org.jberet.runtime.JobExecutionImpl;
import org.jberet.runtime.JobInstanceImpl;
import org.jberet.runtime.PartitionExecutionImpl;
import org.jberet.runtime.StepExecutionImpl;

public final class InfinispanRepository
extends AbstractRepository {
    private static final String DEFAULT_INFINISPAN_XML = "infinispan.xml";
    private Cache<String, Long> sequenceCache;
    private Cache<Long, JobInstanceImpl> jobInstanceCache;
    private Cache<Long, JobExecutionImpl> jobExecutionCache;
    private Cache<Long, StepExecutionImpl> stepExecutionCache;
    private Cache<String, PartitionExecutionImpl> partitionExecutionCache;
    private EmbeddedCacheManager cacheManager;

    public static InfinispanRepository create(Configuration infinispanConfig) {
        return new InfinispanRepository(infinispanConfig);
    }

    public static InfinispanRepository create(Properties configProperties) {
        String infinispanXml = configProperties.getProperty("infinispan-xml");
        if (infinispanXml == null || infinispanXml.isEmpty()) {
            infinispanXml = DEFAULT_INFINISPAN_XML;
        }
        return new InfinispanRepository(infinispanXml);
    }

    public InfinispanRepository(Configuration infinispanConfig) {
        this.cacheManager = new DefaultCacheManager(infinispanConfig);
        this.initCaches();
    }

    public InfinispanRepository(String infinispanXml) {
        try {
            this.cacheManager = new DefaultCacheManager(infinispanXml);
        }
        catch (IOException e) {
            throw BatchMessages.MESSAGES.failToCreateCacheManager(e, infinispanXml);
        }
        this.initCaches();
    }

    @Override
    public void removeJob(String jobId) {
        this.jobs.remove(jobId);
    }

    @Override
    public JobInstanceImpl createJobInstance(Job job, String applicationName, ClassLoader classLoader) {
        ApplicationAndJobName appJobNames = new ApplicationAndJobName(applicationName, job.getId());
        JobInstanceImpl jobInstance = new JobInstanceImpl(job, appJobNames);
        this.insertJobInstance(jobInstance);
        return jobInstance;
    }

    @Override
    public void removeJobInstance(long jobInstanceIdToRemove) {
        this.jobInstanceCache.remove((Object)jobInstanceIdToRemove);
    }

    @Override
    public JobInstance getJobInstance(long jobInstanceId) {
        return (JobInstance)this.jobInstanceCache.get((Object)jobInstanceId);
    }

    @Override
    public List<JobInstance> getJobInstances(String jobName) {
        long largestJobInstanceId;
        ArrayList<JobInstance> result = new ArrayList<JobInstance>();
        for (long i = largestJobInstanceId = ((Long)this.sequenceCache.get((Object)"JOB_INSTANCE_ID_SEQ")).longValue(); i > 0L; --i) {
            JobInstanceImpl e = (JobInstanceImpl)this.jobInstanceCache.get((Object)i);
            if (e == null || !e.getJobName().equals(jobName)) continue;
            result.add(e);
        }
        return result;
    }

    @Override
    public int getJobInstanceCount(String jobName) {
        long largestJobInstanceId;
        int count = 0;
        for (long i = largestJobInstanceId = ((Long)this.sequenceCache.get((Object)"JOB_INSTANCE_ID_SEQ")).longValue(); i > 0L; --i) {
            JobInstanceImpl e = (JobInstanceImpl)this.jobInstanceCache.get((Object)i);
            if (e == null || !e.getJobName().equals(jobName)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public JobExecutionImpl createJobExecution(JobInstanceImpl jobInstance, Properties jobParameters) {
        JobExecutionImpl jobExecution = new JobExecutionImpl(jobInstance, jobParameters);
        this.insertJobExecution(jobExecution);
        jobInstance.addJobExecution(jobExecution);
        return jobExecution;
    }

    @Override
    public JobExecution getJobExecution(long jobExecutionId) {
        return (JobExecution)this.jobExecutionCache.get((Object)jobExecutionId);
    }

    @Override
    public List<JobExecution> getJobExecutions(JobInstance jobInstance) {
        return super.getJobExecutions((JobInstance)this.jobInstanceCache.get((Object)jobInstance.getInstanceId()));
    }

    @Override
    public List<StepExecution> getStepExecutions(long jobExecutionId, ClassLoader classLoader) {
        JobExecutionImpl jobExecution = (JobExecutionImpl)this.jobExecutionCache.get((Object)jobExecutionId);
        return jobExecution.getStepExecutions();
    }

    @Override
    public void addStepExecution(JobExecutionImpl jobExecution, StepExecutionImpl stepExecution) {
        jobExecution.addStepExecution(stepExecution);
        this.insertStepExecution(stepExecution, jobExecution);
    }

    @Override
    public void savePersistentData(JobExecution jobExecution, AbstractStepExecution stepOrPartitionExecution) {
        super.savePersistentData(jobExecution, stepOrPartitionExecution);
        if (stepOrPartitionExecution instanceof StepExecutionImpl) {
            this.updateStepExecution(stepOrPartitionExecution);
        } else {
            PartitionExecutionImpl partitionExecution = (PartitionExecutionImpl)stepOrPartitionExecution;
            this.partitionExecutionCache.put((Object)InfinispanRepository.concatPartitionExecutionId(partitionExecution.getStepExecutionId(), partitionExecution.getPartitionId()), (Object)partitionExecution);
        }
    }

    @Override
    public void updateStepExecution(StepExecution stepExecution) {
        this.stepExecutionCache.put((Object)stepExecution.getStepExecutionId(), (Object)((StepExecutionImpl)stepExecution));
    }

    @Override
    public void updateJobExecution(JobExecutionImpl jobExecution, boolean fullUpdate) {
        jobExecution.setEndTime(System.currentTimeMillis());
        this.jobExecutionCache.put((Object)jobExecution.getExecutionId(), (Object)jobExecution);
    }

    @Override
    public StepExecutionImpl findOriginalStepExecutionForRestart(String stepName, JobExecutionImpl jobExecutionToRestart0, ClassLoader classLoader) {
        JobExecutionImpl jobExecutionToRestart = (JobExecutionImpl)this.jobExecutionCache.get((Object)jobExecutionToRestart0.getExecutionId());
        for (StepExecution stepExecution : jobExecutionToRestart.getStepExecutions()) {
            if (!stepName.equals(stepExecution.getStepName())) continue;
            return (StepExecutionImpl)stepExecution;
        }
        AbstractStepExecution result = null;
        long instanceId = jobExecutionToRestart.getJobInstance().getInstanceId();
        JobInstanceImpl jobInstanceToRestart = (JobInstanceImpl)this.jobInstanceCache.get((Object)instanceId);
        for (JobExecution jobExecution : jobInstanceToRestart.getJobExecutions()) {
            JobExecutionImpl jobExecutionImpl = (JobExecutionImpl)jobExecution;
            if (jobExecutionImpl.getExecutionId() == jobExecutionToRestart.getExecutionId()) continue;
            for (StepExecution stepExecution : jobExecutionImpl.getStepExecutions()) {
                if (!stepExecution.getStepName().equals(stepName) || result != null && result.getStepExecutionId() >= stepExecution.getStepExecutionId()) continue;
                result = (StepExecutionImpl)stepExecution;
            }
        }
        return result;
    }

    @Override
    public void addPartitionExecution(StepExecutionImpl enclosingStepExecution, PartitionExecutionImpl partitionExecution) {
        super.addPartitionExecution(enclosingStepExecution, partitionExecution);
        this.partitionExecutionCache.put((Object)InfinispanRepository.concatPartitionExecutionId(partitionExecution.getStepExecutionId(), partitionExecution.getPartitionId()), (Object)partitionExecution);
    }

    @Override
    public List<PartitionExecutionImpl> getPartitionExecutions(long stepExecutionId, StepExecutionImpl stepExecution, boolean notCompletedOnly, ClassLoader classLoader) {
        return super.getPartitionExecutions(stepExecutionId, (StepExecutionImpl)this.stepExecutionCache.get((Object)stepExecutionId), notCompletedOnly, classLoader);
    }

    @Override
    public int countStepStartTimes(String stepName, long jobInstanceId) {
        int count = 0;
        JobInstanceImpl jobInstanceImpl = (JobInstanceImpl)this.jobInstanceCache.get((Object)jobInstanceId);
        if (jobInstanceImpl != null) {
            for (JobExecution jobExecution : jobInstanceImpl.getJobExecutions()) {
                JobExecutionImpl jobExecutionImpl = (JobExecutionImpl)this.jobExecutionCache.get((Object)jobExecution.getExecutionId());
                for (StepExecution stepExecution : jobExecutionImpl.getStepExecutions()) {
                    if (!stepExecution.getStepName().equals(stepName)) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    @Override
    void insertJobInstance(JobInstanceImpl jobInstance) {
        long jobInstanceId = this.getNextIdFor("JOB_INSTANCE_ID_SEQ");
        jobInstance.setId(jobInstanceId);
        this.jobInstanceCache.put((Object)jobInstanceId, (Object)jobInstance);
    }

    @Override
    void insertJobExecution(JobExecutionImpl jobExecution) {
        Long jobExecutionId = this.getNextIdFor("JOB_EXECUTION_ID_SEQ");
        jobExecution.setId(jobExecutionId);
        this.jobExecutionCache.put((Object)jobExecutionId, (Object)jobExecution);
    }

    @Override
    void insertStepExecution(StepExecutionImpl stepExecution, JobExecutionImpl jobExecution) {
        long stepExecutionId = this.getNextIdFor("STEP_EXECUTION_ID_SEQ");
        stepExecution.setId(stepExecutionId);
        this.stepExecutionCache.put((Object)stepExecutionId, (Object)stepExecution);
    }

    private void initCaches() {
        this.sequenceCache = this.cacheManager.getCache("seq", true);
        this.sequenceCache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP, Flag.SKIP_CACHE_LOAD});
        this.sequenceCache.putIfAbsent((Object)"JOB_INSTANCE_ID_SEQ", (Object)0L);
        this.sequenceCache.putIfAbsent((Object)"JOB_EXECUTION_ID_SEQ", (Object)0L);
        this.sequenceCache.putIfAbsent((Object)"STEP_EXECUTION_ID_SEQ", (Object)0L);
        this.jobInstanceCache = this.cacheManager.getCache("JOB_INSTANCE", true);
        this.jobInstanceCache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP, Flag.SKIP_CACHE_LOAD});
        this.jobExecutionCache = this.cacheManager.getCache("JOB_EXECUTION", true);
        this.jobExecutionCache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP, Flag.SKIP_CACHE_LOAD});
        this.stepExecutionCache = this.cacheManager.getCache("STEP_EXECUTION", true);
        this.stepExecutionCache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP, Flag.SKIP_CACHE_LOAD});
        this.partitionExecutionCache = this.cacheManager.getCache("PARTITION_EXECUTION", true);
        this.partitionExecutionCache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP, Flag.SKIP_CACHE_LOAD});
    }

    private long getNextIdFor(String key) {
        TransactionManager infinispanTransactionManager = this.sequenceCache.getAdvancedCache().getTransactionManager();
        try {
            infinispanTransactionManager.begin();
            this.sequenceCache.getAdvancedCache().lock((Object[])new String[]{key});
            long nextId = (Long)this.sequenceCache.get((Object)key) + 1L;
            this.sequenceCache.put((Object)key, (Object)nextId);
            infinispanTransactionManager.commit();
            return nextId;
        }
        catch (Exception e) {
            throw BatchMessages.MESSAGES.failToGetNextId(e, key);
        }
    }

    private static String concatPartitionExecutionId(long stepExecutionId, int partitionId) {
        return String.valueOf(stepExecutionId) + '-' + String.valueOf(partitionId);
    }
}

