/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.repository;

import java.util.Date;
import java.util.Set;
import javax.batch.api.BatchProperty;
import javax.batch.api.Batchlet;
import javax.batch.runtime.context.JobContext;
import javax.batch.runtime.context.StepContext;
import javax.inject.Inject;
import org.jberet.job.model.Job;
import org.jberet.repository.DefaultJobExecutionSelector;
import org.jberet.repository.JdbcRepository;
import org.jberet.repository.JobExecutionSelector;
import org.jberet.repository.JobRepository;
import org.jberet.runtime.context.JobContextImpl;

public final class PurgeBatchlet
implements Batchlet {
    @Inject
    private JobContext jobContext;
    @Inject
    private StepContext stepContext;
    @Inject
    @BatchProperty
    String sql;
    @Inject
    @BatchProperty
    String sqlFile;
    @Inject
    @BatchProperty
    Class jobExecutionSelector;
    @Inject
    @BatchProperty
    Boolean keepRunningJobExecutions;
    @Inject
    @BatchProperty
    Set<Long> jobExecutionIds;
    @Inject
    @BatchProperty
    Integer numberOfRecentJobExecutionsToKeep;
    @Inject
    @BatchProperty
    Long jobExecutionIdFrom;
    @Inject
    @BatchProperty
    Long jobExecutionIdTo;
    @Inject
    @BatchProperty
    Integer withinPastMinutes;
    @Inject
    @BatchProperty
    Date jobExecutionEndTimeFrom;
    @Inject
    @BatchProperty
    Date jobExecutionEndTimeTo;
    @Inject
    @BatchProperty
    Set<String> batchStatuses;
    @Inject
    @BatchProperty
    Set<String> exitStatuses;
    @Inject
    @BatchProperty
    Set<String> jobExecutionsByJobNames;
    @Inject
    @BatchProperty
    Set<String> purgeJobsByNames;

    public String process() throws Exception {
        JobContextImpl jobContextImpl = (JobContextImpl)this.jobContext;
        JobRepository jobRepository = jobContextImpl.getJobRepository();
        if (this.purgeJobsByNames != null && !this.purgeJobsByNames.isEmpty()) {
            boolean purgeAll = this.purgeJobsByNames.size() == 1 && this.purgeJobsByNames.contains("*");
            String currentJobName = this.jobContext.getJobName();
            for (Job job : jobRepository.getJobs()) {
                if (!this.purgeJobsByNames.contains(job.getId()) && (!purgeAll || currentJobName.equals(job.getId()))) continue;
                jobRepository.removeJob(job.getId());
            }
        } else {
            JobExecutionSelector selector;
            if (this.jobExecutionSelector != null) {
                selector = (JobExecutionSelector)this.jobExecutionSelector.newInstance();
            } else {
                DefaultJobExecutionSelector selector1 = new DefaultJobExecutionSelector(this.keepRunningJobExecutions);
                selector1.jobExecutionIds = this.jobExecutionIds;
                selector1.numberOfRecentJobExecutionsToExclude = this.numberOfRecentJobExecutionsToKeep;
                selector1.jobExecutionIdFrom = this.jobExecutionIdFrom;
                selector1.jobExecutionIdTo = this.jobExecutionIdTo;
                selector1.withinPastMinutes = this.withinPastMinutes;
                selector1.jobExecutionEndTimeFrom = this.jobExecutionEndTimeFrom;
                selector1.jobExecutionEndTimeTo = this.jobExecutionEndTimeTo;
                selector1.batchStatuses = this.batchStatuses;
                selector1.exitStatuses = this.exitStatuses;
                selector1.jobExecutionsByJobNames = this.jobExecutionsByJobNames;
                selector = selector1;
            }
            selector.setJobContext(this.jobContext);
            selector.setStepContext(this.stepContext);
            jobRepository.removeJobExecutions(selector);
        }
        if (jobRepository instanceof JdbcRepository) {
            if (this.sql != null) {
                ((JdbcRepository)jobRepository).executeStatements(this.sql, null);
            } else if (this.sqlFile != null) {
                ((JdbcRepository)jobRepository).executeStatements(null, this.sqlFile);
            }
        }
        return null;
    }

    public void stop() throws Exception {
    }
}

