/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.runtime.runner;

import java.util.List;
import javax.batch.runtime.BatchStatus;
import org.jberet._private.BatchLogger;
import org.jberet.job.model.Job;
import org.jberet.job.model.JobElement;
import org.jberet.runtime.context.JobContextImpl;
import org.jberet.runtime.runner.CompositeExecutionRunner;

public final class JobExecutionRunner
extends CompositeExecutionRunner<JobContextImpl>
implements Runnable {
    private final Job job;

    public JobExecutionRunner(JobContextImpl jobContext) {
        super(jobContext, null);
        this.job = jobContext.getJob();
    }

    @Override
    protected List<? extends JobElement> getJobElements() {
        return this.job.getJobElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int i;
        if (((JobContextImpl)this.batchContext).getBatchStatus() != BatchStatus.STOPPING) {
            ((JobContextImpl)this.batchContext).setBatchStatus(BatchStatus.STARTED);
            ((JobContextImpl)this.batchContext).getJobRepository().updateJobExecution(((JobContextImpl)this.batchContext).getJobExecution(), false);
        }
        Object[] jobListeners = ((JobContextImpl)this.batchContext).getJobListeners();
        try {
            for (i = 0; i < jobListeners.length; ++i) {
                jobListeners[i].beforeJob();
            }
            this.runFromHeadOrRestartPoint(((JobContextImpl)this.batchContext).getJobExecution().getRestartPosition());
        }
        catch (Throwable e) {
            BatchLogger.LOGGER.failToRunJob(e, this.job.getId(), "", this.job);
            ((JobContextImpl)this.batchContext).setBatchStatus(BatchStatus.FAILED);
        }
        finally {
            for (i = 0; i < jobListeners.length; ++i) {
                try {
                    jobListeners[i].afterJob();
                    continue;
                }
                catch (Throwable e) {
                    BatchLogger.LOGGER.failToRunJob(e, this.job.getId(), "", jobListeners[i]);
                    ((JobContextImpl)this.batchContext).setBatchStatus(BatchStatus.FAILED);
                }
            }
        }
        ((JobContextImpl)this.batchContext).destroyArtifact(jobListeners);
        if (((JobContextImpl)this.batchContext).getBatchStatus() == BatchStatus.STARTED) {
            ((JobContextImpl)this.batchContext).setBatchStatus(BatchStatus.COMPLETED);
        } else if (((JobContextImpl)this.batchContext).getBatchStatus() == BatchStatus.STOPPING) {
            ((JobContextImpl)this.batchContext).setBatchStatus(BatchStatus.STOPPED);
        }
        ((JobContextImpl)this.batchContext).getJobRepository().updateJobExecution(((JobContextImpl)this.batchContext).getJobExecution(), true);
        ((JobContextImpl)this.batchContext).getJobExecution().cleanUp();
    }
}

