/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

class ValidateModelStepHandler
implements OperationStepHandler {
    static final ValidateModelStepHandler INSTANCE = new ValidateModelStepHandler();

    private ValidateModelStepHandler() {
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = this.loadResource(context);
        if (resource == null) {
            return;
        }
        ModelNode model = resource.getModel();
        ImmutableManagementResourceRegistration resourceRegistration = context.getResourceRegistration();
        Set<String> attributeNames = resourceRegistration.getAttributeNames(PathAddress.EMPTY_ADDRESS);
        for (final String attributeName : attributeNames) {
            boolean has = model.hasDefined(attributeName);
            AttributeAccess access = context.getResourceRegistration().getAttributeAccess(PathAddress.EMPTY_ADDRESS, attributeName);
            if (access.getStorageType() != AttributeAccess.Storage.CONFIGURATION) continue;
            final AttributeDefinition attr = access.getAttributeDefinition();
            if (!has && this.isRequired(attr, model)) {
                this.attemptReadMissingAttributeValueFromHandler(context, access, attributeName, new ErrorHandler(){

                    @Override
                    public void throwError() throws OperationFailedException {
                        throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.required(attributeName));
                    }
                });
            }
            if (!has) continue;
            if (attr.getRequires() != null) {
                for (final String required : attr.getRequires()) {
                    if (model.hasDefined(required)) continue;
                    this.attemptReadMissingAttributeValueFromHandler(context, access, attributeName, new ErrorHandler(){

                        @Override
                        public void throwError() throws OperationFailedException {
                            throw ControllerLogger.ROOT_LOGGER.requiredAttributeNotSet(required, attr.getName());
                        }
                    });
                }
            }
            if (this.isAllowed(attr, model)) continue;
            String[] alts = attr.getAlternatives();
            StringBuilder sb = null;
            if (alts != null) {
                for (String alt : alts) {
                    if (!model.hasDefined(alt)) continue;
                    if (sb == null) {
                        sb = new StringBuilder();
                    } else {
                        sb.append(", ");
                    }
                    sb.append(alt);
                }
            }
            throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.invalidAttributeCombo(attributeName, sb));
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    private void attemptReadMissingAttributeValueFromHandler(OperationContext context, AttributeAccess attributeAccess, String attributeName, final ErrorHandler errorHandler) throws OperationFailedException {
        OperationStepHandler handler = attributeAccess.getReadHandler();
        if (handler == null) {
            errorHandler.throwError();
        } else {
            ModelNode readAttr = Util.getReadAttributeOperation(context.getCurrentAddress(), attributeName);
            final ModelNode resultHolder = new ModelNode();
            context.addStep(resultHolder, readAttr, handler, OperationContext.Stage.MODEL, true);
            context.addStep(new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    if (!resultHolder.isDefined() && !resultHolder.hasDefined("result")) {
                        errorHandler.throwError();
                    }
                }
            }, OperationContext.Stage.MODEL);
        }
    }

    private boolean isRequired(AttributeDefinition def, ModelNode model) {
        boolean required;
        boolean bl = required = !def.isAllowNull() && !def.isResourceOnly();
        return required ? !this.hasAlternative(def.getAlternatives(), model) : required;
    }

    private boolean isAllowed(AttributeDefinition def, ModelNode model) {
        String[] alternatives = def.getAlternatives();
        if (alternatives != null) {
            for (String alternative : alternatives) {
                if (!model.hasDefined(alternative)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean hasAlternative(String[] alternatives, ModelNode operationObject) {
        if (alternatives != null) {
            for (String alternative : alternatives) {
                if (!operationObject.hasDefined(alternative)) continue;
                return true;
            }
        }
        return false;
    }

    private Resource loadResource(OperationContext context) {
        PathAddress address = context.getCurrentAddress();
        PathAddress current = PathAddress.EMPTY_ADDRESS;
        Resource resource = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, false);
        for (PathElement element : address) {
            if (!resource.hasChild(element)) {
                return null;
            }
            current = current.append(element);
            resource = context.readResourceFromRoot(current, false);
        }
        return resource;
    }

    private static interface ErrorHandler {
        public void throwError() throws OperationFailedException;
    }
}

