/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Properties;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.configuration.cache.AbstractPersistenceConfigurationChildBuilder;
import org.infinispan.configuration.cache.AsyncStoreConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.SingletonStoreConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.XmlConfigHelper;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class AbstractStoreConfigurationBuilder<T extends StoreConfiguration, S extends AbstractStoreConfigurationBuilder<T, S>>
extends AbstractPersistenceConfigurationChildBuilder
implements StoreConfigurationBuilder<T, S> {
    private static final Log log = LogFactory.getLog(AbstractStoreConfigurationBuilder.class);
    protected final AsyncStoreConfigurationBuilder<S> async;
    protected final SingletonStoreConfigurationBuilder<S> singletonStore;
    protected boolean fetchPersistentState = false;
    protected boolean ignoreModifications = false;
    protected boolean purgeOnStartup = false;
    protected boolean shared = false;
    protected boolean preload = false;
    protected Properties properties = new Properties();

    public AbstractStoreConfigurationBuilder(PersistenceConfigurationBuilder builder) {
        super(builder);
        this.async = new AsyncStoreConfigurationBuilder(this);
        this.singletonStore = new SingletonStoreConfigurationBuilder(this);
    }

    @Override
    public AsyncStoreConfigurationBuilder<S> async() {
        return this.async;
    }

    @Override
    public SingletonStoreConfigurationBuilder<S> singleton() {
        return this.singletonStore;
    }

    @Override
    public S fetchPersistentState(boolean b) {
        this.fetchPersistentState = b;
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S ignoreModifications(boolean b) {
        this.ignoreModifications = b;
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S purgeOnStartup(boolean b) {
        this.purgeOnStartup = b;
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    public S properties(Properties properties) {
        this.properties = properties;
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S addProperty(String key, String value) {
        this.properties.put(key, value);
        XmlConfigHelper.setValues(this, this.properties, false, false);
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S withProperties(Properties props) {
        XmlConfigHelper.showUnrecognizedAttributes(XmlConfigHelper.setValues(this, props, false, false));
        this.properties = props;
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S preload(boolean b) {
        this.preload = b;
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S shared(boolean b) {
        this.shared = b;
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    public void validate() {
        this.async.validate();
        this.singletonStore.validate();
        ConfigurationBuilder builder = this.getBuilder();
        if (!this.shared && !this.fetchPersistentState && !this.purgeOnStartup && builder.clustering().cacheMode().isClustered()) {
            log.staleEntriesWithoutFetchPersistentStateOrPurgeOnStartup();
        }
        if (this.shared && !this.preload && builder.indexing().enabled() && builder.indexing().indexLocalOnly()) {
            log.localIndexingWithSharedCacheLoaderRequiresPreload();
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    public Builder<?> read(T template) {
        this.async.read(template.async());
        this.singletonStore.read(template.singletonStore());
        this.fetchPersistentState = template.fetchPersistentState();
        this.ignoreModifications = template.ignoreModifications();
        this.purgeOnStartup = template.purgeOnStartup();
        this.shared = template.shared();
        this.preload = template.preload();
        this.properties = template.properties();
        return this;
    }
}

