/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.base;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SelfDeliverFilter;
import org.infinispan.remoting.responses.TimeoutValidationResponseFilter;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptionsBuilder;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.StateConsumer;
import org.infinispan.transaction.impl.LocalTransaction;

public abstract class BaseRpcInterceptor
extends CommandInterceptor {
    protected RpcManager rpcManager;
    protected boolean defaultSynchronous;

    @Inject
    public void inject(RpcManager rpcManager, StateConsumer stateConsumer) {
        this.rpcManager = rpcManager;
    }

    @Start
    public void init() {
        this.defaultSynchronous = this.cacheConfiguration.clustering().cacheMode().isSynchronous();
    }

    protected final boolean isSynchronous(FlagAffectedCommand command) {
        if (command.hasFlag(Flag.FORCE_SYNCHRONOUS)) {
            return true;
        }
        if (command.hasFlag(Flag.FORCE_ASYNCHRONOUS)) {
            return false;
        }
        return this.defaultSynchronous;
    }

    protected final boolean isLocalModeForced(FlagAffectedCommand command) {
        if (command.hasFlag(Flag.CACHE_MODE_LOCAL)) {
            if (this.getLog().isTraceEnabled()) {
                this.getLog().trace("LOCAL mode forced on invocation.  Suppressing clustered events.");
            }
            return true;
        }
        return false;
    }

    protected boolean shouldInvokeRemoteTxCommand(TxInvocationContext ctx) {
        boolean shouldInvokeRemotely;
        if (!ctx.isOriginLocal()) {
            return false;
        }
        LocalTxInvocationContext localCtx = (LocalTxInvocationContext)ctx;
        boolean bl = shouldInvokeRemotely = ctx.hasModifications() || !localCtx.getRemoteLocksAcquired().isEmpty() || ((LocalTransaction)localCtx.getCacheTransaction()).getTopologyId() != this.rpcManager.getTopologyId();
        if (this.getLog().isTraceEnabled()) {
            this.getLog().tracef("Should invoke remotely? %b. hasModifications=%b, hasRemoteLocksAcquired=%b", shouldInvokeRemotely, ctx.hasModifications(), !localCtx.getRemoteLocksAcquired().isEmpty());
        }
        return shouldInvokeRemotely;
    }

    protected static void transactionRemotelyPrepared(TxInvocationContext ctx) {
        if (ctx.isOriginLocal()) {
            ((LocalTransaction)ctx.getCacheTransaction()).markPrepareSent();
        }
    }

    protected static void totalOrderTxCommit(TxInvocationContext ctx) {
        if (ctx.isOriginLocal()) {
            ((LocalTransaction)ctx.getCacheTransaction()).markCommitOrRollbackSent();
        }
    }

    protected static void totalOrderTxRollback(TxInvocationContext ctx) {
        if (ctx.isOriginLocal()) {
            ((LocalTransaction)ctx.getCacheTransaction()).markCommitOrRollbackSent();
        }
    }

    protected static boolean shouldTotalOrderRollbackBeInvokedRemotely(TxInvocationContext ctx) {
        return ctx.isOriginLocal() && ((LocalTransaction)ctx.getCacheTransaction()).isPrepareSent() && !((LocalTransaction)ctx.getCacheTransaction()).isCommitOrRollbackSent();
    }

    protected final Map<Address, Response> totalOrderPrepare(Collection<Address> recipients, PrepareCommand prepareCommand, TimeoutValidationResponseFilter responseFilter) {
        HashSet<Address> realRecipients = null;
        if (recipients != null) {
            realRecipients = new HashSet<Address>(recipients);
            realRecipients.add(this.rpcManager.getAddress());
        }
        return this.internalTotalOrderPrepare(realRecipients, prepareCommand, responseFilter);
    }

    private Map<Address, Response> internalTotalOrderPrepare(Collection<Address> recipients, PrepareCommand prepareCommand, TimeoutValidationResponseFilter responseFilter) {
        if (this.defaultSynchronous) {
            RpcOptionsBuilder builder = this.rpcManager.getRpcOptionsBuilder(ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS, DeliverOrder.TOTAL);
            if (responseFilter != null) {
                builder.responseFilter(responseFilter);
            }
            Map<Address, Response> responseMap = this.rpcManager.invokeRemotely(recipients, (ReplicableCommand)prepareCommand, builder.build());
            if (responseFilter != null) {
                responseFilter.validate();
            }
            return responseMap;
        }
        RpcOptionsBuilder builder = this.rpcManager.getRpcOptionsBuilder(ResponseMode.getAsyncResponseMode(this.cacheConfiguration), DeliverOrder.TOTAL);
        return this.rpcManager.invokeRemotely(recipients, (ReplicableCommand)prepareCommand, builder.build());
    }

    protected final boolean isSyncCommitPhase() {
        return this.cacheConfiguration.transaction().syncCommitPhase();
    }

    protected final TimeoutValidationResponseFilter getSelfDeliverFilter() {
        return new SelfDeliverFilter(this.rpcManager.getAddress());
    }
}

