/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security;

import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.acl.Group;
import java.util.Stack;
import javax.security.auth.Subject;
import org.infinispan.security.CachePermission;
import sun.reflect.Reflection;

public final class Security {
    private static final boolean hasGetCallerClass;
    private static final int callerOffset;
    private static final LocalSecurityManager SECURITY_MANAGER;
    private static final ThreadLocal<Boolean> PRIVILEGED;
    private static final ThreadLocal<Stack<Subject>> SUBJECT;

    private static boolean isTrustedClass(Class<?> klass) {
        return klass.getPackage().getName().startsWith("org.infinispan.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (!Security.isPrivileged() && Security.isTrustedClass(Security.getCallerClass(2))) {
            try {
                PRIVILEGED.set(true);
                T t = action.run();
                return t;
            }
            finally {
                PRIVILEGED.remove();
            }
        }
        return action.run();
    }

    public static <T> T doPrivileged(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        if (!Security.isPrivileged() && Security.isTrustedClass(Security.getCallerClass(2))) {
            try {
                PRIVILEGED.set(true);
                T t = action.run();
                return t;
            }
            catch (Exception e) {
                throw new PrivilegedActionException(e);
            }
            finally {
                PRIVILEGED.remove();
            }
        }
        try {
            return action.run();
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doAs(Subject subject, PrivilegedAction<T> action) {
        Stack<Subject> stack = SUBJECT.get();
        if (stack == null) {
            stack = new Stack();
            SUBJECT.set(stack);
        }
        stack.push(subject);
        try {
            T t = action.run();
            return t;
        }
        finally {
            stack.pop();
            if (stack.isEmpty()) {
                SUBJECT.remove();
            }
        }
    }

    public static <T> T doAs(Subject subject, PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        Stack<Subject> stack = SUBJECT.get();
        if (stack == null) {
            stack = new Stack();
            SUBJECT.set(stack);
        }
        stack.push(subject);
        try {
            T t = action.run();
            return t;
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
        finally {
            stack.pop();
            if (stack.isEmpty()) {
                SUBJECT.remove();
            }
        }
    }

    public static void checkPermission(CachePermission permission) throws AccessControlException {
        if (!Security.isPrivileged()) {
            throw new AccessControlException("Call from unprivileged code", permission);
        }
    }

    public static boolean isPrivileged() {
        return PRIVILEGED.get();
    }

    public static Subject getSubject() {
        if (SUBJECT.get() != null) {
            return SUBJECT.get().peek();
        }
        AccessControlContext acc = AccessController.getContext();
        return Subject.getSubject(acc);
    }

    public static Principal getSubjectUserPrincipal(Subject s) {
        if (s != null) {
            for (Principal p : s.getPrincipals()) {
                if (p instanceof Group) continue;
                return p;
            }
        }
        return null;
    }

    static Class<?> getCallerClass(int n) {
        if (hasGetCallerClass) {
            return Reflection.getCallerClass((int)(n + callerOffset));
        }
        return SECURITY_MANAGER.getClasses()[n + callerOffset];
    }

    static {
        boolean result = false;
        int offset = 0;
        try {
            result = Reflection.getCallerClass((int)1) == Security.class || Reflection.getCallerClass((int)2) == Security.class;
            offset = Reflection.getCallerClass((int)1) == Reflection.class ? 2 : 1;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        hasGetCallerClass = result;
        callerOffset = offset;
        SECURITY_MANAGER = !hasGetCallerClass ? new LocalSecurityManager() : null;
        PRIVILEGED = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.FALSE;
            }
        };
        SUBJECT = new ThreadLocal();
    }

    private static class LocalSecurityManager
    extends SecurityManager {
        private LocalSecurityManager() {
        }

        public Class<?>[] getClasses() {
            return this.getClassContext();
        }
    }
}

