/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.rts;

import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.rts.RTSSubsystemDefinition;
import org.wildfly.extension.rts.RTSSubsystemExtension;
import org.wildfly.extension.rts.configuration.Attribute;
import org.wildfly.extension.rts.configuration.Element;
import org.wildfly.extension.rts.logging.RTSLogger;

final class RTSSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    RTSSubsystemParser() {
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        if (RTSLogger.ROOT_LOGGER.isTraceEnabled()) {
            RTSLogger.ROOT_LOGGER.trace("RTSSubsystemParser.writeContent");
        }
        context.startSubsystemElement("urn:jboss:domain:rts:1.0", false);
        ModelNode node = context.getModelNode();
        writer.writeStartElement(Element.SERVLET.getLocalName());
        RTSSubsystemDefinition.SERVER.marshallAsAttribute(node, (XMLStreamWriter)writer);
        RTSSubsystemDefinition.HOST.marshallAsAttribute(node, (XMLStreamWriter)writer);
        RTSSubsystemDefinition.SOCKET_BINDING.marshallAsAttribute(node, (XMLStreamWriter)writer);
        writer.writeEndElement();
        writer.writeEndElement();
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        if (RTSLogger.ROOT_LOGGER.isTraceEnabled()) {
            RTSLogger.ROOT_LOGGER.trace("RTSSubsystemParser.readElement");
        }
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        ModelNode subsystem = Util.getEmptyOperation((String)"add", (ModelNode)PathAddress.pathAddress((PathElement[])new PathElement[]{RTSSubsystemExtension.SUBSYSTEM_PATH}).toModelNode());
        list.add(subsystem);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            if (element.equals((Object)Element.SERVLET)) {
                this.parseServletElement(reader, subsystem);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseServletElement(XMLExtendedStreamReader reader, ModelNode subsystem) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SERVER: {
                    RTSSubsystemDefinition.SERVER.parseAndSetParameter(value, subsystem, (XMLStreamReader)reader);
                    continue block5;
                }
                case HOST: {
                    RTSSubsystemDefinition.HOST.parseAndSetParameter(value, subsystem, (XMLStreamReader)reader);
                    continue block5;
                }
                case SOCKET_BINDING: {
                    RTSSubsystemDefinition.SOCKET_BINDING.parseAndSetParameter(value, subsystem, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }
}

