/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.iiop.openjdk;

import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.presentation.rmi.PresentationManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import javax.naming.spi.ObjectFactory;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.naming.InitialContext;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.metadata.ejb.jboss.IORASContextMetaData;
import org.jboss.metadata.ejb.jboss.IORSASContextMetaData;
import org.jboss.metadata.ejb.jboss.IORSecurityConfigMetaData;
import org.jboss.metadata.ejb.jboss.IORTransportConfigMetaData;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.wildfly.iiop.openjdk.IIOPInitializer;
import org.wildfly.iiop.openjdk.IORASContextDefinition;
import org.wildfly.iiop.openjdk.IORSASContextDefinition;
import org.wildfly.iiop.openjdk.IORSettingsDefinition;
import org.wildfly.iiop.openjdk.IORTransportConfigDefinition;
import org.wildfly.iiop.openjdk.InitializersDefinition;
import org.wildfly.iiop.openjdk.NamingDefinition;
import org.wildfly.iiop.openjdk.ORBDefinition;
import org.wildfly.iiop.openjdk.PropertiesMap;
import org.wildfly.iiop.openjdk.SSLConfigValue;
import org.wildfly.iiop.openjdk.SecurityDefinition;
import org.wildfly.iiop.openjdk.TCPDefinition;
import org.wildfly.iiop.openjdk.csiv2.CSIV2IORToSocketInfo;
import org.wildfly.iiop.openjdk.deployment.IIOPDependencyProcessor;
import org.wildfly.iiop.openjdk.deployment.IIOPMarkerProcessor;
import org.wildfly.iiop.openjdk.logging.IIOPLogger;
import org.wildfly.iiop.openjdk.naming.jndi.JBossCNCtxFactory;
import org.wildfly.iiop.openjdk.rmi.DelegatingStubFactoryFactory;
import org.wildfly.iiop.openjdk.security.SocketFactory;
import org.wildfly.iiop.openjdk.service.CorbaNamingService;
import org.wildfly.iiop.openjdk.service.CorbaORBService;
import org.wildfly.iiop.openjdk.service.CorbaPOAService;
import org.wildfly.iiop.openjdk.service.IORSecConfigMetaDataService;
import org.wildfly.security.manager.WildFlySecurityManager;

public class IIOPSubsystemAdd
extends AbstractAddStepHandler {
    static final IIOPSubsystemAdd INSTANCE = new IIOPSubsystemAdd();
    private static final ServiceName SECURITY_DOMAIN_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"security"}).append(new String[]{"security-domain"});

    protected IIOPSubsystemAdd() {
    }

    protected IIOPSubsystemAdd(Collection<? extends AttributeDefinition> attributes) {
        super(attributes);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
                ModelNode node = Resource.Tools.readModel((Resource)resource);
                IIOPSubsystemAdd.this.launchServices(context, node);
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
    }

    protected void launchServices(OperationContext context, ModelNode model) throws OperationFailedException {
        IIOPLogger.ROOT_LOGGER.activatingSubsystem();
        WildFlySecurityManager.setPropertyPrivileged((String)"org.jboss.com.sun.CORBA.ORBUseDynamicStub", (String)"true");
        ORB.getPresentationManager().setStubFactoryFactory(true, (PresentationManager.StubFactoryFactory)new DelegatingStubFactoryFactory());
        ORB.getPresentationManager().setStubFactoryFactory(false, (PresentationManager.StubFactoryFactory)new DelegatingStubFactoryFactory());
        InitialContext.addUrlContextFactory((String)"corbaloc", (ObjectFactory)JBossCNCtxFactory.INSTANCE);
        InitialContext.addUrlContextFactory((String)"corbaname", (ObjectFactory)JBossCNCtxFactory.INSTANCE);
        InitialContext.addUrlContextFactory((String)"IOR", (ObjectFactory)JBossCNCtxFactory.INSTANCE);
        InitialContext.addUrlContextFactory((String)"iiopname", (ObjectFactory)JBossCNCtxFactory.INSTANCE);
        InitialContext.addUrlContextFactory((String)"iiop", (ObjectFactory)JBossCNCtxFactory.INSTANCE);
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            public void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("iiop-openjdk", Phase.DEPENDENCIES, 4992, (DeploymentUnitProcessor)new IIOPDependencyProcessor());
                processorTarget.addDeploymentProcessor("iiop-openjdk", Phase.PARSE, 16768, (DeploymentUnitProcessor)new IIOPMarkerProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
        Properties props = this.getConfigurationProperties(context, model);
        this.setupInitializers(props);
        this.setupSSLFactories(props);
        CorbaORBService orbService = new CorbaORBService(props);
        ServiceBuilder builder = context.getServiceTarget().addService(CorbaORBService.SERVICE_NAME, (Service)orbService);
        Services.addServerExecutorDependency((ServiceBuilder)builder, orbService.getExecutorInjector(), (boolean)false);
        String securityDomain = props.getProperty("security-domain");
        if (securityDomain != null && !securityDomain.isEmpty()) {
            builder.addDependency(SECURITY_DOMAIN_SERVICE_NAME.append(new String[]{securityDomain}));
        }
        String socketBinding = props.getProperty("socket-binding");
        builder.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{socketBinding}), SocketBinding.class, orbService.getIIOPSocketBindingInjector());
        String sslSocketBinding = props.getProperty("ssl-socket-binding");
        builder.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{sslSocketBinding}), SocketBinding.class, orbService.getIIOPSSLSocketBindingInjector());
        builder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        CorbaPOAService rootPOAService = new CorbaPOAService("RootPOA", "poa");
        context.getServiceTarget().addService(CorbaPOAService.ROOT_SERVICE_NAME, (Service)rootPOAService).addDependency(CorbaORBService.SERVICE_NAME, org.omg.CORBA.ORB.class, rootPOAService.getORBInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
        CorbaPOAService irPOAService = new CorbaPOAService("IRPOA", "irpoa", IdAssignmentPolicyValue.USER_ID, null, null, LifespanPolicyValue.PERSISTENT, null, null, null);
        context.getServiceTarget().addService(CorbaPOAService.INTERFACE_REPOSITORY_SERVICE_NAME, (Service)irPOAService).addDependency(CorbaPOAService.ROOT_SERVICE_NAME, POA.class, irPOAService.getParentPOAInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
        CorbaPOAService namingPOAService = new CorbaPOAService("Naming", null, IdAssignmentPolicyValue.USER_ID, null, null, LifespanPolicyValue.PERSISTENT, null, null, null);
        context.getServiceTarget().addService(CorbaPOAService.SERVICE_NAME.append(new String[]{"namingpoa"}), (Service)namingPOAService).addDependency(CorbaPOAService.ROOT_SERVICE_NAME, POA.class, namingPOAService.getParentPOAInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
        CorbaNamingService namingService = new CorbaNamingService(props);
        context.getServiceTarget().addService(CorbaNamingService.SERVICE_NAME, (Service)namingService).addDependency(CorbaORBService.SERVICE_NAME, org.omg.CORBA.ORB.class, namingService.getORBInjector()).addDependency(CorbaPOAService.ROOT_SERVICE_NAME, POA.class, namingService.getRootPOAInjector()).addDependency(CorbaPOAService.SERVICE_NAME.append(new String[]{"namingpoa"}), POA.class, namingService.getNamingPOAInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
        IORSecurityConfigMetaData securityConfigMetaData = null;
        ModelNode configNode = model.get("configuration");
        if (configNode.hasDefined("ior-settings")) {
            securityConfigMetaData = this.createIORSecurityConfigMetaData(context, model.get(this.getIORSettingsPath().getKeyValuePair()));
        }
        context.getServiceTarget().addService(IORSecConfigMetaDataService.SERVICE_NAME, (Service)new IORSecConfigMetaDataService(securityConfigMetaData)).setInitialMode(ServiceController.Mode.ACTIVE).install();
        this.configureClientSecurity(props);
    }

    protected PathElement getIORSettingsPath() {
        return IORSettingsDefinition.INSTANCE.getPathElement();
    }

    protected Properties getConfigurationProperties(OperationContext context, ModelNode model) throws OperationFailedException {
        Properties props = new Properties();
        this.getResourceProperties(props, ORBDefinition.INSTANCE, context, model.get(ORBDefinition.INSTANCE.getPathElement().getKeyValuePair()));
        this.getResourceProperties(props, TCPDefinition.INSTANCE, context, model.get(ORBDefinition.INSTANCE.getPathElement().getKeyValuePair()).get(TCPDefinition.INSTANCE.getPathElement().getKeyValuePair()));
        this.getResourceProperties(props, InitializersDefinition.INSTANCE, context, model.get(ORBDefinition.INSTANCE.getPathElement().getKeyValuePair()).get(InitializersDefinition.INSTANCE.getPathElement().getKeyValuePair()));
        this.getResourceProperties(props, NamingDefinition.INSTANCE, context, model.get(NamingDefinition.INSTANCE.getPathElement().getKeyValuePair()));
        this.getResourceProperties(props, SecurityDefinition.INSTANCE, context, model.get(SecurityDefinition.INSTANCE.getPathElement().getKeyValuePair()));
        ModelNode configNode = model.get("configuration");
        if (configNode.hasDefined("properties")) {
            for (Property property : configNode.get("properties").get("property").asPropertyList()) {
                String name = property.getName();
                String value = property.getValue().get("value").asString();
                props.setProperty(name, value);
            }
        }
        return props;
    }

    private void getResourceProperties(Properties properties, PersistentResourceDefinition resource, OperationContext context, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attrDefinition : resource.getAttributes()) {
            ModelNode resolvedModelAttribute = attrDefinition.resolveModelAttribute(context, model);
            if (!resolvedModelAttribute.isDefined()) continue;
            String name = attrDefinition.getName();
            String value = resolvedModelAttribute.asString();
            String openjdkProperty = PropertiesMap.PROPS_MAP.get(name);
            if (openjdkProperty != null) {
                name = openjdkProperty;
            }
            properties.setProperty(name, value);
        }
    }

    private void setupInitializers(Properties props) {
        ArrayList<String> orbInitializers = new ArrayList<String>();
        String installSecurity = (String)props.remove("security");
        if (installSecurity.equalsIgnoreCase("client")) {
            orbInitializers.addAll(Arrays.asList(IIOPInitializer.SECURITY_CLIENT.getInitializerClasses()));
        } else if (installSecurity.equalsIgnoreCase("identity")) {
            orbInitializers.addAll(Arrays.asList(IIOPInitializer.SECURITY_IDENTITY.getInitializerClasses()));
        }
        String installTransaction = (String)props.remove("transactions");
        if (installTransaction.equalsIgnoreCase("full")) {
            orbInitializers.addAll(Arrays.asList(IIOPInitializer.TRANSACTIONS.getInitializerClasses()));
        } else if (installTransaction.equalsIgnoreCase("spec")) {
            orbInitializers.addAll(Arrays.asList(IIOPInitializer.SPEC_TRANSACTIONS.getInitializerClasses()));
        }
        for (String initializerClass : orbInitializers) {
            props.setProperty("org.omg.PortableInterceptor.ORBInitializerClass." + initializerClass, "");
        }
    }

    private void setupSSLFactories(Properties props) throws OperationFailedException {
        boolean supportSSL = "true".equalsIgnoreCase(props.getProperty("support-ssl"));
        if (supportSSL) {
            String securityDomain = props.getProperty("security-domain");
            if (securityDomain == null || securityDomain.isEmpty()) {
                throw IIOPLogger.ROOT_LOGGER.noSecurityDomainSpecified();
            }
            SocketFactory.setSecurityDomain(securityDomain);
            props.setProperty("com.sun.CORBA.transport.ORBSocketFactoryClass", SocketFactory.class.getName());
        }
    }

    private IORSecurityConfigMetaData createIORSecurityConfigMetaData(OperationContext context, ModelNode node) throws OperationFailedException {
        IORSASContextMetaData sasContextMetaData;
        IORASContextMetaData asContextMetaData;
        IORSecurityConfigMetaData securityConfigMetaData = new IORSecurityConfigMetaData();
        IORTransportConfigMetaData transportConfigMetaData = IORTransportConfigDefinition.INSTANCE.getTransportConfigMetaData(context, node.get(IORTransportConfigDefinition.INSTANCE.getPathElement().getKeyValuePair()));
        if (transportConfigMetaData != null) {
            securityConfigMetaData.setTransportConfig(transportConfigMetaData);
        }
        if ((asContextMetaData = IORASContextDefinition.INSTANCE.getIORASContextMetaData(context, node.get(IORASContextDefinition.INSTANCE.getPathElement().getKeyValuePair()))) != null) {
            securityConfigMetaData.setAsContext(asContextMetaData);
        }
        if ((sasContextMetaData = IORSASContextDefinition.INSTANCE.getIORSASContextMetaData(context, node.get(IORSASContextDefinition.INSTANCE.getPathElement().getKeyValuePair()))) != null) {
            securityConfigMetaData.setSasContext(sasContextMetaData);
        }
        return securityConfigMetaData;
    }

    private void configureClientSecurity(Properties props) {
        SSLConfigValue clientRequiresSSL = SSLConfigValue.fromValue(props.getProperty("client-requires"));
        CSIV2IORToSocketInfo.setClientTransportConfigMetaData(clientRequiresSSL);
    }
}

