/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.DeprecatedResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.extension.AbstractLegacyExtension;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ProfileParsingCompletionHandler;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.as.web.DefaultJsfProfileCompletionHandler;
import org.jboss.as.web.Namespace;
import org.jboss.as.web.WebAccessLogDefinition;
import org.jboss.as.web.WebAccessLogDirectoryDefinition;
import org.jboss.as.web.WebConnectorDefinition;
import org.jboss.as.web.WebContainerDefinition;
import org.jboss.as.web.WebDefinition;
import org.jboss.as.web.WebJSPDefinition;
import org.jboss.as.web.WebMessages;
import org.jboss.as.web.WebReWriteConditionDefinition;
import org.jboss.as.web.WebReWriteDefinition;
import org.jboss.as.web.WebSSLDefinition;
import org.jboss.as.web.WebSSODefinition;
import org.jboss.as.web.WebStaticResources;
import org.jboss.as.web.WebSubsystemParser;
import org.jboss.as.web.WebValveDefinition;
import org.jboss.as.web.WebVirtualHostDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class WebExtension
extends AbstractLegacyExtension {
    public static final String SUBSYSTEM_NAME = "web";
    public static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"web");
    public static final PathElement VALVE_PATH = PathElement.pathElement((String)"valve");
    protected static final PathElement CONNECTOR_PATH = PathElement.pathElement((String)"connector");
    protected static final PathElement SSL_PATH = PathElement.pathElement((String)"configuration", (String)"ssl");
    protected static final PathElement SSL_ALIAS = PathElement.pathElement((String)"ssl", (String)"configuration");
    protected static final PathElement HOST_PATH = PathElement.pathElement((String)"virtual-server");
    protected static final PathElement JSP_CONFIGURATION_PATH = PathElement.pathElement((String)"configuration", (String)"jsp-configuration");
    protected static final PathElement STATIC_RESOURCES_PATH = PathElement.pathElement((String)"configuration", (String)"static-resources");
    protected static final PathElement CONTAINER_PATH = PathElement.pathElement((String)"configuration", (String)"container");
    protected static final PathElement ACCESS_LOG_PATH = PathElement.pathElement((String)"configuration", (String)"access-log");
    protected static final PathElement ACCESS_LOG_ALIAS = PathElement.pathElement((String)"access-log", (String)"configuration");
    protected static final PathElement REWRITE_PATH = PathElement.pathElement((String)"rewrite");
    protected static final PathElement SSO_PATH = PathElement.pathElement((String)"configuration", (String)"sso");
    protected static final PathElement SSO_ALIAS = PathElement.pathElement((String)"sso", (String)"configuration");
    protected static final PathElement DIRECTORY_PATH = PathElement.pathElement((String)"setting", (String)"directory");
    protected static final PathElement DIRECTORY_ALIAS = PathElement.pathElement((String)"directory", (String)"configuration");
    protected static final PathElement REWRITECOND_PATH = PathElement.pathElement((String)"condition");
    protected static final PathElement PARAM = PathElement.pathElement((String)"param");
    private static final String RESOURCE_NAME = WebExtension.class.getPackage().getName() + ".LocalDescriptions";
    private static final ModelVersion CURRENT_MODEL_VERSION = ModelVersion.create((int)2, (int)1, (int)0);
    static final ModelVersion DEPRECATED_SINCE = ModelVersion.create((int)1, (int)5, (int)0);
    private static final String extensionName = "org.jboss.as.web";
    static final SensitiveTargetAccessConstraintDefinition WEB_CONNECTOR_CONSTRAINT = new SensitiveTargetAccessConstraintDefinition(new SensitivityClassification("web", "web-connector", false, false, false));
    static final SensitiveTargetAccessConstraintDefinition WEB_VALVE_CONSTRAINT = new SensitiveTargetAccessConstraintDefinition(new SensitivityClassification("web", "web-valve", false, false, false));

    public WebExtension() {
        super(extensionName, new String[]{SUBSYSTEM_NAME});
    }

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String keyPrefix) {
        String prefix = SUBSYSTEM_NAME + (keyPrefix == null ? "" : "." + keyPrefix);
        return new DeprecatedResourceDescriptionResolver(SUBSYSTEM_NAME, prefix, RESOURCE_NAME, WebExtension.class.getClassLoader(), true, false);
    }

    protected Set<ManagementResourceRegistration> initializeLegacyModel(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, CURRENT_MODEL_VERSION);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)WebDefinition.INSTANCE);
        subsystem.registerXMLElementWriter((XMLElementWriter)WebSubsystemParser.getInstance());
        ManagementResourceRegistration connectors = registration.registerSubModel((ResourceDefinition)WebConnectorDefinition.INSTANCE);
        ManagementResourceRegistration ssl = connectors.registerSubModel((ResourceDefinition)WebSSLDefinition.INSTANCE);
        connectors.registerAlias(SSL_ALIAS, (AliasEntry)new StandardWebExtensionAliasEntry(ssl));
        ManagementResourceRegistration hosts = registration.registerSubModel((ResourceDefinition)WebVirtualHostDefinition.INSTANCE);
        ManagementResourceRegistration accesslog = hosts.registerSubModel((ResourceDefinition)WebAccessLogDefinition.INSTANCE);
        hosts.registerAlias(ACCESS_LOG_ALIAS, (AliasEntry)new StandardWebExtensionAliasEntry(accesslog));
        ManagementResourceRegistration accessLogDir = accesslog.registerSubModel((ResourceDefinition)WebAccessLogDirectoryDefinition.INSTANCE);
        accesslog.registerAlias(DIRECTORY_ALIAS, (AliasEntry)new StandardWebExtensionAliasEntry(accessLogDir));
        ManagementResourceRegistration sso = hosts.registerSubModel((ResourceDefinition)WebSSODefinition.INSTANCE);
        hosts.registerAlias(SSO_ALIAS, (AliasEntry)new StandardWebExtensionAliasEntry(sso));
        ManagementResourceRegistration rewrite = hosts.registerSubModel((ResourceDefinition)WebReWriteDefinition.INSTANCE);
        rewrite.registerSubModel((ResourceDefinition)WebReWriteConditionDefinition.INSTANCE);
        registration.registerSubModel((ResourceDefinition)WebJSPDefinition.INSTANCE);
        registration.registerSubModel((ResourceDefinition)WebStaticResources.INSTANCE);
        registration.registerSubModel((ResourceDefinition)WebContainerDefinition.INSTANCE);
        registration.registerSubModel((ResourceDefinition)WebValveDefinition.INSTANCE);
        if (context.isRegisterTransformers()) {
            this.registerTransformers_1_1_x(subsystem, 0);
            this.registerTransformers_1_1_x(subsystem, 1);
            this.registerTransformers_1_2_0(subsystem);
            this.registerTransformers_1_3_0(subsystem);
            this.registerTransformers_1_4_0(subsystem);
            this.registerTransformers_2_0_0(subsystem);
        }
        return Collections.singleton(registration);
    }

    protected void initializeLegacyParsers(ExtensionParsingContext context) {
        for (Namespace ns : Namespace.values()) {
            if (ns.getUriString() == null) continue;
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, ns.getUriString(), (XMLElementReader)WebSubsystemParser.getInstance());
        }
        context.setProfileParsingCompletionHandler((ProfileParsingCompletionHandler)new DefaultJsfProfileCompletionHandler());
    }

    private void registerTransformers_1_1_x(SubsystemRegistration registration, int micro) {
        int defaultRedirectPort = 443;
        ResourceTransformationDescriptionBuilder subsystemRoot = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)subsystemRoot.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{WebDefinition.DEFAULT_SESSION_TIMEOUT})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(false, true, new ModelNode[]{new ModelNode(30)}), new AttributeDefinition[]{WebDefinition.DEFAULT_SESSION_TIMEOUT})).end();
        subsystemRoot.rejectChildResource(VALVE_PATH);
        subsystemRoot.addChildResource(JSP_CONFIGURATION_PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, (AttributeDefinition[])WebJSPDefinition.JSP_ATTRIBUTES);
        subsystemRoot.addChildResource(STATIC_RESOURCES_PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, (AttributeDefinition[])WebStaticResources.STATIC_ATTRIBUTES);
        subsystemRoot.addChildResource(CONTAINER_PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, WebContainerDefinition.CONTAINER_ATTRIBUTES);
        ResourceTransformationDescriptionBuilder connectorBuilder = subsystemRoot.addChildResource(CONNECTOR_PATH);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)connectorBuilder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, WebConnectorDefinition.CONNECTOR_ATTRIBUTES)).setValueConverter((AttributeConverter)new AttributeConverter.DefaultAttributeConverter(){

            protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                if (!attributeValue.isDefined()) {
                    attributeValue.set(443);
                }
            }
        }, new String[]{WebConnectorDefinition.REDIRECT_PORT.getName()})).end().addOperationTransformationOverride("undefine-attribute").inheritResourceAttributeDefinitions().setCustomOperationTransformer(new OperationTransformer(){

            public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
                String attributeName = operation.require("name").asString();
                if (WebConnectorDefinition.REDIRECT_PORT.getName().equals(attributeName)) {
                    ModelNode transformed = new ModelNode();
                    transformed.get("operation").set("write-attribute");
                    transformed.get("address").set(address.toModelNode());
                    transformed.get("name").set(attributeName);
                    transformed.get("value").set(443);
                    return new OperationTransformer.TransformedOperation(transformed, OperationResultTransformer.ORIGINAL_RESULT);
                }
                return new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT);
            }
        });
        if (micro == 0) {
            connectorBuilder.getAttributeBuilder().addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.DefaultRejectAttributeChecker(){

                protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                    return attributeValue.isDefined();
                }

                public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
                    return WebMessages.MESSAGES.transformationVersion_1_1_0_JBPAPP_9314();
                }
            }, new String[]{"virtual-server"});
        }
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)connectorBuilder.addChildRedirection(SSL_PATH, SSL_ALIAS).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, (AttributeDefinition[])WebSSLDefinition.SSL_ATTRIBUTES)).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{WebSSLDefinition.SSL_PROTOCOL})).addRejectCheck(RejectAttributeChecker.UNDEFINED, new AttributeDefinition[]{WebSSLDefinition.CIPHER_SUITE})).setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{WebSSLDefinition.SSL_PROTOCOL})).setValueConverter((AttributeConverter)new AttributeConverter.DefaultAttributeConverter(){

            protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                if (attributeValue.isDefined() && attributeValue.asString().equals(address.getLastElement().getKey())) {
                    attributeValue.clear();
                }
            }
        }, new AttributeDefinition[]{WebSSLDefinition.NAME})).end();
        ResourceTransformationDescriptionBuilder hostBuilder = ((AttributeTransformationDescriptionBuilder)subsystemRoot.addChildResource(HOST_PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{WebVirtualHostDefinition.DEFAULT_WEB_MODULE})).end();
        ResourceTransformationDescriptionBuilder rewriteBuilder = ((AttributeTransformationDescriptionBuilder)hostBuilder.addChildResource(REWRITE_PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{WebReWriteDefinition.FLAGS, WebReWriteDefinition.PATTERN, WebReWriteDefinition.SUBSTITUTION})).end();
        ((AttributeTransformationDescriptionBuilder)rewriteBuilder.addChildResource(REWRITECOND_PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, (AttributeDefinition[])WebReWriteConditionDefinition.ATTRIBUTES)).addRejectCheck(RejectAttributeChecker.UNDEFINED, new AttributeDefinition[]{WebReWriteConditionDefinition.FLAGS});
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)hostBuilder.addChildRedirection(SSO_PATH, SSO_ALIAS).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, (AttributeDefinition[])WebSSODefinition.SSO_ATTRIBUTES)).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{WebSSODefinition.HTTP_ONLY})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(false, true, new ModelNode[]{new ModelNode(true)}), new AttributeDefinition[]{WebSSODefinition.HTTP_ONLY})).end();
        ResourceTransformationDescriptionBuilder accessLogBuilder = ((AttributeTransformationDescriptionBuilder)hostBuilder.addChildRedirection(ACCESS_LOG_PATH, ACCESS_LOG_ALIAS).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, (AttributeDefinition[])WebAccessLogDefinition.ACCESS_LOG_ATTRIBUTES)).end();
        accessLogBuilder.addChildRedirection(DIRECTORY_PATH, DIRECTORY_ALIAS);
        TransformationDescription.Tools.register((TransformationDescription)subsystemRoot.build(), (SubsystemRegistration)registration, (ModelVersionRange)ModelVersion.create((int)1, (int)1, (int)micro));
    }

    private void registerTransformers_1_2_0(SubsystemRegistration registration) {
        ResourceTransformationDescriptionBuilder subsystemRoot = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)subsystemRoot.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{WebDefinition.DEFAULT_SESSION_TIMEOUT})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(false, true, new ModelNode[]{new ModelNode(30)}), new AttributeDefinition[]{WebDefinition.DEFAULT_SESSION_TIMEOUT})).end();
        ResourceTransformationDescriptionBuilder hostBuilder = subsystemRoot.addChildResource(HOST_PATH);
        ResourceTransformationDescriptionBuilder rewriteBuilder = hostBuilder.addChildResource(REWRITE_PATH);
        rewriteBuilder.addChildResource(REWRITECOND_PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.UNDEFINED, new AttributeDefinition[]{WebReWriteConditionDefinition.FLAGS});
        ResourceTransformationDescriptionBuilder ssoBuilder = hostBuilder.addChildResource(SSO_PATH);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)ssoBuilder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{WebSSODefinition.HTTP_ONLY})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(false, true, new ModelNode[]{new ModelNode(true)}), new AttributeDefinition[]{WebSSODefinition.HTTP_ONLY})).end();
        ResourceTransformationDescriptionBuilder connectorBuilder = subsystemRoot.addChildResource(CONNECTOR_PATH);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)connectorBuilder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{WebConnectorDefinition.PROXY_BINDING, WebConnectorDefinition.REDIRECT_BINDING})).setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{WebConnectorDefinition.PROXY_BINDING, WebConnectorDefinition.REDIRECT_BINDING})).end().addChildResource(SSL_PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.UNDEFINED, new AttributeDefinition[]{WebSSLDefinition.CIPHER_SUITE})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{WebSSLDefinition.SSL_PROTOCOL})).setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{WebSSLDefinition.SSL_PROTOCOL});
        TransformationDescription.Tools.register((TransformationDescription)subsystemRoot.build(), (SubsystemRegistration)registration, (ModelVersionRange)ModelVersion.create((int)1, (int)2, (int)0));
    }

    private void registerTransformers_1_3_0(SubsystemRegistration registration) {
        ResourceTransformationDescriptionBuilder subsystemRoot = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)subsystemRoot.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{WebDefinition.DEFAULT_SESSION_TIMEOUT})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(false, true, new ModelNode[]{new ModelNode(30)}), new AttributeDefinition[]{WebDefinition.DEFAULT_SESSION_TIMEOUT})).end();
        ResourceTransformationDescriptionBuilder hostBuilder = subsystemRoot.addChildResource(HOST_PATH);
        ResourceTransformationDescriptionBuilder ssoBuilder = hostBuilder.addChildResource(SSO_PATH);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)ssoBuilder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{WebSSODefinition.HTTP_ONLY})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(false, true, new ModelNode[]{new ModelNode(true)}), new AttributeDefinition[]{WebSSODefinition.HTTP_ONLY})).end();
        ResourceTransformationDescriptionBuilder connectorBuilder = subsystemRoot.addChildResource(CONNECTOR_PATH);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)connectorBuilder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{WebConnectorDefinition.PROXY_BINDING, WebConnectorDefinition.REDIRECT_BINDING})).setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{WebSSLDefinition.SSL_PROTOCOL, WebConnectorDefinition.PROXY_BINDING, WebConnectorDefinition.REDIRECT_BINDING})).end();
        ((AttributeTransformationDescriptionBuilder)connectorBuilder.addChildResource(SSL_PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.UNDEFINED, new AttributeDefinition[]{WebSSLDefinition.CIPHER_SUITE})).end();
        TransformationDescription.Tools.register((TransformationDescription)subsystemRoot.build(), (SubsystemRegistration)registration, (ModelVersionRange)ModelVersion.create((int)1, (int)3, (int)0));
    }

    private void registerTransformers_1_4_0(SubsystemRegistration registration) {
        ResourceTransformationDescriptionBuilder subsystemRoot = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)subsystemRoot.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{WebDefinition.DEFAULT_SESSION_TIMEOUT})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(false, true, new ModelNode[]{new ModelNode(30)}), new AttributeDefinition[]{WebDefinition.DEFAULT_SESSION_TIMEOUT})).end();
        ResourceTransformationDescriptionBuilder hostBuilder = subsystemRoot.addChildResource(HOST_PATH);
        ResourceTransformationDescriptionBuilder ssoBuilder = hostBuilder.addChildResource(SSO_PATH);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)ssoBuilder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{WebSSODefinition.HTTP_ONLY})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(false, true, new ModelNode[]{new ModelNode(true)}), new AttributeDefinition[]{WebSSODefinition.HTTP_ONLY})).end();
        TransformationDescription.Tools.register((TransformationDescription)subsystemRoot.build(), (SubsystemRegistration)registration, (ModelVersionRange)ModelVersion.create((int)1, (int)4, (int)0));
    }

    private void registerTransformers_2_0_0(SubsystemRegistration registration) {
        ResourceTransformationDescriptionBuilder subsystemRoot = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)subsystemRoot.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{WebDefinition.DEFAULT_SESSION_TIMEOUT})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(false, true, new ModelNode[]{new ModelNode(30)}), new AttributeDefinition[]{WebDefinition.DEFAULT_SESSION_TIMEOUT})).end();
        ResourceTransformationDescriptionBuilder hostBuilder = subsystemRoot.addChildResource(HOST_PATH);
        ResourceTransformationDescriptionBuilder ssoBuilder = hostBuilder.addChildResource(SSO_PATH);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)ssoBuilder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{WebSSODefinition.HTTP_ONLY})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(false, true, new ModelNode[]{new ModelNode(true)}), new AttributeDefinition[]{WebSSODefinition.HTTP_ONLY})).end();
        ResourceTransformationDescriptionBuilder connectorBuilder = subsystemRoot.addChildResource(CONNECTOR_PATH);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)connectorBuilder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{WebConnectorDefinition.PROXY_BINDING, WebConnectorDefinition.REDIRECT_BINDING})).setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{WebSSLDefinition.SSL_PROTOCOL, WebConnectorDefinition.PROXY_BINDING, WebConnectorDefinition.REDIRECT_BINDING})).end();
        ((AttributeTransformationDescriptionBuilder)connectorBuilder.addChildResource(SSL_PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.UNDEFINED, new AttributeDefinition[]{WebSSLDefinition.CIPHER_SUITE})).end();
        TransformationDescription.Tools.register((TransformationDescription)subsystemRoot.build(), (SubsystemRegistration)registration, (ModelVersionRange)ModelVersion.create((int)2, (int)0, (int)0));
    }

    private static class StandardWebExtensionAliasEntry
    extends AliasEntry {
        public StandardWebExtensionAliasEntry(ManagementResourceRegistration target) {
            super(target);
        }

        public PathAddress convertToTargetAddress(PathAddress addr) {
            PathAddress targetAddress = this.getTargetAddress();
            ArrayList<PathElement> list = new ArrayList<PathElement>();
            int i = 0;
            for (PathElement element : addr) {
                String key = element.getKey();
                try {
                    if (i < targetAddress.size() && (key.equals("ssl") || key.equals("sso") || key.equals("access-log") || key.equals("directory"))) {
                        list.add(targetAddress.getElement(i));
                    } else {
                        list.add(element);
                    }
                    ++i;
                }
                catch (Exception e) {
                    throw new RuntimeException("Bad " + addr + " " + targetAddress);
                }
            }
            return PathAddress.pathAddress(list);
        }
    }
}

