/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.provider;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.provider.ServiceProviderRegistration;
import org.wildfly.clustering.provider.ServiceProviderRegistrationFactory;
import org.wildfly.clustering.server.provider.AbstractServiceProviderRegistration;

public class LocalServiceProviderRegistrationFactory
implements ServiceProviderRegistrationFactory {
    final Set<Object> services = Collections.synchronizedSet(new HashSet());
    private final Group group;

    public LocalServiceProviderRegistrationFactory(Group group) {
        this.group = group;
    }

    public Group getGroup() {
        return this.group;
    }

    public ServiceProviderRegistration createRegistration(final Object service, ServiceProviderRegistration.Listener listener) {
        this.services.add(service);
        return new AbstractServiceProviderRegistration(service, this){

            public void close() {
                LocalServiceProviderRegistrationFactory.this.services.remove(service);
            }
        };
    }

    public Set<Node> getProviders(Object service) {
        return this.services.contains(service) ? Collections.singleton(this.getGroup().getLocalNode()) : Collections.emptySet();
    }
}

