/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.Extension;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.weld.WeldModuleResourceLoader;
import org.jboss.as.weld.deployment.BeanDeploymentArchiveImpl;
import org.jboss.as.weld.deployment.BeanDeploymentModule;
import org.jboss.as.weld.discovery.WeldAnnotationDiscovery;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.as.weld.services.bootstrap.ProxyServicesImpl;
import org.jboss.modules.Module;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.bootstrap.spi.CDI11Deployment;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.resources.spi.AnnotationDiscovery;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.serialization.spi.ProxyServices;
import org.wildfly.security.manager.WildFlySecurityManager;

public class WeldDeployment
implements CDI11Deployment {
    public static final String ADDITIONAL_CLASSES_BDA_SUFFIX = ".additionalClasses";
    public static final String BOOTSTRAP_CLASSLOADER_BDA_ID = "bootstrapBDA.additionalClasses";
    private final Set<BeanDeploymentArchiveImpl> beanDeploymentArchives;
    private final Set<Metadata<Extension>> extensions;
    private final ServiceRegistry serviceRegistry;
    private final Module module;
    private final Set<ClassLoader> subDeploymentClassLoaders;
    private final Map<ClassLoader, BeanDeploymentArchiveImpl> additionalBeanDeploymentArchivesByClassloader;
    private final BeanDeploymentModule rootBeanDeploymentModule;

    public WeldDeployment(Set<BeanDeploymentArchiveImpl> beanDeploymentArchives, Collection<Metadata<Extension>> extensions, Module module, Set<ClassLoader> subDeploymentClassLoaders, DeploymentUnit deploymentUnit, BeanDeploymentModule rootBeanDeploymentModule) {
        this.subDeploymentClassLoaders = new HashSet<ClassLoader>(subDeploymentClassLoaders);
        this.beanDeploymentArchives = new HashSet<BeanDeploymentArchiveImpl>(beanDeploymentArchives);
        this.extensions = new HashSet<Metadata<Extension>>(extensions);
        this.serviceRegistry = new SimpleServiceRegistry();
        this.additionalBeanDeploymentArchivesByClassloader = new HashMap<ClassLoader, BeanDeploymentArchiveImpl>();
        this.module = module;
        this.rootBeanDeploymentModule = rootBeanDeploymentModule;
        this.serviceRegistry.add(ProxyServices.class, (Service)new ProxyServicesImpl(module));
        this.serviceRegistry.add(ResourceLoader.class, (Service)new WeldModuleResourceLoader(module));
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (index != null) {
            this.serviceRegistry.add(AnnotationDiscovery.class, (Service)new WeldAnnotationDiscovery(index));
        }
        this.calculateAccessibilityGraph(this.beanDeploymentArchives);
        this.makeTopLevelBdasVisibleFromStaticModules();
    }

    private void calculateAccessibilityGraph(Iterable<BeanDeploymentArchiveImpl> beanDeploymentArchives) {
        for (BeanDeploymentArchiveImpl from : beanDeploymentArchives) {
            for (BeanDeploymentArchiveImpl target : beanDeploymentArchives) {
                if (!from.isAccessible(target)) continue;
                from.addBeanDeploymentArchive(target);
            }
        }
    }

    private void makeTopLevelBdasVisibleFromStaticModules() {
        for (BeanDeploymentArchiveImpl bda : this.beanDeploymentArchives) {
            if (!bda.getBeanArchiveType().equals((Object)BeanDeploymentArchiveImpl.BeanArchiveType.EXTERNAL) && !bda.getBeanArchiveType().equals((Object)BeanDeploymentArchiveImpl.BeanArchiveType.SYNTHETIC)) continue;
            for (BeanDeploymentArchiveImpl topLevelBda : this.rootBeanDeploymentModule.getBeanDeploymentArchives()) {
                bda.addBeanDeploymentArchive(topLevelBda);
            }
        }
    }

    public Collection<BeanDeploymentArchive> getBeanDeploymentArchives() {
        return Collections.unmodifiableSet(new HashSet<BeanDeploymentArchiveImpl>(this.beanDeploymentArchives));
    }

    public Iterable<Metadata<Extension>> getExtensions() {
        return Collections.unmodifiableSet(this.extensions);
    }

    public ServiceRegistry getServices() {
        return this.serviceRegistry;
    }

    public synchronized BeanDeploymentArchive loadBeanDeploymentArchive(Class<?> beanClass) {
        BeanDeploymentArchive bda = this.getBeanDeploymentArchive(beanClass);
        if (bda != null) {
            return bda;
        }
        return this.createAndRegisterAdditionalBeanDeploymentArchive(beanClass);
    }

    protected BeanDeploymentArchiveImpl createAndRegisterAdditionalBeanDeploymentArchive(Class<?> beanClass) {
        Module module = Module.forClass(beanClass);
        String id = null;
        id = module == null ? BOOTSTRAP_CLASSLOADER_BDA_ID : module.getIdentifier() + ADDITIONAL_CLASSES_BDA_SUFFIX;
        BeanDeploymentArchiveImpl newBda = new BeanDeploymentArchiveImpl(Collections.singleton(beanClass.getName()), BeansXml.EMPTY_BEANS_XML, module, id, BeanDeploymentArchiveImpl.BeanArchiveType.SYNTHETIC, false);
        WeldLogger.DEPLOYMENT_LOGGER.beanArchiveDiscovered(newBda);
        newBda.addBeanClass(beanClass);
        newBda.getServices().addAll((Collection)this.serviceRegistry.entrySet());
        for (BeanDeploymentArchiveImpl bda : this.beanDeploymentArchives) {
            if (!newBda.isAccessible(bda)) continue;
            newBda.addBeanDeploymentArchive(bda);
        }
        for (BeanDeploymentArchiveImpl bda : this.beanDeploymentArchives) {
            if (!bda.isAccessible(newBda)) continue;
            bda.addBeanDeploymentArchive(newBda);
        }
        newBda.addBeanDeploymentArchives(this.rootBeanDeploymentModule.getBeanDeploymentArchives());
        this.additionalBeanDeploymentArchivesByClassloader.put(beanClass.getClassLoader(), newBda);
        this.beanDeploymentArchives.add(newBda);
        return newBda;
    }

    public Module getModule() {
        return this.module;
    }

    public Set<ClassLoader> getSubDeploymentClassLoaders() {
        return Collections.unmodifiableSet(this.subDeploymentClassLoaders);
    }

    public synchronized <T extends Service> void addWeldService(Class<T> type, T service) {
        this.serviceRegistry.add(type, service);
        for (BeanDeploymentArchiveImpl bda : this.additionalBeanDeploymentArchivesByClassloader.values()) {
            bda.getServices().add(type, service);
        }
    }

    public synchronized BeanDeploymentArchive getBeanDeploymentArchive(Class<?> beanClass) {
        ClassLoader moduleClassLoader = WildFlySecurityManager.getClassLoaderPrivileged(beanClass);
        for (BeanDeploymentArchiveImpl bda : this.beanDeploymentArchives) {
            if (!bda.getBeanClasses().contains(beanClass.getName()) || moduleClassLoader == null || !moduleClassLoader.equals(beanClass.getClassLoader())) continue;
            return bda;
        }
        if (this.additionalBeanDeploymentArchivesByClassloader.containsKey(moduleClassLoader)) {
            return this.additionalBeanDeploymentArchivesByClassloader.get(moduleClassLoader);
        }
        return null;
    }
}

