/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.compensations.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.narayana.compensations.api.ConfirmationHandler;
import org.jboss.narayana.compensations.api.NoTransactionException;
import org.jboss.narayana.compensations.api.TxConfirm;
import org.jboss.narayana.compensations.impl.BAControler;
import org.jboss.narayana.compensations.impl.BAControllerFactory;
import org.jboss.narayana.compensations.impl.ParticipantInterceptor;
import org.jboss.narayana.compensations.impl.ParticipantManager;

@TxConfirm
@Interceptor
@Priority(value=198)
public class TxConfirmInterceptor
extends ParticipantInterceptor {
    @Override
    @AroundInvoke
    public Object intercept(InvocationContext ic) throws Exception {
        return super.intercept(ic);
    }

    @Override
    protected ParticipantManager enlistParticipant(Method method) throws Exception {
        BAControler baControler = BAControllerFactory.getInstance();
        if (!baControler.isBARunning()) {
            throw new NoTransactionException("Methods annotated with '" + TxConfirm.class.getName() + "' must be invoked in the context of a compensation based transaction");
        }
        Class<? extends ConfirmationHandler> confirmationHandler = this.getConfirmationHandler(method);
        return baControler.enlist(null, confirmationHandler, null);
    }

    private Class<? extends ConfirmationHandler> getConfirmationHandler(Method method) {
        Annotation[] annotations;
        for (Annotation a : annotations = method.getAnnotations()) {
            if (!(a instanceof TxConfirm)) continue;
            return ((TxConfirm)a).value();
        }
        return null;
    }
}

