/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.idl.toJavaPortable;

import com.sun.tools.corba.se.idl.InvalidArgument;
import com.sun.tools.corba.se.idl.toJavaPortable.NameModifier;
import com.sun.tools.corba.se.idl.toJavaPortable.NameModifierImpl;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class Arguments
extends com.sun.tools.corba.se.idl.Arguments {
    public Hashtable packages = new Hashtable();
    public String separator = null;
    public static final int None = 0;
    public static final int Client = 1;
    public static final int Server = 2;
    public static final int All = 3;
    public int emit = 0;
    public boolean TIEServer = false;
    public boolean POAServer = true;
    public boolean LocalOptimization = false;
    public NameModifier skeletonNameModifier = null;
    public NameModifier tieNameModifier = null;
    public Hashtable packageTranslation = new Hashtable();
    public String targetDir = "";

    public Arguments() {
        this.corbaLevel = 2.4f;
    }

    @Override
    protected void parseOtherArgs(String[] args, Properties properties) throws InvalidArgument {
        String skeletonPattern = null;
        String tiePattern = null;
        this.packages.put("CORBA", "org.omg");
        this.packageFromProps(properties);
        try {
            Vector unknownArgs = new Vector();
            for (int i = 0; i < args.length; ++i) {
                String lcArg = args[i].toLowerCase();
                if (lcArg.charAt(0) != '-' && lcArg.charAt(0) != '/') {
                    throw new InvalidArgument(args[i]);
                }
                if (lcArg.charAt(0) == '-') {
                    lcArg = lcArg.substring(1);
                }
                if (lcArg.startsWith("f")) {
                    if (lcArg.equals("f")) {
                        lcArg = 'f' + args[++i].toLowerCase();
                    }
                    if (lcArg.equals("fclient")) {
                        this.emit = this.emit == 2 || this.emit == 3 ? 3 : 1;
                        continue;
                    }
                    if (lcArg.equals("fserver")) {
                        this.emit = this.emit == 1 || this.emit == 3 ? 3 : 2;
                        this.TIEServer = false;
                        continue;
                    }
                    if (lcArg.equals("fall")) {
                        this.emit = 3;
                        this.TIEServer = false;
                        continue;
                    }
                    if (lcArg.equals("fservertie")) {
                        this.emit = this.emit == 1 || this.emit == 3 ? 3 : 2;
                        this.TIEServer = true;
                        continue;
                    }
                    if (lcArg.equals("falltie")) {
                        this.emit = 3;
                        this.TIEServer = true;
                        continue;
                    }
                    i = this.collectUnknownArg(args, i, unknownArgs);
                    continue;
                }
                if (lcArg.equals("pkgtranslate")) {
                    if (i + 2 >= args.length) {
                        throw new InvalidArgument(args[i]);
                    }
                    String orig = args[++i];
                    String trans = args[++i];
                    this.checkPackageNameValid(orig);
                    this.checkPackageNameValid(trans);
                    if (orig.equals("org") || orig.startsWith("org.omg")) {
                        throw new InvalidArgument(args[i]);
                    }
                    orig = orig.replace('.', '/');
                    trans = trans.replace('.', '/');
                    this.packageTranslation.put(orig, trans);
                    continue;
                }
                if (lcArg.equals("pkgprefix")) {
                    if (i + 2 >= args.length) {
                        throw new InvalidArgument(args[i]);
                    }
                    String type = args[++i];
                    String pkg = args[++i];
                    this.checkPackageNameValid(type);
                    this.checkPackageNameValid(pkg);
                    this.packages.put(type, pkg);
                    continue;
                }
                if (lcArg.equals("td")) {
                    String trgtDir;
                    if (i + 1 >= args.length) {
                        throw new InvalidArgument(args[i]);
                    }
                    if ((trgtDir = args[++i]).charAt(0) == '-') {
                        throw new InvalidArgument(args[i - 1]);
                    }
                    this.targetDir = trgtDir.replace('/', File.separatorChar);
                    if (this.targetDir.charAt(this.targetDir.length() - 1) == File.separatorChar) continue;
                    this.targetDir = this.targetDir + File.separatorChar;
                    continue;
                }
                if (lcArg.equals("sep")) {
                    if (i + 1 >= args.length) {
                        throw new InvalidArgument(args[i]);
                    }
                    this.separator = args[++i];
                    continue;
                }
                if (lcArg.equals("oldimplbase")) {
                    this.POAServer = false;
                    continue;
                }
                if (lcArg.equals("skeletonname")) {
                    if (i + 1 >= args.length) {
                        throw new InvalidArgument(args[i]);
                    }
                    skeletonPattern = args[++i];
                    continue;
                }
                if (lcArg.equals("tiename")) {
                    if (i + 1 >= args.length) {
                        throw new InvalidArgument(args[i]);
                    }
                    tiePattern = args[++i];
                    continue;
                }
                if (lcArg.equals("localoptimization")) {
                    this.LocalOptimization = true;
                    continue;
                }
                i = this.collectUnknownArg(args, i, unknownArgs);
            }
            if (unknownArgs.size() > 0) {
                Object[] otherArgs = new String[unknownArgs.size()];
                unknownArgs.copyInto(otherArgs);
                super.parseOtherArgs((String[])otherArgs, properties);
            }
            this.setDefaultEmitter();
            this.setNameModifiers(skeletonPattern, tiePattern);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new InvalidArgument(args[args.length - 1]);
        }
    }

    protected int collectUnknownArg(String[] args, int i, Vector unknownArgs) {
        unknownArgs.addElement(args[i]);
        ++i;
        while (i < args.length && args[i].charAt(0) != '-' && args[i].charAt(0) != '/') {
            unknownArgs.addElement(args[i++]);
        }
        return --i;
    }

    protected void packageFromProps(Properties props) throws InvalidArgument {
        Enumeration<?> propsEnum = props.propertyNames();
        while (propsEnum.hasMoreElements()) {
            String prop = (String)propsEnum.nextElement();
            if (!prop.startsWith("PkgPrefix.")) continue;
            String type = prop.substring(10);
            String pkg = props.getProperty(prop);
            this.checkPackageNameValid(pkg);
            this.checkPackageNameValid(type);
            this.packages.put(type, pkg);
        }
    }

    protected void setDefaultEmitter() {
        if (this.emit == 0) {
            this.emit = 1;
        }
    }

    protected void setNameModifiers(String skeletonPattern, String tiePattern) {
        if (this.emit > 1) {
            String sp = skeletonPattern != null ? skeletonPattern : (this.POAServer ? "%POA" : "_%ImplBase");
            String tp = tiePattern != null ? tiePattern : (this.POAServer ? "%POATie" : "%_Tie");
            this.skeletonNameModifier = new NameModifierImpl(sp);
            this.tieNameModifier = new NameModifierImpl(tp);
        }
    }

    private void checkPackageNameValid(String name) throws InvalidArgument {
        if (name.charAt(0) == '.') {
            throw new InvalidArgument(name);
        }
        for (int i = 0; i < name.length(); ++i) {
            if (!(name.charAt(i) == '.' ? i == name.length() - 1 || !Character.isJavaIdentifierStart(name.charAt(++i)) : !Character.isJavaIdentifierPart(name.charAt(i)))) continue;
            throw new InvalidArgument(name);
        }
    }
}

