/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.management;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.controller.registry.AbstractModelResource;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.registry.ResourceProvider;
import org.jboss.as.patching.installation.InstallationManager;
import org.jboss.as.patching.installation.InstalledIdentity;
import org.jboss.as.patching.installation.PatchableTarget;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

class PatchResource
extends AbstractModelResource {
    private final ModelNode model = new ModelNode();

    protected PatchResource(ServiceController<InstallationManager> imController) {
        super.registerResourceProvider("layer", (ResourceProvider)new LayerResourceProvider(imController));
        super.registerResourceProvider("addon", (ResourceProvider)new AddOnResourceProvider(imController));
        this.model.protect();
    }

    public ModelNode getModel() {
        return this.model;
    }

    public void writeModel(ModelNode newModel) {
        throw new UnsupportedOperationException();
    }

    public boolean isModelDefined() {
        return this.model.isDefined();
    }

    public boolean isRuntime() {
        return true;
    }

    public Resource clone() {
        return this;
    }

    abstract class ElementProviderResourceProvider
    implements ResourceProvider {
        protected final ServiceController<InstallationManager> imController;

        ElementProviderResourceProvider(ServiceController<InstallationManager> imController) {
            if (imController == null) {
                throw new IllegalArgumentException("Installation manager service controller is null");
            }
            this.imController = imController;
        }

        protected abstract Collection<? extends PatchableTarget> getChildTargets(InstalledIdentity var1);

        public boolean has(String name) {
            return this.children().contains(name);
        }

        public Resource get(String name) {
            return PlaceholderResource.INSTANCE;
        }

        public boolean hasChildren() {
            return !this.children().isEmpty();
        }

        public Set<String> children() {
            InstallationManager manager = this.getInstallationManager();
            if (manager == null) {
                return Collections.emptySet();
            }
            Collection<? extends PatchableTarget> targets = this.getChildTargets(manager);
            if (targets.isEmpty()) {
                return Collections.emptySet();
            }
            if (targets.size() == 1) {
                PatchableTarget target = targets.iterator().next();
                return Collections.singleton(target.getName());
            }
            HashSet<String> names = new HashSet<String>(targets.size());
            for (PatchableTarget patchableTarget : targets) {
                names.add(patchableTarget.getName());
            }
            return names;
        }

        public void register(String name, Resource resource) {
            throw new UnsupportedOperationException();
        }

        public Resource remove(String name) {
            throw new UnsupportedOperationException();
        }

        public ResourceProvider clone() {
            return this;
        }

        private InstallationManager getInstallationManager() {
            while (this.imController != null && this.imController.getState() == ServiceController.State.UP) {
                try {
                    return (InstallationManager)this.imController.getValue();
                }
                catch (IllegalStateException illegalStateException) {
                }
            }
            return null;
        }
    }

    class AddOnResourceProvider
    extends ElementProviderResourceProvider {
        AddOnResourceProvider(ServiceController<InstallationManager> imController) {
            super(imController);
        }

        @Override
        protected Collection<? extends PatchableTarget> getChildTargets(InstalledIdentity identity) {
            return identity.getAddOns();
        }
    }

    class LayerResourceProvider
    extends ElementProviderResourceProvider {
        LayerResourceProvider(ServiceController<InstallationManager> imController) {
            super(imController);
        }

        @Override
        protected Collection<? extends PatchableTarget> getChildTargets(InstalledIdentity identity) {
            return identity.getLayers();
        }
    }
}

