/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.bean;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.commons.marshall.Externalizer;
import org.jboss.ejb.client.SessionID;
import org.wildfly.clustering.ejb.infinispan.SessionIDExternalizer;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanKey;
import org.wildfly.clustering.infinispan.spi.io.AbstractSimpleExternalizer;

public class InfinispanBeanKeyExternalizer
extends AbstractSimpleExternalizer<InfinispanBeanKey<SessionID>> {
    private static final long serialVersionUID = -7421324153578768415L;
    private final Externalizer<SessionID> externalizer = new SessionIDExternalizer();

    public InfinispanBeanKeyExternalizer() {
        this(InfinispanBeanKey.class);
    }

    private InfinispanBeanKeyExternalizer(Class targetClass) {
        super(targetClass);
    }

    public void writeObject(ObjectOutput output, InfinispanBeanKey<SessionID> key) throws IOException {
        output.writeUTF(key.getBeanName());
        this.externalizer.writeObject(output, (Object)key.getId());
    }

    public InfinispanBeanKey<SessionID> readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        String beanName = input.readUTF();
        SessionID id = (SessionID)this.externalizer.readObject(input);
        return new InfinispanBeanKey<SessionID>(beanName, id);
    }
}

