/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import org.jboss.as.connector.subsystems.datasources.Constants;
import org.jboss.as.connector.subsystems.datasources.XADataSourceConfigService;
import org.jboss.as.connector.subsystems.datasources.XaDataSourcePropertiesService;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;

public class XaDataSourcePropertyAdd
extends AbstractAddStepHandler {
    public static final XaDataSourcePropertyAdd INSTANCE = new XaDataSourcePropertyAdd();

    protected void populateModel(ModelNode operation, ModelNode modelNode) throws OperationFailedException {
        Constants.XADATASOURCE_PROPERTY_VALUE.validateAndSet(operation, modelNode);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode recoveryEnvModel) throws OperationFailedException {
        ServiceName dataSourceConfigServiceName;
        String configPropertyValue = Constants.XADATASOURCE_PROPERTY_VALUE.resolveModelAttribute(context, recoveryEnvModel).asString();
        ModelNode address = operation.require("address");
        PathAddress path = PathAddress.pathAddress((ModelNode)address);
        String dsName = path.getElement(path.size() - 2).getValue();
        String configPropertyName = PathAddress.pathAddress((ModelNode)address).getLastElement().getValue();
        ServiceName serviceName = XADataSourceConfigService.SERVICE_NAME_BASE.append(new String[]{dsName}).append(new String[]{"xa-datasource-properties"}).append(new String[]{configPropertyName});
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController dataSourceConfigController = registry.getService(dataSourceConfigServiceName = XADataSourceConfigService.SERVICE_NAME_BASE.append(new String[]{dsName}));
        if (dataSourceConfigController == null || !((XaDataSource)dataSourceConfigController.getValue()).isEnabled().booleanValue()) {
            ServiceTarget serviceTarget = context.getServiceTarget();
            XaDataSourcePropertiesService service = new XaDataSourcePropertiesService(configPropertyName, configPropertyValue);
            ServiceController controller = serviceTarget.addService(serviceName, (Service)service).setInitialMode(ServiceController.Mode.NEVER).install();
        } else {
            context.reloadRequired();
        }
    }
}

